/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.instreamads;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.b;
import com.my.target.b1;
import com.my.target.c9;
import com.my.target.common.BaseAd;
import com.my.target.common.menu.MenuFactory;
import com.my.target.common.models.ImageData;
import com.my.target.common.models.ShoppableAdsItem;
import com.my.target.common.models.VideoData;
import com.my.target.f2;
import com.my.target.f8;
import com.my.target.g2;
import com.my.target.instreamads.InstreamAdPlayer;
import com.my.target.j;
import com.my.target.j2;
import com.my.target.k4;
import com.my.target.m2;
import com.my.target.m4;
import com.my.target.n4;
import com.my.target.o;
import com.my.target.y4;
import com.my.target.z0;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class InstreamAd
extends BaseAd {
    private static final int DEFAULT_LOADING_TIMEOUT_SECONDS = 10;
    private static final int MIN_LOADING_TIMEOUT_SECONDS = 5;
    @NonNull
    private final Context context;
    @NonNull
    private final MenuFactory adChoicesMenuFactory;
    @Nullable
    private j2 section;
    @Nullable
    private f2 engine;
    @Nullable
    private InstreamAdPlayer player;
    @Nullable
    private InstreamAdListener listener;
    private int loadingTimeoutSeconds;
    private boolean isFullscreen;
    @Nullable
    private float[] midpoints;
    @Nullable
    private float[] userMidpoints;
    private float videoDuration;
    private float volume;

    /*
     * WARNING - void declaration
     */
    public InstreamAd(int slotId, @NonNull Context context) {
        super((int)var1_1, "instreamads");
        b1 b12;
        void var2_2;
        void var1_1;
        ((InstreamAd)((Object)this_)).loadingTimeoutSeconds = 10;
        ((InstreamAd)((Object)this_)).volume = 1.0f;
        ((InstreamAd)((Object)this_)).context = var2_2;
        b1 this_ = b12;
        b12 = new b1();
        v1.adChoicesMenuFactory = this_;
        c9.c("Instream ad created. Version - 5.16.3");
    }

    /*
     * WARNING - void declaration
     */
    public InstreamAd(int slotId, @NonNull MenuFactory adChoicesMenuFactory, @NonNull Context context) {
        super((int)var1_1, "instreamads");
        void var2_2;
        void var3_3;
        void var1_1;
        this.loadingTimeoutSeconds = 10;
        this.volume = 1.0f;
        this.context = var3_3;
        this.adChoicesMenuFactory = var2_2;
        c9.c("Instream ad created. Version - 5.16.3");
    }

    private void handleResult(@Nullable j2 object, @Nullable String object2) {
        if (this.listener == null) {
            return;
        }
        if (object != null && ((j2)object).d()) {
            InstreamAd instreamAd = this;
            Object object3 = object;
            InstreamAd instreamAd2 = this;
            instreamAd2.section = object;
            object = instreamAd2.adConfig;
            object2 = instreamAd2.metricFactory;
            MenuFactory menuFactory = instreamAd2.adChoicesMenuFactory;
            this.engine = object = f2.a(instreamAd, (j2)object3, (j)object, (y4.a)object2, menuFactory);
            ((f2)object).a(this.loadingTimeoutSeconds);
            instreamAd.engine.a(this.volume);
            object = instreamAd.player;
            if (object != null) {
                this.engine.a((InstreamAdPlayer)object);
            }
            InstreamAd instreamAd3 = this;
            float f10 = instreamAd3.videoDuration;
            instreamAd3.configureMidpoints(f10, instreamAd3.userMidpoints);
            instreamAd3.listener.onLoad(this);
        } else {
            object = this.listener;
            if (object2 == null) {
                object2 = "no ad";
            }
            object.onNoAd((String)object2, this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void start(@NonNull String sectionName) {
        void var1_1;
        f2 f22 = this.engine;
        if (f22 == null) {
            c9.a("InstreamAd: Unable to start ad - not loaded yet");
            return;
        }
        if (f22.c() == null) {
            c9.a("InstreamAd: Unable to start ad - player has not set");
            return;
        }
        this.engine.c((String)var1_1);
    }

    @NonNull
    public List<String> getVideoSectionNames() {
        ArrayList arrayList;
        ArrayList this_;
        if (((InstreamAd)((Object)this_)).section == null) {
            return Collections.EMPTY_LIST;
        }
        InstreamAd instreamAd = arrayList2;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        ArrayList<m4<VideoData>> arrayList22 = instreamAd.section.c();
        if (arrayList22.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        for (m4 m42 : arrayList22) {
            if (m42.a() <= 0 && !m42.i()) continue;
            arrayList2.add(m42.h());
        }
        return arrayList2;
    }

    @Nullable
    public InstreamAdListener getListener() {
        return this.listener;
    }

    /*
     * WARNING - void declaration
     */
    public void setListener(@Nullable InstreamAdListener listener) {
        void var1_1;
        this.listener = var1_1;
    }

    public int getLoadingTimeout() {
        return this.loadingTimeoutSeconds;
    }

    /*
     * WARNING - void declaration
     */
    public void setLoadingTimeout(int loadingTimeout) {
        if (loadingTimeout < 5) {
            c9.a("InstreamAd: Unable to set ad loading timeout < 5, set to 5 seconds");
            this.loadingTimeoutSeconds = 5;
        } else {
            void var1_1;
            c9.a("InstreamAd: Ad loading timeout set to " + (int)var1_1 + " seconds");
            this.loadingTimeoutSeconds = var1_1;
        }
        f2 f22 = this.engine;
        if (f22 != null) {
            f22.a(this.loadingTimeoutSeconds);
        }
    }

    public int getVideoQuality() {
        return this.adConfig.getVideoQuality();
    }

    /*
     * WARNING - void declaration
     */
    public void setVideoQuality(int videoQuality) {
        void var1_1;
        this.adConfig.setVideoQuality((int)var1_1);
    }

    @Nullable
    public InstreamAdPlayer getPlayer() {
        return this.player;
    }

    /*
     * WARNING - void declaration
     */
    public void setPlayer(@Nullable InstreamAdPlayer player) {
        void var1_1;
        ((InstreamAd)((Object)this_)).player = var1_1;
        f2 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.a((InstreamAdPlayer)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void swapPlayer(@Nullable InstreamAdPlayer player) {
        void var1_1;
        ((InstreamAd)((Object)this_)).player = var1_1;
        f2 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.b((InstreamAdPlayer)var1_1);
        }
    }

    public boolean isFullscreen() {
        return this.isFullscreen;
    }

    /*
     * WARNING - void declaration
     */
    public void setFullscreen(boolean fullscreen) {
        void var1_1;
        ((InstreamAd)((Object)this_)).isFullscreen = var1_1;
        f2 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.a((boolean)var1_1);
        }
    }

    public boolean isShoppablePresented() {
        f2 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            return this_.f();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void setShoppablePresented(boolean isPresented) {
        f2 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            void var1_1;
            this_.b((boolean)var1_1);
        }
    }

    public float getVolume() {
        f2 f22 = this.engine;
        if (f22 != null) {
            return f22.d();
        }
        return this.volume;
    }

    /*
     * WARNING - void declaration
     */
    public void setVolume(float volume) {
        void var1_1;
        if (Float.compare(volume, 0.0f) >= 0 && Float.compare((float)var1_1, 1.0f) <= 0) {
            ((InstreamAd)((Object)f22)).volume = var1_1;
            f2 f22 = ((InstreamAd)((Object)f22)).engine;
            if (f22 != null) {
                f22.a((float)var1_1);
            }
            return;
        }
        c9.a("InstreamAd: Unable to set volume" + (float)var1_1 + ", volume must be in range [0..1]");
    }

    @NonNull
    public float[] getMidPoints() {
        Object this_ = ((InstreamAd)this_).midpoints;
        if (((InstreamAd)this_).midpoints == null) {
            return new float[0];
        }
        return (float[])this_.clone();
    }

    public void load() {
        if (this.isLoadCalled()) {
            c9.a("InstreamAd: Doesn't support multiple load");
            return;
        }
        InstreamAd instreamAd = this;
        y4 y42 = instreamAd.metricFactory.a();
        InstreamAd instreamAd2 = this;
        y4.a a10 = instreamAd2.metricFactory;
        g2.a(instreamAd.adConfig, a10, instreamAd2.loadingTimeoutSeconds).a(this::handleResult).a((j2)((Object)y42), this.context);
    }

    /*
     * WARNING - void declaration
     */
    public void configureMidpoints(float videoDuration) {
        void var1_1;
        this.configureMidpoints((float)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void configureMidpoints(float videoDuration, @Nullable float[] midpoints) {
        void var1_1;
        o o10;
        if (videoDuration <= 0.0f) {
            c9.a("InstreamAd: Midpoints are not configured, duration is not set or <= zero");
            return;
        }
        if (((InstreamAd)object).midpoints != null) {
            c9.a("InstreamAd: Midpoints already configured");
            return;
        }
        ((InstreamAd)object).userMidpoints = o10;
        ((InstreamAd)object).videoDuration = var1_1;
        o10 = ((InstreamAd)object).section;
        if (o10 != null && (o10 = o10.a("midroll")) != null) {
            InstreamAd instreamAd = object;
            float[] fArray = n4.a(o10, ((InstreamAd)object).userMidpoints, (float)var1_1);
            Object object = fArray;
            instreamAd.midpoints = fArray;
            f2 f22 = instreamAd.engine;
            if (f22 != null) {
                f22.a((float[])object);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void configureMidpointsPercents(float videoDuration, @Nullable float[] midpointsPercents) {
        void var2_2;
        void var1_1;
        if (midpointsPercents == null) {
            this.configureMidpoints((float)var1_1);
            return;
        }
        this.configureMidpoints((float)var1_1, n4.a((float)var1_1, (float[])var2_2));
    }

    public void useDefaultPlayer() {
        this.useDefaultPlayer(true);
    }

    /*
     * WARNING - void declaration
     */
    public void useDefaultPlayer(boolean useExoPlayer) {
        void var1_1;
        m2 m22 = new m2(this.context);
        m22.setUseExoPlayer((boolean)var1_1);
        this.setPlayer(m22);
    }

    public void pause() {
        f2 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.g();
        }
    }

    public void resume() {
        f2 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.i();
        }
    }

    public void stop() {
        f2 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.l();
        }
    }

    public void skip() {
        f2 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.j();
        }
    }

    public void skipBanner() {
        f2 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.k();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void shoppableAdsItemShow(@NonNull String shoppableAdsItemId) {
        f2 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            void var1_1;
            this_.b((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void shoppableAdsItemClick(@NonNull String shoppableAdsItemId) {
        f2 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            void var1_1;
            this_.a((String)var1_1);
        }
    }

    public void handleClick() {
        f2 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.e();
        }
    }

    public void destroy() {
        ((InstreamAd)((Object)this_)).listener = null;
        f2 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.a();
        }
    }

    public void startPreroll() {
        this.start("preroll");
    }

    public void startPostroll() {
        this.start("postroll");
    }

    public void startPauseroll() {
        this.start("pauseroll");
    }

    /*
     * WARNING - void declaration
     */
    public void startMidroll(float point) {
        void var1_1;
        f2 f22 = this.engine;
        if (f22 == null) {
            c9.a("InstreamAd: Unable to start ad: not loaded yet");
            return;
        }
        if (f22.c() == null) {
            c9.a("InstreamAd: Unable to start ad: player has not set");
            return;
        }
        this.engine.b((float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void handleCompanionClick(@NonNull InstreamAdCompanionBanner instreamAdCompanionBanner) {
        f2 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            void var1_1;
            this_.b((InstreamAdCompanionBanner)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleCompanionClick(@NonNull InstreamAdCompanionBanner instreamAdCompanionBanner, @NonNull Context context) {
        f2 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            void var2_2;
            void var1_1;
            this_.a((InstreamAdCompanionBanner)var1_1, (Context)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleCompanionShow(@NonNull InstreamAdCompanionBanner instreamAdCompanionBanner) {
        f2 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ != null) {
            void var1_1;
            this_.c((InstreamAdCompanionBanner)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public View getShoppableView(Context context) {
        void var1_1;
        f2 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ == null) {
            return null;
        }
        return this_.a((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void handleAdChoicesClick(@NonNull Context context) {
        void var1_1;
        f2 this_ = ((InstreamAd)((Object)this_)).engine;
        if (this_ == null) {
            return;
        }
        this_.b((Context)var1_1);
    }

    public static final class InstreamAdCompanionBanner {
        public final int width;
        public final int height;
        public final int assetWidth;
        public final int assetHeight;
        public final int expandedWidth;
        public final int expandedHeight;
        public final boolean isClickable;
        @Nullable
        public final String staticResource;
        @Nullable
        public final String iframeResource;
        @Nullable
        public final String htmlResource;
        @Nullable
        public final String apiFramework;
        @Nullable
        public final String adSlotID;
        @Nullable
        public final String required;

        @NonNull
        public static InstreamAdCompanionBanner newBanner(@NonNull z0 z02) {
            z0 z03 = z02;
            int n10 = z03.getWidth();
            int n11 = z03.getHeight();
            int n12 = z03.getAssetWidth();
            int n13 = z03.getAssetHeight();
            int n14 = z03.getExpandedWidth();
            int n15 = z03.getExpandedHeight();
            boolean bl = TextUtils.isEmpty((CharSequence)z03.getTrackingLink()) ^ true;
            String string = z03.getStaticResource();
            String string2 = z03.getIframeResource();
            String string3 = z03.getHtmlResource();
            String string4 = z03.getApiFramework();
            String string5 = z03.getAdSlotID();
            String string6 = z03.getRequired();
            return new InstreamAdCompanionBanner(n10, n11, n12, n13, n14, n15, bl, string, string2, string3, string4, string5, string6);
        }

        /*
         * WARNING - void declaration
         */
        private InstreamAdCompanionBanner(int width, int height, int assetWidth, int assetHeight, int expandedWidth, int expandedHeight, boolean isClickable, @Nullable String staticResource, @Nullable String iframeResource, @Nullable String htmlResource, @Nullable String apiFramework, @Nullable String adSlotID, @Nullable String required) {
            void var13_13;
            void var12_12;
            void var11_11;
            void var10_10;
            void var9_9;
            void var8_8;
            void var7_7;
            void var6_6;
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            this.width = var1_1;
            this.height = var2_2;
            this.assetWidth = var3_3;
            this.assetHeight = var4_4;
            this.expandedWidth = var5_5;
            this.expandedHeight = var6_6;
            this.isClickable = var7_7;
            this.staticResource = var8_8;
            this.iframeResource = var9_9;
            this.htmlResource = var10_10;
            this.apiFramework = var11_11;
            this.adSlotID = var12_12;
            this.required = var13_13;
        }
    }

    public static final class InstreamAdBanner {
        public final float duration;
        public final boolean allowClose;
        public final float allowCloseDelay;
        public final int videoWidth;
        public final int videoHeight;
        public final boolean hasAdChoices;
        public final boolean allowPause;
        public final boolean hasShoppable;
        @NonNull
        public final String id;
        @NonNull
        public final String advertisingLabel;
        @NonNull
        public final List<InstreamAdCompanionBanner> companionBanners;
        @Nullable
        public final String ctaText;
        @Nullable
        public final ImageData adChoicesIcon;
        @Nullable
        public final List<ShoppableAdsItem> shoppableAdsItems;

        @NonNull
        public static InstreamAdBanner newBanner(@NonNull k4 object) {
            InstreamAdBanner instreamAdBanner;
            Object object2;
            int n10;
            ArrayList<InstreamAdCompanionBanner> arrayList;
            ArrayList<InstreamAdCompanionBanner> arrayList2 = arrayList;
            arrayList = new ArrayList<InstreamAdCompanionBanner>();
            for (n10 = 0; n10 < ((k4)object).getCompanionBanners().size(); n10 += 1) {
                arrayList2.add(InstreamAdCompanionBanner.newBanner(((k4)object).getCompanionBanners().get(n10)));
            }
            n10 = 0;
            ImageData imageData = null;
            if (((b)object).getAdChoices() != null) {
                n10 = 1;
                imageData = ((b)object).getAdChoices().c();
            }
            object2 = (object2 = ((k4)object).getShoppableAdsData()) == null ? null : ((f8)object2).a();
            k4 k42 = object;
            String string = k42.getId();
            boolean bl = k42.isAllowClose();
            float f10 = k42.getAllowCloseDelay();
            float f11 = k42.getDuration();
            int n11 = k42.getWidth();
            int n12 = k42.getHeight();
            String string2 = k42.getCtaText();
            boolean bl2 = k42.isAllowPause();
            boolean bl3 = k42.getShoppableBanner() != null;
            InstreamAdBanner instreamAdBanner2 = instreamAdBanner;
            object = ((b)object).getAdvertisingLabel();
            instreamAdBanner2(string, bl, f10, f11, n11, n12, string2, bl2, bl3, arrayList2, n10 != 0, (String)object, imageData, (List<ShoppableAdsItem>)object2);
            return instreamAdBanner2;
        }

        /*
         * WARNING - void declaration
         */
        private InstreamAdBanner(@NonNull String id2, boolean allowClose, float allowCloseDelay, float duration, int width, int height, @Nullable String ctaText, boolean allowPause, boolean hasShoppable, @NonNull List<InstreamAdCompanionBanner> companionBanners, boolean hasAdChoices, @NonNull String advertisingLabel, @Nullable ImageData adChoicesIcon, @Nullable List<ShoppableAdsItem> shoppableAdsItems) {
            void var14_14;
            void var13_13;
            void var12_12;
            void var11_11;
            void var10_10;
            void var9_9;
            void var8_8;
            void var7_7;
            void var5_5;
            void var6_6;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            this.id = var1_1;
            this.allowClose = var2_2;
            this.allowCloseDelay = var3_3;
            this.duration = var4_4;
            this.videoHeight = var6_6;
            this.videoWidth = var5_5;
            this.ctaText = var7_7;
            this.allowPause = var8_8;
            this.hasShoppable = var9_9;
            this.companionBanners = var10_10;
            this.hasAdChoices = var11_11;
            this.advertisingLabel = var12_12;
            this.adChoicesIcon = var13_13;
            this.shoppableAdsItems = var14_14;
        }
    }

    public static interface InstreamAdListener {
        public void onLoad(@NonNull InstreamAd var1);

        public void onNoAd(@NonNull String var1, @NonNull InstreamAd var2);

        public void onError(@NonNull String var1, @NonNull InstreamAd var2);

        public void onBannerStart(@NonNull InstreamAd var1, @NonNull InstreamAdBanner var2);

        public void onBannerPause(@NonNull InstreamAd var1, @NonNull InstreamAdBanner var2);

        public void onBannerResume(@NonNull InstreamAd var1, @NonNull InstreamAdBanner var2);

        public void onBannerComplete(@NonNull InstreamAd var1, @NonNull InstreamAdBanner var2);

        public void onBannerTimeLeftChange(float var1, float var2, @NonNull InstreamAd var3);

        public void onComplete(@NonNull String var1, @NonNull InstreamAd var2);

        public void onBannerShouldClose();
    }
}

