/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.instreamads;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.c9;
import com.my.target.common.BaseAd;
import com.my.target.common.models.AudioData;
import com.my.target.common.models.ShareButtonData;
import com.my.target.instreamads.InstreamAudioAdPlayer;
import com.my.target.j;
import com.my.target.k4;
import com.my.target.n2;
import com.my.target.n4;
import com.my.target.o;
import com.my.target.o2;
import com.my.target.r2;
import com.my.target.y4;
import com.my.target.z0;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class InstreamAudioAd
extends BaseAd {
    private static final int DEFAULT_LOADING_TIMEOUT_SECONDS = 10;
    private static final int MIN_LOADING_TIMEOUT_SECONDS = 5;
    @NonNull
    private final Context context;
    @Nullable
    private r2 section;
    @Nullable
    private n2 engine;
    @Nullable
    private InstreamAudioAdPlayer player;
    @Nullable
    private InstreamAudioAdListener listener;
    private int loadingTimeoutSeconds = 10;
    private float volume = 1.0f;
    @Nullable
    private float[] midpoints;
    @Nullable
    private float[] userMidpoints;
    private float audioDuration;

    /*
     * WARNING - void declaration
     */
    public InstreamAudioAd(int slotId, @NonNull Context context) {
        super((int)var1_1, "instreamaudioads");
        void var2_2;
        void var1_1;
        this.context = var2_2;
        c9.c("Instream audio ad created. Version - 5.16.3");
    }

    private void handleResult(@Nullable r2 object, @Nullable String string) {
        if (this.listener == null) {
            return;
        }
        if (object != null && ((r2)object).d()) {
            InstreamAudioAd instreamAudioAd = this;
            Object object2 = object;
            InstreamAudioAd instreamAudioAd2 = this;
            instreamAudioAd2.section = object;
            object = instreamAudioAd2.adConfig;
            this.engine = object = n2.a(instreamAudioAd, (r2)object2, (j)object, instreamAudioAd2.metricFactory);
            ((n2)object).a(this.loadingTimeoutSeconds);
            instreamAudioAd.engine.a(this.volume);
            object = instreamAudioAd.player;
            if (object != null) {
                this.engine.a((InstreamAudioAdPlayer)object);
            }
            InstreamAudioAd instreamAudioAd3 = this;
            float f10 = instreamAudioAd3.audioDuration;
            instreamAudioAd3.configureMidpoints(f10, instreamAudioAd3.userMidpoints);
            instreamAudioAd3.listener.onLoad(this);
        } else {
            object = this.listener;
            if (string == null) {
                string = "no ad";
            }
            object.onNoAd(string, this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void start(@NonNull String sectionName) {
        void var1_1;
        n2 n22 = this.engine;
        if (n22 == null) {
            c9.a("InstreamAudioAd: Unable to start ad \u2013 not loaded yet");
            return;
        }
        if (n22.c() == null) {
            c9.a("InstreamAudioAd: Unable to start ad \u2013 player has not set");
            return;
        }
        this.engine.a((String)var1_1);
    }

    @Nullable
    public InstreamAudioAdListener getListener() {
        return this.listener;
    }

    /*
     * WARNING - void declaration
     */
    public void setListener(@Nullable InstreamAudioAdListener listener) {
        void var1_1;
        this.listener = var1_1;
    }

    public int getLoadingTimeout() {
        return this.loadingTimeoutSeconds;
    }

    /*
     * WARNING - void declaration
     */
    public void setLoadingTimeout(int loadingTimeout) {
        if (loadingTimeout < 5) {
            c9.a("InstreamAudioAd: Unable to set ad loading timeout < 5, set to 5 seconds");
            this.loadingTimeoutSeconds = 5;
        } else {
            void var1_1;
            c9.a("InstreamAudioAd: Ad loading timeout set to " + (int)var1_1 + " seconds");
            this.loadingTimeoutSeconds = var1_1;
        }
        n2 n22 = this.engine;
        if (n22 != null) {
            n22.a(this.loadingTimeoutSeconds);
        }
    }

    @Nullable
    public InstreamAudioAdPlayer getPlayer() {
        return this.player;
    }

    /*
     * WARNING - void declaration
     */
    public void setPlayer(@Nullable InstreamAudioAdPlayer player) {
        void var1_1;
        ((InstreamAudioAd)((Object)this_)).player = var1_1;
        n2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.a((InstreamAudioAdPlayer)var1_1);
        }
    }

    public float getVolume() {
        n2 n22 = this.engine;
        if (n22 != null) {
            return n22.d();
        }
        return this.volume;
    }

    /*
     * WARNING - void declaration
     */
    public void setVolume(float volume) {
        void var1_1;
        if (Float.compare(volume, 0.0f) >= 0 && Float.compare((float)var1_1, 1.0f) <= 0) {
            ((InstreamAudioAd)((Object)n22)).volume = var1_1;
            n2 n22 = ((InstreamAudioAd)((Object)n22)).engine;
            if (n22 != null) {
                n22.a((float)var1_1);
            }
            return;
        }
        c9.a("InstreamAudioAd: Unable to set volume" + (float)var1_1 + ", volume must be in range [0..1]");
    }

    @NonNull
    public float[] getMidPoints() {
        Object this_ = ((InstreamAudioAd)this_).midpoints;
        if (((InstreamAudioAd)this_).midpoints == null) {
            return new float[0];
        }
        return (float[])this_.clone();
    }

    @Nullable
    public InstreamAudioAdBanner getCurrentBanner() {
        n2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            return this_.b();
        }
        return null;
    }

    public void load() {
        if (this.isLoadCalled()) {
            c9.a("InstreamAudioAd: Doesn't support multiple load");
            return;
        }
        InstreamAudioAd instreamAudioAd = this;
        y4 y42 = instreamAudioAd.metricFactory.a();
        InstreamAudioAd instreamAudioAd2 = this;
        y4.a a10 = instreamAudioAd2.metricFactory;
        o2.a(instreamAudioAd.adConfig, a10, instreamAudioAd2.loadingTimeoutSeconds).a(this::handleResult).a((r2)((Object)y42), this.context);
    }

    /*
     * WARNING - void declaration
     */
    public void configureMidpoints(float audioDuration) {
        void var1_1;
        this.configureMidpoints((float)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void configureMidpoints(float audioDuration, @Nullable float[] midpoints) {
        void var1_1;
        o o10;
        if (audioDuration <= 0.0f) {
            c9.a("InstreamAudioAd: Midpoints are not configured, duration is not set or <= zero");
            return;
        }
        if (((InstreamAudioAd)object).midpoints != null) {
            c9.a("InstreamAudioAd: Midpoints already configured");
            return;
        }
        ((InstreamAudioAd)object).userMidpoints = o10;
        ((InstreamAudioAd)object).audioDuration = var1_1;
        o10 = ((InstreamAudioAd)object).section;
        if (o10 != null && (o10 = o10.a("midroll")) != null) {
            InstreamAudioAd instreamAudioAd = object;
            float[] fArray = n4.a(o10, ((InstreamAudioAd)object).userMidpoints, (float)var1_1);
            Object object = fArray;
            instreamAudioAd.midpoints = fArray;
            n2 n22 = instreamAudioAd.engine;
            if (n22 != null) {
                n22.a((float[])object);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void configureMidpointsPercents(float audioDuration, @Nullable float[] midpointsPercents) {
        void var2_2;
        void var1_1;
        if (midpointsPercents == null) {
            this.configureMidpoints((float)var1_1);
            return;
        }
        this.configureMidpoints((float)var1_1, n4.a((float)var1_1, (float[])var2_2));
    }

    public void pause() {
        n2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.e();
        }
    }

    public void resume() {
        n2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.g();
        }
    }

    public void stop() {
        n2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.j();
        }
    }

    public void skip() {
        n2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.h();
        }
    }

    public void skipBanner() {
        n2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.i();
        }
    }

    public void destroy() {
        ((InstreamAudioAd)((Object)this_)).listener = null;
        n2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.a();
        }
    }

    public void startPreroll() {
        this.start("preroll");
    }

    public void startPostroll() {
        this.start("postroll");
    }

    public void startPauseroll() {
        this.start("pauseroll");
    }

    /*
     * WARNING - void declaration
     */
    public void startMidroll(float point) {
        void var1_1;
        n2 n22 = this.engine;
        if (n22 == null) {
            c9.a("InstreamAudioAd: Unable to start ad \u2013 not loaded yet");
            return;
        }
        if (n22.c() == null) {
            c9.a("InstreamAudioAd: Unable to start ad \u2013 player has not set");
            return;
        }
        this.engine.b((float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void handleCompanionClick(@NonNull InstreamAdCompanionBanner instreamAdCompanionBanner) {
        n2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            void var1_1;
            this_.b((InstreamAdCompanionBanner)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleCompanionClick(@NonNull InstreamAdCompanionBanner instreamAdCompanionBanner, @NonNull Context context) {
        n2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            void var2_2;
            void var1_1;
            this_.a((InstreamAdCompanionBanner)var1_1, (Context)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleCompanionShow(@NonNull InstreamAdCompanionBanner instreamAdCompanionBanner) {
        n2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            void var1_1;
            this_.c((InstreamAdCompanionBanner)var1_1);
        }
    }

    public static final class InstreamAudioAdBanner {
        public final float duration;
        public final boolean allowSeek;
        public final boolean allowPause;
        public final boolean allowSkip;
        public final boolean allowTrackChange;
        @Nullable
        public final String adText;
        @NonNull
        public final ArrayList<ShareButtonData> shareButtonDatas;
        @NonNull
        public final List<InstreamAdCompanionBanner> companionBanners;

        @NonNull
        public static InstreamAudioAdBanner newBanner(@NonNull k4<AudioData> k42) {
            ArrayList<InstreamAdCompanionBanner> arrayList;
            ArrayList<InstreamAdCompanionBanner> arrayList2 = arrayList;
            arrayList = new ArrayList<InstreamAdCompanionBanner>();
            Iterator<z0> iterator = k42.getCompanionBanners().iterator();
            while (iterator.hasNext()) {
                arrayList2.add(InstreamAdCompanionBanner.newBanner(iterator.next()));
            }
            k4<AudioData> k43 = k42;
            boolean bl = k43.isAllowSeek();
            boolean bl2 = k43.isAllowSkip();
            boolean bl3 = k43.isAllowTrackChange();
            float f10 = k43.getDuration();
            String string = k43.getAdText();
            boolean bl4 = k43.isAllowPause();
            ArrayList<ShareButtonData> arrayList3 = k43.getShareButtonDatas();
            return new InstreamAudioAdBanner(bl, bl2, bl3, f10, string, bl4, arrayList3, arrayList2);
        }

        /*
         * WARNING - void declaration
         */
        private InstreamAudioAdBanner(boolean allowSeek, boolean allowSkip, boolean allowTrackChange, float duration, @Nullable String adText, boolean allowPause, @NonNull ArrayList<ShareButtonData> shareButtonDatas, @NonNull List<InstreamAdCompanionBanner> companionBanners) {
            void var8_8;
            void var7_7;
            void var5_5;
            void var4_4;
            void var3_3;
            void var6_6;
            void var2_2;
            void var1_1;
            this.allowSeek = var1_1;
            this.allowSkip = var2_2;
            this.allowPause = var6_6;
            this.allowTrackChange = var3_3;
            this.duration = var4_4;
            this.adText = var5_5;
            this.shareButtonDatas = var7_7;
            this.companionBanners = var8_8;
        }
    }

    public static final class InstreamAdCompanionBanner {
        public final int width;
        public final int height;
        public final int assetWidth;
        public final int assetHeight;
        public final int expandedWidth;
        public final int expandedHeight;
        public final boolean isClickable;
        @Nullable
        public final String staticResource;
        @Nullable
        public final String iframeResource;
        @Nullable
        public final String htmlResource;
        @Nullable
        public final String apiFramework;
        @Nullable
        public final String adSlotID;
        @Nullable
        public final String required;

        @NonNull
        public static InstreamAdCompanionBanner newBanner(@NonNull z0 z02) {
            z0 z03 = z02;
            int n10 = z03.getWidth();
            int n11 = z03.getHeight();
            int n12 = z03.getAssetWidth();
            int n13 = z03.getAssetHeight();
            int n14 = z03.getExpandedWidth();
            int n15 = z03.getExpandedHeight();
            boolean bl = TextUtils.isEmpty((CharSequence)z03.getTrackingLink()) ^ true;
            String string = z03.getStaticResource();
            String string2 = z03.getIframeResource();
            String string3 = z03.getHtmlResource();
            String string4 = z03.getApiFramework();
            String string5 = z03.getAdSlotID();
            String string6 = z03.getRequired();
            return new InstreamAdCompanionBanner(n10, n11, n12, n13, n14, n15, bl, string, string2, string3, string4, string5, string6);
        }

        /*
         * WARNING - void declaration
         */
        private InstreamAdCompanionBanner(int width, int height, int assetWidth, int assetHeight, int expandedWidth, int expandedHeight, boolean isClickable, @Nullable String staticResource, @Nullable String iframeResource, @Nullable String htmlResource, @Nullable String apiFramework, @Nullable String adSlotID, @Nullable String required) {
            void var13_13;
            void var12_12;
            void var11_11;
            void var10_10;
            void var9_9;
            void var8_8;
            void var7_7;
            void var6_6;
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            this.width = var1_1;
            this.height = var2_2;
            this.assetWidth = var3_3;
            this.assetHeight = var4_4;
            this.expandedWidth = var5_5;
            this.expandedHeight = var6_6;
            this.isClickable = var7_7;
            this.staticResource = var8_8;
            this.iframeResource = var9_9;
            this.htmlResource = var10_10;
            this.apiFramework = var11_11;
            this.adSlotID = var12_12;
            this.required = var13_13;
        }
    }

    public static interface InstreamAudioAdListener {
        public void onLoad(@NonNull InstreamAudioAd var1);

        public void onNoAd(@NonNull String var1, @NonNull InstreamAudioAd var2);

        public void onError(@NonNull String var1, @NonNull InstreamAudioAd var2);

        public void onBannerStart(@NonNull InstreamAudioAd var1, @NonNull InstreamAudioAdBanner var2);

        public void onBannerComplete(@NonNull InstreamAudioAd var1, @NonNull InstreamAudioAdBanner var2);

        public void onBannerTimeLeftChange(float var1, float var2, @NonNull InstreamAudioAd var3);

        public void onComplete(@NonNull String var1, @NonNull InstreamAudioAd var2);
    }
}

