/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.ads;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.my.target.R;
import com.my.target.ba;
import com.my.target.ca;
import com.my.target.common.CustomParams;
import com.my.target.common.models.IAdLoadingError;
import com.my.target.f1;
import com.my.target.j;
import com.my.target.m;
import com.my.target.m9;
import com.my.target.mediation.AdNetworkConfig;
import com.my.target.n9;
import com.my.target.o5;
import com.my.target.q9;
import java.util.concurrent.atomic.AtomicBoolean;

public final class MyTargetView
extends FrameLayout {
    @NonNull
    private final j adConfig;
    @NonNull
    private final AtomicBoolean isLoaded = new AtomicBoolean();
    @Nullable
    private MyTargetViewListener listener;
    @RequiresApi(value=26)
    @Nullable
    private MyTargetViewRenderCrashListener webViewCrashListener;
    @Nullable
    private n9 engine;
    @NonNull
    private AdSize adSize;
    private boolean fixedSize = false;
    private boolean attached;

    /*
     * WARNING - void declaration
     */
    public MyTargetView(@NonNull Context context) {
        this((Context)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MyTargetView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this((Context)var1_1, (AttributeSet)var2_2, 0);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MyTargetView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_5);
        void var3_5;
        void var2_2;
        void var1_1;
        ba.c("MyTargetView created. Version - 5.20.0");
        this.adConfig = j.newConfig(0, "");
        this.adSize = AdSize.getAdSizeForCurrentOrientation((Context)var1_1);
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = null;
        try {
            typedArray = var1_1.obtainStyledAttributes((AttributeSet)var2_2, R.styleable.MyTargetView);
        }
        catch (Throwable throwable) {
            ba.a("MyTargetView: Unable to get view attributes - " + throwable.getMessage());
        }
        if (typedArray == null) {
            return;
        }
        MyTargetView myTargetView = this;
        int n10 = typedArray.getInt(R.styleable.MyTargetView_myTarget_slotId, 0);
        myTargetView.adConfig.setSlotId(n10);
        myTargetView.adConfig.setRefreshAd(typedArray.getBoolean(R.styleable.MyTargetView_myTarget_isRefreshAd, true));
        n10 = typedArray.getInt(R.styleable.MyTargetView_myTarget_adSize, -1);
        if (n10 >= 0) {
            if (n10 != 3) {
                this.fixedSize = true;
            }
            this.adSize = AdSize.fromInt(n10, (Context)var1_1);
        }
        typedArray.recycle();
    }

    private void handleResult(@Nullable q9 q92, @Nullable IAdLoadingError object, @NonNull o5.a a10) {
        MyTargetViewListener myTargetViewListener = this.listener;
        if (myTargetViewListener == null) {
            return;
        }
        if (q92 == null) {
            if (object == null) {
                object = m.i;
            }
            myTargetViewListener.onNoAd((IAdLoadingError)object, this);
            return;
        }
        object = this.engine;
        if (object != null) {
            ((n9)object).a();
        }
        MyTargetView myTargetView = this;
        this.engine = object = n9.a(myTargetView, myTargetView.adConfig, a10);
        ((n9)object).a(this.attached);
        myTargetView.engine.b(q92);
        myTargetView.adConfig.setBidId(null);
    }

    private void setFormat() {
        AdSize adSize = this.adSize;
        if (adSize == AdSize.ADSIZE_320x50) {
            this.adConfig.setFormat("standard_320x50");
        } else if (adSize == AdSize.ADSIZE_300x250) {
            this.adConfig.setFormat("standard_300x250");
        } else if (adSize == AdSize.ADSIZE_728x90) {
            this.adConfig.setFormat("standard_728x90");
        } else {
            this.adConfig.setFormat("standard");
        }
    }

    private void updateAdaptiveSize() {
        Object object = this_.getContext();
        Point point = ca.b((Context)object);
        float f10 = point.y;
        AdSize adSize = this_.adSize;
        if (point.x == adSize.width && (float)adSize.height <= f10 * 0.15f) {
            return;
        }
        MyTargetView myTargetView = this_;
        Object this_ = AdSize.getAdSizeForCurrentOrientation((Context)object);
        myTargetView.adSize = this_;
        object = myTargetView.engine;
        if (object != null) {
            ((n9)object).a((AdSize)this_);
        }
    }

    private /* synthetic */ void lambda$handleSection$1(o5.a a10, q9 q92, m m10) {
        this.handleResult(q92, m10, a10);
    }

    @Nullable
    public MyTargetViewListener getListener() {
        return this.listener;
    }

    /*
     * WARNING - void declaration
     */
    public void setListener(@Nullable MyTargetViewListener listener) {
        void var1_1;
        this.listener = var1_1;
    }

    @RequiresApi(value=26)
    @Nullable
    public MyTargetViewRenderCrashListener getRenderCrashListener() {
        int n10 = Build.VERSION.SDK_INT;
        if (n10 < 26) {
            ba.b("Trying to get a MyTargetViewRenderCrashListener on api = " + n10 + ", but min api = " + 26 + ", return null");
            return null;
        }
        return this.webViewCrashListener;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=26)
    public void setRenderCrashListener(@Nullable MyTargetViewRenderCrashListener crashListener) {
        void var1_1;
        int n10 = Build.VERSION.SDK_INT;
        if (n10 < 26) {
            ba.b("Can't set MyTargetViewRenderCrashListener: available only on api >= 26, your api = " + n10);
            return;
        }
        this.webViewCrashListener = var1_1;
    }

    public boolean isMediationEnabled() {
        return this.adConfig.isMediationEnabled();
    }

    /*
     * WARNING - void declaration
     */
    public void setMediationEnabled(boolean mediationEnabled) {
        void var1_1;
        this.adConfig.setMediationEnabled((boolean)var1_1);
    }

    @NonNull
    public CustomParams getCustomParams() {
        return this.adConfig.getCustomParams();
    }

    @NonNull
    public AdSize getSize() {
        return this.adSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setAdSize(@NonNull AdSize adSize) {
        Object object;
        void var1_1;
        if (adSize == null) {
            ba.a("MyTargetView: AdSize cannot be null");
            return;
        }
        if (this.fixedSize && AdSize.isSame(this.adSize, (AdSize)var1_1)) {
            return;
        }
        this.fixedSize = true;
        if (this.isLoaded.get() && (AdSize.isSame(this.adSize, (AdSize)(object = AdSize.ADSIZE_300x250)) || AdSize.isSame((AdSize)var1_1, (AdSize)object))) {
            ba.a("MyTargetView: unable to switch size to/from 300x250");
            return;
        }
        object = this.engine;
        if (object != null) {
            ((n9)object).a((AdSize)var1_1);
            object = this.getChildAt(0);
            if (object instanceof f1) {
                object.requestLayout();
            }
        }
        this.adSize = var1_1;
        this.setFormat();
    }

    /*
     * WARNING - void declaration
     */
    public void setSlotId(int slotId) {
        void var1_1;
        if (this.isLoaded.get()) {
            return;
        }
        this.adConfig.setSlotId((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setRefreshAd(boolean refreshAd) {
        void var1_1;
        this.adConfig.setRefreshAd((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void init(int slotId) {
        void var1_1;
        this.init((int)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void init(int slotId, boolean isRefreshAd) {
        void var2_2;
        void var1_1;
        this.init((int)var1_1, 0, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void init(int slotId, int adSize) {
        void var2_2;
        void var1_1;
        this.init((int)var1_1, (int)var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void init(int slotId, int adSize, boolean isRefreshAd) {
        void var3_3;
        void var1_1;
        void var2_2;
        MyTargetView myTargetView = this;
        myTargetView.setAdSize(AdSize.fromInt((int)var2_2, this.getContext()));
        myTargetView.adConfig.setSlotId((int)var1_1);
        myTargetView.adConfig.setRefreshAd((boolean)var3_3);
        ba.a("MyTargetView: Initialized");
    }

    public final void load() {
        if (!this.isLoaded.compareAndSet(false, true)) {
            ba.a("MyTargetView: Doesn't support multiple load");
            return;
        }
        MyTargetView myTargetView = this;
        o5.a a10 = o5.a(myTargetView.adConfig.getSlotId());
        o5 o52 = a10.a();
        ba.a("MyTargetView: View load");
        myTargetView.setFormat();
        m9.a(myTargetView.adConfig, a10).a((q92, m10) -> this.handleResult((q9)q92, m10, a10)).a(o52, this.getContext());
    }

    /*
     * WARNING - void declaration
     */
    public void loadFromBid(@NonNull String bidId) {
        void var1_1;
        MyTargetView myTargetView = this;
        myTargetView.adConfig.setBidId((String)var1_1);
        myTargetView.adConfig.setRefreshAd(false);
        myTargetView.load();
    }

    /*
     * WARNING - void declaration
     */
    public void setAdNetworkConfig(@NonNull String networkName, @NonNull AdNetworkConfig adNetworkConfig) {
        void var2_2;
        void var1_1;
        this.adConfig.setAdNetworkConfig((String)var1_1, (AdNetworkConfig)var2_2);
    }

    public final void handleSection(@NonNull q9 object, @NonNull AdSize object2) {
        q9 q92 = object;
        MyTargetView myTargetView = this;
        object = o5.a(myTargetView.adConfig.getSlotId());
        object2 = ((o5.a)object).a();
        m9.a(q92, myTargetView.adConfig, (o5.a)object).a((arg_0, arg_1) -> this.lambda$handleSection$1((o5.a)object, arg_0, arg_1)).a((o5)object2, this.getContext());
    }

    @Nullable
    public String getAdSource() {
        n9 this_ = ((MyTargetView)((Object)this_)).engine;
        if (this_ != null) {
            return this_.b();
        }
        return null;
    }

    public float getAdSourcePriority() {
        n9 this_ = ((MyTargetView)((Object)this_)).engine;
        if (this_ != null) {
            return this_.c();
        }
        return 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        void var1_1;
        MyTargetView myTargetView = this_;
        super.onWindowFocusChanged((boolean)var1_1);
        n9 this_ = myTargetView.engine;
        if (this_ != null) {
            this_.b((boolean)var1_1);
        }
    }

    public void destroy() {
        n9 n92 = this.engine;
        if (n92 != null) {
            n92.a();
            this.engine = null;
        }
        this.listener = null;
        if (Build.VERSION.SDK_INT >= 26) {
            this.webViewCrashListener = null;
        }
    }

    public void onAttachedToWindow() {
        MyTargetView myTargetView = this_;
        super.onAttachedToWindow();
        myTargetView.attached = true;
        n9 this_ = myTargetView.engine;
        if (this_ != null) {
            this_.a(true);
        }
    }

    public void onDetachedFromWindow() {
        MyTargetView myTargetView = this_;
        super.onDetachedFromWindow();
        myTargetView.attached = false;
        n9 this_ = myTargetView.engine;
        if (this_ != null) {
            this_.a(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        void var2_2;
        void var1_1;
        if (!this.fixedSize) {
            this.updateAdaptiveSize();
        }
        super.onMeasure((int)var1_1, (int)var2_2);
    }

    public static final class AdSize {
        public static final int BANNER_320x50 = 0;
        public static final int BANNER_300x250 = 1;
        public static final int BANNER_728x90 = 2;
        public static final int BANNER_ADAPTIVE = 3;
        public static final AdSize ADSIZE_320x50 = new AdSize(320, 50, 0);
        public static final AdSize ADSIZE_300x250 = new AdSize(300, 250, 1);
        public static final AdSize ADSIZE_728x90 = new AdSize(728, 90, 2);
        private static final int MIN_HEIGHT = 50;
        private static final float MAX_HEIGHT_PROPORTION = 0.15f;
        private final int width;
        private final int height;
        private final int widthPixels;
        private final int heightPixels;
        private final int type;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public static AdSize getAdSizeForCurrentOrientation(int width, int maxHeight, @NonNull Context context) {
            void var1_2;
            void var2_3;
            Point point = ca.b((Context)var2_3);
            float f10 = ca.a();
            return AdSize.getSize((float)width * f10, Math.min((float)var1_2 * f10, (float)point.y * 0.15f));
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public static AdSize getAdSizeForCurrentOrientation(int width, @NonNull Context context) {
            void var1_2;
            Point point = ca.b((Context)var1_2);
            return AdSize.getSize((float)width * ca.a(), (float)point.y * 0.15f);
        }

        @NonNull
        public static AdSize getAdSizeForCurrentOrientation(@NonNull Context context) {
            Context context2 = ca.b(context);
            return AdSize.getSize(context2.x, (float)context2.y * 0.15f);
        }

        @NonNull
        private static AdSize getSize(float w10, float h10) {
            float f10;
            float f11;
            float f12 = ca.a();
            f10 = Math.max(Math.min(w10 > 524.0f ? f11 / 728.0f * 90.0f : f11 / 320.0f * 50.0f, f10), f12 * 50.0f);
            int n10 = (int)(f11 / f12);
            int n11 = (int)(f10 / f12);
            int n12 = (int)f11;
            int n13 = (int)f10;
            return new AdSize(n10, n11, n12, n13, 3);
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        private static AdSize fromInt(int adSize, @NonNull Context context) {
            void var1_1;
            int n10;
            return adSize != 1 ? (n10 != 2 ? (n10 != 3 ? ADSIZE_320x50 : AdSize.getAdSizeForCurrentOrientation((Context)var1_1)) : ADSIZE_728x90) : ADSIZE_300x250;
        }

        /*
         * WARNING - void declaration
         */
        private static boolean isSame(@NonNull AdSize adSize, @NonNull AdSize adSize2) {
            AdSize adSize3;
            void var1_1;
            return adSize.height == var1_1.height && adSize3.width == var1_1.width && adSize3.type == var1_1.type;
        }

        /*
         * WARNING - void declaration
         */
        private AdSize(int widthDp, int heightDp, int widthPixels, int heightPixels, int type) {
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            this.width = var1_1;
            this.height = var2_2;
            this.widthPixels = var3_3;
            this.heightPixels = var4_4;
            this.type = var5_5;
        }

        /*
         * WARNING - void declaration
         */
        private AdSize(int widthDp, int heightDp, int type) {
            void var3_4;
            void var2_3;
            void var1_2;
            this.width = var1_2;
            this.height = var2_3;
            float f10 = ca.a();
            this.widthPixels = (int)((float)var1_2 * f10);
            this.heightPixels = (int)((float)var2_3 * f10);
            this.type = var3_4;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidthPixels() {
            return this.widthPixels;
        }

        public int getHeightPixels() {
            return this.heightPixels;
        }

        public int getType() {
            return this.type;
        }
    }

    @RequiresApi(value=26)
    public static interface MyTargetViewRenderCrashListener {
        public void onViewRenderCrash(@NonNull MyTargetView var1);
    }

    public static interface MyTargetViewListener {
        public void onLoad(@NonNull MyTargetView var1);

        public void onNoAd(@NonNull IAdLoadingError var1, @NonNull MyTargetView var2);

        public void onShow(@NonNull MyTargetView var1);

        public void onClick(@NonNull MyTargetView var1);
    }
}

