/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.common.models;

import android.graphics.Bitmap;
import android.util.LruCache;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.core.models.a;
import com.my.target.ha;
import java.util.Objects;

public final class ImageData
extends a<Bitmap> {
    private static final int MIN_CACHE_SIZE = 0x500000;
    private static final int DEFAULT_CACHE_SIZE = 0x1E00000;
    @NonNull
    private static volatile LruCache<String, Bitmap> memcache = new BitmapCache(0x1E00000);
    private volatile boolean useCache;

    @AnyThread
    public static void setCacheSize(int sizeInBytes) {
        int n10;
        if (sizeInBytes < 0x500000) {
            ha.a("ImageData: Setting cache size ignored - size should be >= 5242880");
            return;
        }
        memcache.resize(n10);
    }

    @AnyThread
    public static void clearCache() {
        memcache.evictAll();
    }

    @NonNull
    public static ImageData newImageData(@NonNull String url) {
        String string;
        return new ImageData(string);
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public static ImageData newImageData(@NonNull String url, int width, int height) {
        void var2_2;
        void var1_1;
        String string;
        return new ImageData(string, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private ImageData(@NonNull String url) {
        super((String)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ImageData(@NonNull String url, int width, int height) {
        super((String)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.width = var2_2;
        this.height = var3_3;
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    @Nullable
    public Bitmap getBitmap() {
        return this.getData();
    }

    /*
     * WARNING - void declaration
     */
    public void setBitmap(@Nullable Bitmap bitmap) {
        void var1_1;
        this.setData((Bitmap)var1_1);
    }

    @Override
    @Nullable
    public Bitmap getData() {
        if (this.useCache) {
            return (Bitmap)memcache.get((Object)this.url);
        }
        return (Bitmap)super.getData();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setData(@Nullable Bitmap data) {
        void var1_1;
        if (this.useCache) {
            if (var1_1 == null) {
                memcache.remove((Object)this.url);
            } else {
                memcache.put((Object)this.url, (Object)var1_1);
            }
        } else {
            super.setData(var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(@Nullable Object object) {
        void var1_1;
        if (this_ == var1_1) {
            return true;
        }
        if (var1_1 != null && ImageData.class == var1_1.getClass()) {
            if (!super.equals(var1_1)) {
                return false;
            }
            ImageData imageData = this_;
            ImageData this_ = (ImageData)var1_1;
            return imageData.useCache == this_.useCache;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.useCache);
    }

    /*
     * WARNING - void declaration
     */
    public void useCache(boolean use) {
        void var1_1;
        if (use == this.useCache) {
            return;
        }
        this.useCache = var1_1;
        if (var1_1 != false) {
            Bitmap bitmap = (Bitmap)super.getData();
            if (bitmap != null) {
                super.setData(null);
                memcache.put((Object)this.url, (Object)bitmap);
            }
        } else {
            super.setData((Bitmap)memcache.remove((Object)this.url));
        }
    }

    @NonNull
    public String toString() {
        return "ImageData{url='" + this.url + '\'' + ", width=" + this.width + ", height=" + this.height + ", bitmap=" + this.getData() + '}';
    }

    public static class BitmapCache
    extends LruCache<String, Bitmap> {
        /*
         * WARNING - void declaration
         */
        public BitmapCache(int maxSize) {
            super((int)var1_1);
            void var1_1;
        }

        public int sizeOf(String key, Bitmap value) {
            return value.getAllocationByteCount();
        }
    }
}

