/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.instreamads;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.c3;
import com.my.target.common.BaseAd;
import com.my.target.common.menu.MenuFactory;
import com.my.target.common.models.AudioData;
import com.my.target.common.models.IAdLoadingError;
import com.my.target.common.models.ImageData;
import com.my.target.common.models.ShareButtonData;
import com.my.target.d5;
import com.my.target.e1;
import com.my.target.g5;
import com.my.target.h1;
import com.my.target.ha;
import com.my.target.instreamads.InstreamAudioAdPlayer;
import com.my.target.j;
import com.my.target.m;
import com.my.target.q;
import com.my.target.r5;
import com.my.target.y2;
import com.my.target.z2;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class InstreamAudioAd
extends BaseAd {
    private static final int DEFAULT_LOADING_TIMEOUT_SECONDS = 10;
    private static final int MIN_LOADING_TIMEOUT_SECONDS = 5;
    @NonNull
    private final Context context;
    @NonNull
    private final MenuFactory adChoicesMenuFactory;
    @Nullable
    private c3 section;
    @Nullable
    private y2 engine;
    @Nullable
    private InstreamAudioAdPlayer player;
    @Nullable
    private InstreamAudioAdListener listener;
    private int loadingTimeoutSeconds;
    private float volume;
    @Nullable
    private float[] midpoints;
    @Nullable
    private float[] userMidpoints;
    private float audioDuration;

    /*
     * WARNING - void declaration
     */
    public InstreamAudioAd(int slotId, @NonNull Context context) {
        super((int)var1_1, "instreamaudioads");
        h1 h12;
        void var2_2;
        void var1_1;
        ((InstreamAudioAd)((Object)this_)).loadingTimeoutSeconds = 10;
        ((InstreamAudioAd)((Object)this_)).volume = 1.0f;
        ((InstreamAudioAd)((Object)this_)).context = var2_2;
        h1 this_ = h12;
        h12 = new h1();
        v1.adChoicesMenuFactory = this_;
        ha.c("Instream audio ad created. Version - 5.20.1");
    }

    /*
     * WARNING - void declaration
     */
    public InstreamAudioAd(int slotId, @NonNull MenuFactory adChoicesMenuFactory, @NonNull Context context) {
        super((int)var1_1, "instreamaudioads");
        void var2_2;
        void var3_3;
        void var1_1;
        this.loadingTimeoutSeconds = 10;
        this.volume = 1.0f;
        this.context = var3_3;
        this.adChoicesMenuFactory = var2_2;
        ha.c("Instream audio ad created. Version - 5.20.1");
    }

    private void handleResult(@Nullable c3 object, @Nullable IAdLoadingError object2) {
        Object object3 = this.listener;
        if (object3 == null) {
            return;
        }
        if (object == null) {
            if (object2 == null) {
                object2 = m.o;
            }
            object3.onNoAd((IAdLoadingError)object2, this);
            return;
        }
        if (!((c3)object).d()) {
            object = this.listener;
            if (object2 == null) {
                object2 = m.r;
            }
            object.onNoAd((IAdLoadingError)object2, this);
            return;
        }
        InstreamAudioAd instreamAudioAd = this;
        Object object4 = object;
        InstreamAudioAd instreamAudioAd2 = this;
        instreamAudioAd2.section = object;
        object = instreamAudioAd2.adConfig;
        object2 = instreamAudioAd2.metricFactory;
        object3 = instreamAudioAd2.adChoicesMenuFactory;
        this.engine = object = y2.a(instreamAudioAd, (c3)object4, (j)object, (r5.a)object2, (MenuFactory)object3);
        ((y2)object).a(this.loadingTimeoutSeconds);
        instreamAudioAd.engine.a(this.volume);
        object = instreamAudioAd.player;
        if (object != null) {
            this.engine.a((InstreamAudioAdPlayer)object);
        }
        InstreamAudioAd instreamAudioAd3 = this;
        float f10 = instreamAudioAd3.audioDuration;
        instreamAudioAd3.configureMidpoints(f10, instreamAudioAd3.userMidpoints);
        instreamAudioAd3.listener.onLoad(this);
    }

    /*
     * WARNING - void declaration
     */
    private void start(@NonNull String sectionName) {
        void var1_1;
        y2 y22 = this.engine;
        if (y22 == null) {
            ha.a("InstreamAudioAd: Unable to start ad \u2013 not loaded yet");
            return;
        }
        if (y22.c() == null) {
            ha.a("InstreamAudioAd: Unable to start ad \u2013 player has not set");
            return;
        }
        this.engine.a((String)var1_1);
    }

    @Nullable
    public InstreamAudioAdListener getListener() {
        return this.listener;
    }

    /*
     * WARNING - void declaration
     */
    public void setListener(@Nullable InstreamAudioAdListener listener) {
        void var1_1;
        this.listener = var1_1;
    }

    public int getLoadingTimeout() {
        return this.loadingTimeoutSeconds;
    }

    /*
     * WARNING - void declaration
     */
    public void setLoadingTimeout(int loadingTimeout) {
        if (loadingTimeout < 5) {
            ha.a("InstreamAudioAd: Unable to set ad loading timeout < 5, set to 5 seconds");
            this.loadingTimeoutSeconds = 5;
        } else {
            void var1_1;
            ha.a("InstreamAudioAd: Ad loading timeout set to " + (int)var1_1 + " seconds");
            this.loadingTimeoutSeconds = var1_1;
        }
        y2 y22 = this.engine;
        if (y22 != null) {
            y22.a(this.loadingTimeoutSeconds);
        }
    }

    @Nullable
    public InstreamAudioAdPlayer getPlayer() {
        return this.player;
    }

    /*
     * WARNING - void declaration
     */
    public void setPlayer(@Nullable InstreamAudioAdPlayer player) {
        void var1_1;
        ((InstreamAudioAd)((Object)this_)).player = var1_1;
        y2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.a((InstreamAudioAdPlayer)var1_1);
        }
    }

    public float getVolume() {
        y2 y22 = this.engine;
        if (y22 != null) {
            return y22.d();
        }
        return this.volume;
    }

    /*
     * WARNING - void declaration
     */
    public void setVolume(float volume) {
        void var1_1;
        if (Float.compare(volume, 0.0f) >= 0 && Float.compare((float)var1_1, 1.0f) <= 0) {
            ((InstreamAudioAd)((Object)y22)).volume = var1_1;
            y2 y22 = ((InstreamAudioAd)((Object)y22)).engine;
            if (y22 != null) {
                y22.a((float)var1_1);
            }
            return;
        }
        ha.a("InstreamAudioAd: Unable to set volume" + (float)var1_1 + ", volume must be in range [0..1]");
    }

    @NonNull
    public float[] getMidPoints() {
        Object this_ = ((InstreamAudioAd)this_).midpoints;
        if (((InstreamAudioAd)this_).midpoints == null) {
            return new float[0];
        }
        return (float[])this_.clone();
    }

    @Nullable
    public InstreamAudioAdBanner getCurrentBanner() {
        y2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            return this_.b();
        }
        return null;
    }

    public void load() {
        if (this.isLoadCalled()) {
            ha.a("InstreamAudioAd: Doesn't support multiple load");
            this.handleResult(null, m.t);
            return;
        }
        InstreamAudioAd instreamAudioAd = this;
        r5 r52 = instreamAudioAd.metricFactory.a();
        InstreamAudioAd instreamAudioAd2 = this;
        r5.a a10 = instreamAudioAd2.metricFactory;
        z2.a(instreamAudioAd.adConfig, a10, instreamAudioAd2.loadingTimeoutSeconds).a(this::handleResult).a(r52, this.context);
    }

    /*
     * WARNING - void declaration
     */
    public void configureMidpoints(float audioDuration) {
        void var1_1;
        this.configureMidpoints((float)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void configureMidpoints(float audioDuration, @Nullable float[] midpoints) {
        void var1_1;
        q q10;
        if (audioDuration <= 0.0f) {
            ha.a("InstreamAudioAd: Midpoints are not configured, duration is not set or <= zero");
            return;
        }
        if (((InstreamAudioAd)object).midpoints != null) {
            ha.a("InstreamAudioAd: Midpoints already configured");
            return;
        }
        ((InstreamAudioAd)object).userMidpoints = q10;
        ((InstreamAudioAd)object).audioDuration = var1_1;
        q10 = ((InstreamAudioAd)object).section;
        if (q10 != null && (q10 = q10.a("midroll")) != null) {
            InstreamAudioAd instreamAudioAd = object;
            float[] fArray = g5.a(q10, ((InstreamAudioAd)object).userMidpoints, (float)var1_1);
            Object object = fArray;
            instreamAudioAd.midpoints = fArray;
            y2 y22 = instreamAudioAd.engine;
            if (y22 != null) {
                y22.a((float[])object);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void configureMidpointsPercents(float audioDuration, @Nullable float[] midpointsPercents) {
        void var2_2;
        void var1_1;
        if (midpointsPercents == null) {
            this.configureMidpoints((float)var1_1);
            return;
        }
        this.configureMidpoints((float)var1_1, g5.a((float)var1_1, (float[])var2_2));
    }

    public void pause() {
        y2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.e();
        }
    }

    public void resume() {
        y2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.g();
        }
    }

    public void stop() {
        y2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.j();
        }
    }

    public void skip() {
        y2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.h();
        }
    }

    public void skipBanner() {
        y2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.i();
        }
    }

    public void destroy() {
        ((InstreamAudioAd)((Object)this_)).listener = null;
        y2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            this_.a();
        }
    }

    public void startPreroll() {
        this.start("preroll");
    }

    public void startPostroll() {
        this.start("postroll");
    }

    public void startPauseroll() {
        this.start("pauseroll");
    }

    /*
     * WARNING - void declaration
     */
    public void startMidroll(float point) {
        void var1_1;
        y2 y22 = this.engine;
        if (y22 == null) {
            ha.a("InstreamAudioAd: Unable to start ad \u2013 not loaded yet");
            return;
        }
        if (y22.c() == null) {
            ha.a("InstreamAudioAd: Unable to start ad \u2013 player has not set");
            return;
        }
        this.engine.b((float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void handleCompanionClick(@NonNull InstreamAdCompanionBanner instreamAdCompanionBanner) {
        y2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            void var1_1;
            this_.b((InstreamAdCompanionBanner)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleCompanionClick(@NonNull InstreamAdCompanionBanner instreamAdCompanionBanner, @NonNull Context context) {
        y2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            void var2_2;
            void var1_1;
            this_.a((InstreamAdCompanionBanner)var1_1, (Context)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleCompanionShow(@NonNull InstreamAdCompanionBanner instreamAdCompanionBanner) {
        y2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ != null) {
            void var1_1;
            this_.c((InstreamAdCompanionBanner)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleAdChoicesClick(@NonNull Context context) {
        void var1_1;
        y2 this_ = ((InstreamAudioAd)((Object)this_)).engine;
        if (this_ == null) {
            return;
        }
        this_.a((Context)var1_1);
    }

    public static interface InstreamAudioAdListener {
        public void onLoad(@NonNull InstreamAudioAd var1);

        public void onNoAd(@NonNull IAdLoadingError var1, @NonNull InstreamAudioAd var2);

        public void onError(@NonNull String var1, @NonNull InstreamAudioAd var2);

        public void onBannerStart(@NonNull InstreamAudioAd var1, @NonNull InstreamAudioAdBanner var2);

        public void onBannerComplete(@NonNull InstreamAudioAd var1, @NonNull InstreamAudioAdBanner var2);

        public void onBannerTimeLeftChange(float var1, float var2, @NonNull InstreamAudioAd var3);

        public void onComplete(@NonNull String var1, @NonNull InstreamAudioAd var2);

        public void onBannerShouldClose(@NonNull InstreamAudioAd var1, @NonNull InstreamAudioAdBanner var2);
    }

    public static final class InstreamAudioAdBanner {
        public final float duration;
        public final boolean allowSeek;
        public final boolean allowPause;
        public final boolean allowSkip;
        public final boolean allowTrackChange;
        public final boolean hasAdChoices;
        @Nullable
        public final ImageData adChoicesIcon;
        @Nullable
        public final String adText;
        @Nullable
        public final String bundleId;
        @NonNull
        public final ArrayList<ShareButtonData> shareButtonDatas;
        @NonNull
        public final List<InstreamAdCompanionBanner> companionBanners;
        @NonNull
        public final String advertisingLabel;

        @NonNull
        public static InstreamAudioAdBanner newBanner(@NonNull d5<AudioData> d52) {
            ArrayList<InstreamAdCompanionBanner> arrayList;
            ArrayList<InstreamAdCompanionBanner> arrayList2 = arrayList;
            arrayList = new ArrayList<InstreamAdCompanionBanner>();
            Iterator<e1> iterator = d52.getCompanionBanners().iterator();
            while (iterator.hasNext()) {
                arrayList2.add(InstreamAdCompanionBanner.newBanner(iterator.next()));
            }
            boolean bl = false;
            ImageData imageData = null;
            if (d52.getAdChoices() != null) {
                bl = true;
                imageData = d52.getAdChoices().c();
            }
            d5<AudioData> d53 = d52;
            boolean bl2 = d53.isAllowSeek();
            boolean bl3 = d53.isAllowSkip();
            boolean bl4 = d53.isAllowTrackChange();
            float f10 = d53.getDuration();
            String string = d53.getAdText();
            boolean bl5 = d53.isAllowPause();
            ArrayList<ShareButtonData> arrayList3 = d53.getShareButtonDatas();
            String string2 = d53.getAdvertisingLabel();
            String string3 = d53.getBundleId();
            return new InstreamAudioAdBanner(bl2, bl3, bl4, f10, string, bl5, arrayList3, arrayList2, bl, string2, imageData, string3);
        }

        /*
         * WARNING - void declaration
         */
        private InstreamAudioAdBanner(boolean allowSeek, boolean allowSkip, boolean allowTrackChange, float duration, @Nullable String adText, boolean allowPause, @NonNull ArrayList<ShareButtonData> shareButtonDatas, @NonNull List<InstreamAdCompanionBanner> companionBanners, boolean hasAdChoices, @NonNull String advertisingLabel, @Nullable ImageData adChoicesIcon, @Nullable String bundleId) {
            void var12_12;
            void var11_11;
            void var10_10;
            void var9_9;
            void var8_8;
            void var7_7;
            void var5_5;
            void var4_4;
            void var3_3;
            void var6_6;
            void var2_2;
            void var1_1;
            this.allowSeek = var1_1;
            this.allowSkip = var2_2;
            this.allowPause = var6_6;
            this.allowTrackChange = var3_3;
            this.duration = var4_4;
            this.adText = var5_5;
            this.shareButtonDatas = var7_7;
            this.companionBanners = var8_8;
            this.hasAdChoices = var9_9;
            this.advertisingLabel = var10_10;
            this.adChoicesIcon = var11_11;
            this.bundleId = var12_12;
        }

        @NonNull
        public String toString() {
            return "InstreamAudioAdBanner{duration=" + this.duration + ", allowSeek=" + this.allowSeek + ", allowPause=" + this.allowPause + ", allowSkip=" + this.allowSkip + ", allowTrackChange=" + this.allowTrackChange + ", hasAdChoices=" + this.hasAdChoices + ", adChoicesIcon=" + this.adChoicesIcon + ", adText='" + this.adText + '\'' + ", bundleId='" + this.bundleId + '\'' + ", shareButtonDatas=" + this.shareButtonDatas + ", companionBanners=" + this.companionBanners + ", advertisingLabel='" + this.advertisingLabel + '\'' + '}';
        }
    }

    public static final class InstreamAdCompanionBanner {
        public final int width;
        public final int height;
        public final int assetWidth;
        public final int assetHeight;
        public final int expandedWidth;
        public final int expandedHeight;
        public final boolean isClickable;
        @Nullable
        public final String staticResource;
        @Nullable
        public final String iframeResource;
        @Nullable
        public final String htmlResource;
        @Nullable
        public final String apiFramework;
        @Nullable
        public final String adSlotID;
        @Nullable
        public final String required;
        @Nullable
        public final String bundleId;

        @NonNull
        public static InstreamAdCompanionBanner newBanner(@NonNull e1 e12) {
            e1 e13 = e12;
            int n10 = e13.getWidth();
            int n11 = e13.getHeight();
            int n12 = e13.getAssetWidth();
            int n13 = e13.getAssetHeight();
            int n14 = e13.getExpandedWidth();
            int n15 = e13.getExpandedHeight();
            boolean bl = TextUtils.isEmpty((CharSequence)e13.getTrackingLink()) ^ true;
            String string = e13.getStaticResource();
            String string2 = e13.getIframeResource();
            String string3 = e13.getHtmlResource();
            String string4 = e13.getApiFramework();
            String string5 = e13.getAdSlotID();
            String string6 = e13.getRequired();
            String string7 = e13.getBundleId();
            return new InstreamAdCompanionBanner(n10, n11, n12, n13, n14, n15, bl, string, string2, string3, string4, string5, string6, string7);
        }

        /*
         * WARNING - void declaration
         */
        private InstreamAdCompanionBanner(int width, int height, int assetWidth, int assetHeight, int expandedWidth, int expandedHeight, boolean isClickable, @Nullable String staticResource, @Nullable String iframeResource, @Nullable String htmlResource, @Nullable String apiFramework, @Nullable String adSlotID, @Nullable String required, @Nullable String bundleId) {
            void var14_14;
            void var13_13;
            void var12_12;
            void var11_11;
            void var10_10;
            void var9_9;
            void var8_8;
            void var7_7;
            void var6_6;
            void var5_5;
            void var4_4;
            void var3_3;
            void var2_2;
            void var1_1;
            this.width = var1_1;
            this.height = var2_2;
            this.assetWidth = var3_3;
            this.assetHeight = var4_4;
            this.expandedWidth = var5_5;
            this.expandedHeight = var6_6;
            this.isClickable = var7_7;
            this.staticResource = var8_8;
            this.iframeResource = var9_9;
            this.htmlResource = var10_10;
            this.apiFramework = var11_11;
            this.adSlotID = var12_12;
            this.required = var13_13;
            this.bundleId = var14_14;
        }

        @NonNull
        public String toString() {
            return "InstreamAdCompanionBanner{width=" + this.width + ", height=" + this.height + ", assetWidth=" + this.assetWidth + ", assetHeight=" + this.assetHeight + ", expandedWidth=" + this.expandedWidth + ", expandedHeight=" + this.expandedHeight + ", isClickable=" + this.isClickable + ", staticResource='" + this.staticResource + '\'' + ", iframeResource='" + this.iframeResource + '\'' + ", htmlResource='" + this.htmlResource + '\'' + ", apiFramework='" + this.apiFramework + '\'' + ", adSlotID='" + this.adSlotID + '\'' + ", required='" + this.required + '\'' + ", bundleId='" + this.bundleId + '\'' + '}';
        }
    }
}

