/*
 * Decompiled with CFR 0.152.
 */
package com.my.target.nativeads.banners;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.my.target.common.models.ImageData;
import com.my.target.h6;
import com.my.target.j6;
import com.my.target.nativeads.banners.NativeBanner;
import com.my.target.nativeads.banners.NativePromoCard;
import java.util.ArrayList;

public class NativePromoBanner
extends NativeBanner {
    private final boolean hasVideo;
    @Nullable
    private final ImageData image;
    @NonNull
    private final ArrayList<NativePromoCard> nativePromoCards;
    @Nullable
    private String category;
    @Nullable
    private String subCategory;

    @NonNull
    public static NativePromoBanner newBanner(@NonNull h6 h62) {
        return new NativePromoBanner(h62);
    }

    /*
     * WARNING - void declaration
     */
    public NativePromoBanner(@Nullable String title, @Nullable String ctaText, @Nullable String domain, @Nullable String advertisingLabel, @Nullable ImageData icon, float rating, @Nullable String ageRestrictions, @Nullable String disclaimer, int votes, @NonNull String navigationType, boolean hasVideo, @Nullable String description, @Nullable ImageData image, boolean hasAdChoices, @Nullable ImageData adChoicesIcon, @Nullable String bundleId) {
        super((String)var1_1, (String)var2_2, (String)var12_12, (String)var3_3, (String)var4_4, (ImageData)var5_5, (float)var6_6, (String)var7_7, (String)var8_8, (int)var9_9, (String)var10_10, (boolean)var14_14, (ImageData)var15_15, (String)var16_16);
        void var13_13;
        void var11_11;
        ArrayList arrayList;
        void var16_16;
        void var15_15;
        void var14_14;
        void var10_10;
        void var9_9;
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var12_12;
        void var2_2;
        void var1_1;
        ArrayList this_ = arrayList;
        arrayList = new ArrayList();
        v1.nativePromoCards = this_;
        v1.hasVideo = var11_11;
        v1.image = var13_13;
    }

    private NativePromoBanner(@NonNull h6 h62) {
        super(h62);
        this.nativePromoCards = new ArrayList();
        boolean bl = h62.getVideoBanner() != null;
        this.hasVideo = bl;
        String string = h62.getCategory();
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = null;
        }
        this.category = string;
        string = h62.getSubCategory();
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = null;
        }
        this.subCategory = string;
        this.image = h62.getImage();
        this.processCards(h62);
    }

    private void processCards(@NonNull h6 iterator) {
        if (!this.hasVideo && !(iterator = ((h6)((Object)iterator)).getNativeAdCards()).isEmpty()) {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                j6 j62 = (j6)iterator.next();
                this.nativePromoCards.add(NativePromoCard.newCard(j62));
            }
        }
    }

    @Nullable
    public String getCategory() {
        return this.category;
    }

    @Nullable
    public String getSubCategory() {
        return this.subCategory;
    }

    @Nullable
    public ImageData getImage() {
        return this.image;
    }

    public boolean hasVideo() {
        return this.hasVideo;
    }

    @NonNull
    public ArrayList<NativePromoCard> getCards() {
        return this.nativePromoCards;
    }

    @Override
    @NonNull
    public String toString() {
        return "NativePromoBanner{hasVideo=" + this.hasVideo + ", image=" + this.image + ", nativePromoCards=" + this.nativePromoCards + ", category='" + this.category + '\'' + ", subCategory='" + this.subCategory + '\'' + ", navigationType='" + this.navigationType + '\'' + ", rating=" + this.rating + ", votes=" + this.votes + ", hasAdChoices=" + this.hasAdChoices + ", title='" + this.title + '\'' + ", ctaText='" + this.ctaText + '\'' + ", description='" + this.description + '\'' + ", disclaimer='" + this.disclaimer + '\'' + ", ageRestrictions='" + this.ageRestrictions + '\'' + ", domain='" + this.domain + '\'' + ", advertisingLabel='" + this.advertisingLabel + '\'' + ", bundleId='" + this.bundleId + '\'' + ", icon=" + this.icon + ", adChoicesIcon=" + this.adChoicesIcon + '}';
    }

    public static final class Builder {
        boolean hasAdChoices;
        private float rating;
        private int votes;
        private boolean hasVideo;
        @NonNull
        private String navigationType = "web";
        @Nullable
        private ImageData adChoicesIcon;
        @Nullable
        private String title;
        @Nullable
        private String ctaText;
        @Nullable
        private String domain;
        @Nullable
        private String advertisingLabel;
        @Nullable
        private String bundleId;
        @Nullable
        private ImageData icon;
        @Nullable
        private String ageRestrictions;
        @Nullable
        private String disclaimer;
        @Nullable
        private String description;
        @Nullable
        private ImageData image;

        @NonNull
        public static Builder createBuilder() {
            return new Builder();
        }

        private Builder() {
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAdChoicesIcon(@Nullable ImageData adChoicesIcon) {
            void var1_1;
            this.adChoicesIcon = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setHasAdChoices(boolean hasAdChoices) {
            void var1_1;
            this.hasAdChoices = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setHasVideo(boolean hasVideo) {
            void var1_1;
            this.hasVideo = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setDescription(@Nullable String description) {
            void var1_1;
            this.description = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setImage(@Nullable ImageData image) {
            void var1_1;
            this.image = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTitle(String title) {
            void var1_1;
            this.title = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setCtaText(@Nullable String ctaText) {
            void var1_1;
            this.ctaText = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setDomain(@Nullable String domain) {
            void var1_1;
            this.domain = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAdvertisingLabel(@Nullable String advertisingLabel) {
            void var1_1;
            this.advertisingLabel = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setBundleId(@Nullable String bundleId) {
            void var1_1;
            this.bundleId = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setIcon(@Nullable ImageData icon) {
            void var1_1;
            this.icon = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRating(float rating) {
            void var1_1;
            this.rating = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAgeRestrictions(@Nullable String ageRestrictions) {
            void var1_1;
            this.ageRestrictions = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setDisclaimer(@Nullable String disclaimer) {
            void var1_1;
            this.disclaimer = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setVotes(int votes) {
            void var1_1;
            this.votes = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setNavigationType(@NonNull String navigationType) {
            void var1_1;
            if ("web".equals(var1_1) || "store".equals(var1_1)) {
                this.navigationType = var1_1;
            }
            return this;
        }

        @NonNull
        public NativePromoBanner build() {
            Builder builder = string;
            String string = builder.title;
            String string2 = builder.ctaText;
            String string3 = builder.domain;
            String string4 = builder.advertisingLabel;
            ImageData imageData = builder.icon;
            float f10 = builder.rating;
            String string5 = builder.ageRestrictions;
            String string6 = builder.disclaimer;
            int n10 = builder.votes;
            String string7 = builder.navigationType;
            boolean bl = builder.hasVideo;
            String string8 = builder.description;
            ImageData imageData2 = builder.image;
            boolean bl2 = builder.hasAdChoices;
            ImageData imageData3 = builder.adChoicesIcon;
            String string9 = builder.bundleId;
            return new NativePromoBanner(string, string2, string3, string4, imageData, f10, string5, string6, n10, string7, bl, string8, imageData2, bl2, imageData3, string9);
        }
    }
}

