/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.codegen.dialect;

import com.mybatisflex.codegen.entity.Column;
import com.mybatisflex.codegen.entity.Table;
import com.mybatisflex.core.util.StringUtil;
import java.util.HashMap;
import java.util.Map;

public class JdbcTypeMapping {
    private static final Map<String, String> mapping = new HashMap<String, String>();
    private static JdbcTypeMapper typeMapper;

    private JdbcTypeMapping() {
    }

    public static void registerMapping(Class<?> from, Class<?> to) {
        JdbcTypeMapping.registerMapping(from.getName(), to.getName());
    }

    public static void registerMapping(String from, String to) {
        mapping.put(from, to);
    }

    public static Map<String, String> getMapping() {
        return mapping;
    }

    public static JdbcTypeMapper getTypeMapper() {
        return typeMapper;
    }

    public static void setTypeMapper(JdbcTypeMapper typeMapper) {
        JdbcTypeMapping.typeMapper = typeMapper;
    }

    public static void registerDateTypes() {
        JdbcTypeMapping.registerMapping("java.sql.Time", "java.util.Date");
        JdbcTypeMapping.registerMapping("java.sql.Timestamp", "java.util.Date");
        JdbcTypeMapping.registerMapping("java.time.LocalDateTime", "java.util.Date");
        JdbcTypeMapping.registerMapping("java.time.LocalDate", "java.util.Date");
    }

    public static String getType(String jdbcType, Table table, Column column) {
        String type;
        if (typeMapper != null && StringUtil.hasText((String)(type = typeMapper.getType(jdbcType, table, column)))) {
            return type;
        }
        String registered = mapping.get(jdbcType);
        return StringUtil.hasText((String)registered) ? registered : jdbcType;
    }

    static {
        JdbcTypeMapping.registerMapping("[B", "byte[]");
        JdbcTypeMapping.registerMapping("oracle.jdbc.OracleBlob", "byte[]");
    }

    public static interface JdbcTypeMapper {
        public String getType(String var1, Table var2, Column var3);
    }
}

