/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.codegen.dialect.impl;

import com.alibaba.druid.pool.DruidPooledConnection;
import com.mybatisflex.codegen.dialect.AbstractJdbcDialect;
import com.mybatisflex.codegen.entity.Table;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.StringUtil;
import com.zaxxer.hikari.pool.HikariProxyConnection;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleConnection;

public class OracleJdbcDialect
extends AbstractJdbcDialect {
    @Override
    public String forBuildColumnsSql(String schema, String tableName) {
        return "SELECT * FROM \"" + (StringUtil.hasText((String)schema) ? schema + "\".\"" : "") + tableName + "\" WHERE rownum < 1";
    }

    @Override
    public ResultSet getTablesResultSet(DatabaseMetaData dbMeta, Connection conn, String schema, String[] types) throws SQLException {
        return dbMeta.getTables(conn.getCatalog(), StringUtil.hasText((String)schema) ? schema : dbMeta.getUserName(), null, types);
    }

    @Override
    protected ResultSet forRemarks(String schema, Table table, DatabaseMetaData dbMeta, Connection conn) throws SQLException {
        if (conn instanceof OracleConnection) {
            ((OracleConnection)conn).setRemarksReporting(true);
            return dbMeta.getColumns(conn.getCatalog(), StringUtil.hasText((String)schema) ? schema : dbMeta.getUserName(), table.getName(), null);
        }
        if ("com.zaxxer.hikari.pool.HikariProxyConnection".equals(conn.getClass().getName())) {
            return this.forRemarks(schema, table, dbMeta, this.getOriginalConn(HikariProxyConnection.class, "delegate", conn));
        }
        if ("com.alibaba.druid.pool.DruidPooledConnection".equals(conn.getClass().getName())) {
            return this.forRemarks(schema, table, dbMeta, this.getOriginalConn(DruidPooledConnection.class, "conn", conn));
        }
        return null;
    }

    private Connection getOriginalConn(Class<?> clazz, String attr, Connection conn) {
        Field delegate = ClassUtil.getFirstField(clazz, field -> field.getName().equals(attr));
        try {
            delegate.setAccessible(true);
            return (Connection)delegate.get(conn);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

