/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.codegen.config;

import com.mybatisflex.codegen.entity.Table;
import java.io.Serializable;
import java.lang.reflect.TypeVariable;
import java.util.function.Function;

public class EntityConfig
implements Serializable {
    private static final long serialVersionUID = -6790274333595436008L;
    private String sourceDir;
    private String classPrefix = "";
    private String classSuffix = "";
    private Class<?> superClass;
    private Function<Table, Class<?>> superClassFactory;
    private boolean overwriteEnable;
    private boolean baseOverwriteEnable;
    private Class<?>[] implInterfaces = new Class[]{Serializable.class};
    private boolean withLombok;
    private boolean lombokNoArgsConstructorEnable = true;
    private boolean lombokAllArgsConstructorEnable = true;
    private boolean withSwagger;
    private SwaggerVersion swaggerVersion;
    private boolean withActiveRecord;
    private String dataSource;
    private int jdkVersion;
    private boolean withBaseClassEnable = false;
    private String withBaseClassSuffix = "Base";
    private String withBasePackage;
    private boolean columnCommentEnable;
    private boolean alwaysGenColumnAnnotation;
    private boolean superClassGenericity = false;

    public String getSourceDir() {
        return this.sourceDir;
    }

    public EntityConfig setSourceDir(String sourceDir) {
        this.sourceDir = sourceDir;
        return this;
    }

    public String getClassPrefix() {
        return this.classPrefix;
    }

    public EntityConfig setClassPrefix(String classPrefix) {
        this.classPrefix = classPrefix;
        return this;
    }

    public String getClassSuffix() {
        return this.classSuffix;
    }

    public EntityConfig setClassSuffix(String classSuffix) {
        this.classSuffix = classSuffix;
        return this;
    }

    public Class<?> getSuperClass() {
        return this.superClass;
    }

    public EntityConfig setSuperClass(Class<?> superClass) {
        this.superClass = superClass;
        this.superClassGenericity = this.hasGenericity(superClass);
        return this;
    }

    private boolean hasGenericity(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        TypeVariable<Class<?>>[] typeParameters = clazz.getTypeParameters();
        if (typeParameters.length > 1) {
            throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301\u7236\u7c7b\u6cdb\u578b\u6570\u91cf >1 \u7684\u4ee3\u7801\u751f\u6210");
        }
        return typeParameters.length > 0;
    }

    public Class<?> getSuperClass(Table table) {
        if (this.superClassFactory != null) {
            return this.superClassFactory.apply(table);
        }
        return this.superClass;
    }

    public Function<Table, Class<?>> getSuperClassFactory() {
        return this.superClassFactory;
    }

    public EntityConfig setSuperClassFactory(Function<Table, Class<?>> superClassFactory) {
        this.superClassFactory = superClassFactory;
        return this;
    }

    public boolean isOverwriteEnable() {
        return this.overwriteEnable;
    }

    public EntityConfig setOverwriteEnable(boolean overwriteEnable) {
        this.overwriteEnable = overwriteEnable;
        return this;
    }

    public boolean isBaseOverwriteEnable() {
        return this.baseOverwriteEnable;
    }

    public EntityConfig setBaseOverwriteEnable(boolean baseOverwriteEnable) {
        this.baseOverwriteEnable = baseOverwriteEnable;
        return this;
    }

    public Class<?>[] getImplInterfaces() {
        return this.implInterfaces;
    }

    public EntityConfig setImplInterfaces(Class<?> ... implInterfaces) {
        this.implInterfaces = implInterfaces;
        return this;
    }

    public boolean isWithLombok() {
        return this.withLombok;
    }

    public EntityConfig setWithLombok(boolean withLombok) {
        this.withLombok = withLombok;
        return this;
    }

    public boolean isLombokNoArgsConstructorEnable() {
        return this.lombokNoArgsConstructorEnable;
    }

    public EntityConfig setLombokNoArgsConstructorEnable(boolean lombokNoArgsConstructorEnable) {
        this.lombokNoArgsConstructorEnable = lombokNoArgsConstructorEnable;
        return this;
    }

    public boolean isLombokAllArgsConstructorEnable() {
        return this.lombokAllArgsConstructorEnable;
    }

    public EntityConfig setLombokAllArgsConstructorEnable(boolean lombokAllArgsConstructorEnable) {
        this.lombokAllArgsConstructorEnable = lombokAllArgsConstructorEnable;
        return this;
    }

    public boolean isWithSwagger() {
        return this.withSwagger;
    }

    public EntityConfig setWithSwagger(boolean withSwagger) {
        this.withSwagger = withSwagger;
        this.swaggerVersion = SwaggerVersion.FOX;
        return this;
    }

    public SwaggerVersion getSwaggerVersion() {
        return this.swaggerVersion;
    }

    public EntityConfig setSwaggerVersion(SwaggerVersion swaggerVersion) {
        this.swaggerVersion = swaggerVersion;
        this.withSwagger = swaggerVersion != null;
        return this;
    }

    public boolean isWithActiveRecord() {
        return this.withActiveRecord;
    }

    public EntityConfig setWithActiveRecord(boolean withActiveRecord) {
        this.withActiveRecord = withActiveRecord;
        return this;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public EntityConfig setDataSource(String dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public int getJdkVersion() {
        return this.jdkVersion;
    }

    public EntityConfig setJdkVersion(int jdkVersion) {
        this.jdkVersion = jdkVersion;
        return this;
    }

    public boolean isWithBaseClassEnable() {
        return this.withBaseClassEnable;
    }

    public EntityConfig setWithBaseClassEnable(boolean withBaseClassEnable) {
        this.withBaseClassEnable = withBaseClassEnable;
        return this;
    }

    public String getWithBaseClassSuffix() {
        return this.withBaseClassSuffix;
    }

    public EntityConfig setWithBaseClassSuffix(String withBaseClassSuffix) {
        this.withBaseClassSuffix = withBaseClassSuffix;
        return this;
    }

    public String getWithBasePackage() {
        return this.withBasePackage;
    }

    public EntityConfig setWithBasePackage(String withBasePackage) {
        this.withBasePackage = withBasePackage;
        return this;
    }

    public boolean isColumnCommentEnable() {
        return this.columnCommentEnable;
    }

    public EntityConfig setColumnCommentEnable(boolean columnCommentEnable) {
        this.columnCommentEnable = columnCommentEnable;
        return this;
    }

    public boolean isAlwaysGenColumnAnnotation() {
        return this.alwaysGenColumnAnnotation;
    }

    public EntityConfig setAlwaysGenColumnAnnotation(boolean alwaysGenColumnAnnotation) {
        this.alwaysGenColumnAnnotation = alwaysGenColumnAnnotation;
        return this;
    }

    public boolean isSuperClassGenericity(Table table) {
        if (this.superClassFactory != null) {
            return this.hasGenericity(this.superClassFactory.apply(table));
        }
        return this.superClassGenericity;
    }

    public static enum SwaggerVersion {
        FOX("FOX"),
        DOC("DOC");

        private final String name;

        private SwaggerVersion(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

