/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.codegen.dialect;

import com.alibaba.druid.pool.DruidPooledConnection;
import com.mybatisflex.codegen.config.GlobalConfig;
import com.mybatisflex.codegen.dialect.JdbcDialect;
import com.mybatisflex.codegen.dialect.SqliteDialect;
import com.mybatisflex.codegen.entity.Table;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.StringUtil;
import com.zaxxer.hikari.pool.HikariProxyConnection;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleConnection;

public interface IDialect {
    public static final IDialect DEFAULT = new JdbcDialect(){

        @Override
        String forBuildColumnsSql(String schema, String tableName) {
            return "SELECT * FROM " + (StringUtil.isNotBlank((String)schema) ? schema + "." : "") + tableName + " WHERE 1 = 2";
        }
    };
    public static final IDialect MYSQL = new JdbcDialect(){

        @Override
        String forBuildColumnsSql(String schema, String tableName) {
            return "SELECT * FROM `" + (StringUtil.isNotBlank((String)schema) ? schema + "`.`" : "") + tableName + "` WHERE 1 = 2";
        }
    };
    public static final IDialect ORACLE = new JdbcDialect(){

        @Override
        public String forBuildColumnsSql(String schema, String tableName) {
            return "SELECT * FROM \"" + (StringUtil.isNotBlank((String)schema) ? schema + "\".\"" : "") + tableName + "\" WHERE rownum < 1";
        }

        @Override
        public ResultSet getTablesResultSet(DatabaseMetaData dbMeta, Connection conn, String schema, String[] types) throws SQLException {
            return dbMeta.getTables(conn.getCatalog(), StringUtil.isNotBlank((String)schema) ? schema : dbMeta.getUserName(), null, types);
        }

        @Override
        protected ResultSet forRemarks(String schema, Table table, DatabaseMetaData dbMeta, Connection conn) throws SQLException {
            if (conn instanceof OracleConnection) {
                ((OracleConnection)conn).setRemarksReporting(true);
                return dbMeta.getColumns(conn.getCatalog(), StringUtil.isNotBlank((String)schema) ? schema : dbMeta.getUserName(), table.getName(), null);
            }
            if ("com.zaxxer.hikari.pool.HikariProxyConnection".equals(conn.getClass().getName())) {
                return this.forRemarks(schema, table, dbMeta, this.getOriginalConn(HikariProxyConnection.class, "delegate", conn));
            }
            if ("com.alibaba.druid.pool.DruidPooledConnection".equals(conn.getClass().getName())) {
                return this.forRemarks(schema, table, dbMeta, this.getOriginalConn(DruidPooledConnection.class, "conn", conn));
            }
            return null;
        }

        private Connection getOriginalConn(Class<?> clazz, String attr, Connection conn) {
            Field delegate = ClassUtil.getFirstField(clazz, field -> field.getName().equals(attr));
            try {
                delegate.setAccessible(true);
                return (Connection)delegate.get(conn);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    };
    public static final IDialect SQLITE = new SqliteDialect();

    public void buildTableColumns(String var1, Table var2, GlobalConfig var3, DatabaseMetaData var4, Connection var5) throws SQLException;

    public ResultSet getTablesResultSet(DatabaseMetaData var1, Connection var2, String var3, String[] var4) throws SQLException;
}

