/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.codegen.dialect;

import com.mybatisflex.codegen.config.GlobalConfig;
import com.mybatisflex.codegen.dialect.IDialect;
import com.mybatisflex.codegen.dialect.JdbcTypeMapping;
import com.mybatisflex.codegen.entity.Column;
import com.mybatisflex.codegen.entity.Table;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public abstract class JdbcDialect
implements IDialect {
    @Override
    public void buildTableColumns(String schemaName, Table table, GlobalConfig globalConfig, DatabaseMetaData dbMeta, Connection conn) throws SQLException {
        Map<String, String> columnRemarks = this.buildColumnRemarks(schemaName, table, dbMeta, conn);
        String sql = this.forBuildColumnsSql(table.getSchema(), table.getName());
        try (Statement stm = conn.createStatement();
             ResultSet rs = stm.executeQuery(sql);){
            ResultSetMetaData columnMetaData = rs.getMetaData();
            int columnCount = columnMetaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                Column column = new Column();
                column.setName(columnMetaData.getColumnName(i));
                String jdbcType = columnMetaData.getColumnClassName(i);
                column.setPropertyType(JdbcTypeMapping.getType(jdbcType));
                column.setAutoIncrement(columnMetaData.isAutoIncrement(i));
                column.setNullable(columnMetaData.isNullable(i));
                column.setComment(columnRemarks.get(column.getName()));
                table.addColumn(column);
            }
        }
    }

    private Map<String, String> buildColumnRemarks(String schemaName, Table table, DatabaseMetaData dbMeta, Connection conn) {
        HashMap<String, String> columnRemarks = new HashMap<String, String>();
        try (ResultSet colRs = this.forRemarks(schemaName, table, dbMeta, conn);){
            while (colRs.next()) {
                columnRemarks.put(colRs.getString("COLUMN_NAME"), colRs.getString("REMARKS"));
            }
        }
        catch (Exception e) {
            System.err.println("\u65e0\u6cd5\u83b7\u53d6\u5b57\u6bb5\u7684\u5907\u6ce8\u5185\u5bb9\uff1a" + e.getMessage());
        }
        return columnRemarks;
    }

    @Override
    public ResultSet getTablesResultSet(DatabaseMetaData dbMeta, Connection conn, String schema, String[] types) throws SQLException {
        return dbMeta.getTables(conn.getCatalog(), schema, null, types);
    }

    abstract String forBuildColumnsSql(String var1, String var2);

    protected ResultSet forRemarks(String schemaName, Table table, DatabaseMetaData dbMeta, Connection conn) throws SQLException {
        return dbMeta.getColumns(conn.getCatalog(), null, table.getName(), null);
    }
}

