/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.codegen.entity;

import com.mybatisflex.annotation.ColumnMask;
import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.codegen.config.ColumnConfig;
import com.mybatisflex.core.util.StringUtil;
import java.util.LinkedHashSet;
import java.util.Set;

public class Column {
    private String name;
    private String property;
    private String propertyType;
    private String comment;
    private Integer nullable;
    private boolean isPrimaryKey = false;
    private boolean isAutoIncrement;
    private boolean needGenColumnAnnotation = false;
    private ColumnConfig columnConfig;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.property = this.buildPropertyName();
        this.needGenColumnAnnotation = !name.equalsIgnoreCase(StringUtil.camelToUnderline((String)this.property));
    }

    public String getProperty() {
        return this.property;
    }

    public String getPropertyType() {
        return this.propertyType;
    }

    public String getPropertyDefaultValue() {
        return this.columnConfig.getPropertyDefaultValue();
    }

    public String getPropertySimpleType() {
        if (this.columnConfig.getPropertyType() != null) {
            if (!this.columnConfig.getPropertyType().contains(".")) {
                return this.columnConfig.getPropertyType();
            }
            return StringUtil.substringAfterLast((String)this.columnConfig.getPropertyType(), (String)".");
        }
        return StringUtil.substringAfterLast((String)this.propertyType, (String)".");
    }

    public void setPropertyType(String propertyType) {
        this.propertyType = propertyType;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Integer getNullable() {
        return this.nullable;
    }

    public void setNullable(Integer nullable) {
        this.nullable = nullable;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.isPrimaryKey = primaryKey;
    }

    public Boolean getAutoIncrement() {
        return this.isAutoIncrement;
    }

    public void setAutoIncrement(Boolean autoIncrement) {
        this.isAutoIncrement = autoIncrement;
    }

    public ColumnConfig getColumnConfig() {
        return this.columnConfig;
    }

    public void setColumnConfig(ColumnConfig columnConfig) {
        this.columnConfig = columnConfig;
    }

    public String getterMethod() {
        return "get" + StringUtil.firstCharToUpperCase((String)this.property);
    }

    public String setterMethod() {
        return "set" + StringUtil.firstCharToUpperCase((String)this.property);
    }

    public String buildComment() {
        if (StringUtil.isBlank((String)this.comment)) {
            return "";
        }
        return "/**\n     * " + this.comment + "\n     */";
    }

    public String buildPropertyName() {
        String entityJavaFileName = this.name;
        return StringUtil.firstCharToLowerCase((String)StringUtil.underlineToCamel((String)entityJavaFileName));
    }

    public String buildAnnotations() {
        boolean needComma;
        StringBuilder annotations = new StringBuilder();
        if (this.isPrimaryKey || this.columnConfig.isPrimaryKey()) {
            annotations.append("@Id(");
            needComma = false;
            if (this.isAutoIncrement) {
                annotations.append("keyType = KeyType.Auto");
                needComma = true;
            } else if (this.columnConfig.getKeyType() != null) {
                annotations.append("keyType = KeyType.").append(this.columnConfig.getKeyType().name());
                needComma = true;
            }
            if (this.columnConfig.getKeyValue() != null) {
                this.addComma(annotations, needComma);
                annotations.append("value = \"").append(this.columnConfig.getKeyValue()).append("\"");
                needComma = true;
            }
            if (this.columnConfig.getKeyBefore() != null) {
                this.addComma(annotations, needComma);
                annotations.append("before = ").append(this.columnConfig.getKeyBefore());
            }
            if (annotations.length() == 4) {
                annotations.deleteCharAt(annotations.length() - 1);
            } else {
                annotations.append(")");
            }
        }
        if (this.columnConfig.getOnInsertValue() != null || this.columnConfig.getOnUpdateValue() != null || this.columnConfig.getLarge() != null || this.columnConfig.getLogicDelete() != null || this.columnConfig.getVersion() != null || this.columnConfig.getJdbcType() != null || this.columnConfig.getTypeHandler() != null || this.columnConfig.getTenantId() != null || this.needGenColumnAnnotation) {
            annotations.append("@Column(");
            needComma = false;
            if (this.needGenColumnAnnotation) {
                annotations.append("value = \"").append(this.name).append("\"");
                needComma = true;
            }
            if (this.columnConfig.getOnInsertValue() != null) {
                this.addComma(annotations, needComma);
                annotations.append("onInsertValue = \"").append(this.columnConfig.getOnInsertValue()).append("\"");
                needComma = true;
            }
            if (this.columnConfig.getOnUpdateValue() != null) {
                this.addComma(annotations, needComma);
                annotations.append("onUpdateValue = \"").append(this.columnConfig.getOnUpdateValue()).append("\"");
                needComma = true;
            }
            if (this.columnConfig.getLarge() != null) {
                this.addComma(annotations, needComma);
                annotations.append("isLarge = ").append(this.columnConfig.getLarge());
                needComma = true;
            }
            if (this.columnConfig.getLogicDelete() != null) {
                this.addComma(annotations, needComma);
                annotations.append("isLogicDelete = ").append(this.columnConfig.getLogicDelete());
                needComma = true;
            }
            if (this.columnConfig.getVersion() != null) {
                this.addComma(annotations, needComma);
                annotations.append("version = ").append(this.columnConfig.getVersion());
                needComma = true;
            }
            if (this.columnConfig.getJdbcType() != null) {
                this.addComma(annotations, needComma);
                annotations.append("jdbcType = JdbcType.").append(this.columnConfig.getJdbcType().name());
                needComma = true;
            }
            if (this.columnConfig.getTypeHandler() != null) {
                this.addComma(annotations, needComma);
                annotations.append("typeHandler = ").append(this.columnConfig.getTypeHandler().getSimpleName()).append(".class");
                needComma = true;
            }
            if (Boolean.TRUE.equals(this.columnConfig.getTenantId())) {
                this.addComma(annotations, needComma);
                annotations.append("tenantId = true");
            }
            annotations.append(")");
        }
        if (this.columnConfig.getMask() != null) {
            annotations.append("@ColumnMask(\"").append(this.columnConfig.getMask()).append("\")");
        }
        return annotations.toString();
    }

    private void addComma(StringBuilder annotations, boolean needComma) {
        if (needComma) {
            annotations.append(", ");
        }
    }

    public Set<String> getImportClasses() {
        LinkedHashSet<String> importClasses = new LinkedHashSet<String>();
        Column.addImportClass(importClasses, this.propertyType);
        if (this.isPrimaryKey || this.columnConfig != null && this.columnConfig.isPrimaryKey()) {
            Column.addImportClass(importClasses, Id.class.getName());
            if (this.isAutoIncrement || this.columnConfig != null && this.columnConfig.getKeyType() != null) {
                Column.addImportClass(importClasses, KeyType.class.getName());
            }
        }
        if (this.columnConfig != null) {
            if (this.columnConfig.getPropertyType() != null) {
                Column.addImportClass(importClasses, this.columnConfig.getPropertyType());
            }
            if (this.columnConfig.getMask() != null) {
                Column.addImportClass(importClasses, ColumnMask.class.getName());
            }
            if (this.columnConfig.getJdbcType() != null) {
                Column.addImportClass(importClasses, "org.apache.ibatis.type.JdbcType");
            }
            if (this.columnConfig.getTypeHandler() != null) {
                Column.addImportClass(importClasses, this.columnConfig.getTypeHandler().getName());
            }
            if (this.columnConfig.getOnInsertValue() != null || this.columnConfig.getOnUpdateValue() != null || this.columnConfig.getLarge() != null || this.columnConfig.getLogicDelete() != null || this.columnConfig.getVersion() != null || this.columnConfig.getJdbcType() != null || this.columnConfig.getTypeHandler() != null || Boolean.TRUE.equals(this.columnConfig.getTenantId()) || this.needGenColumnAnnotation) {
                Column.addImportClass(importClasses, com.mybatisflex.annotation.Column.class.getName());
            }
        }
        return importClasses;
    }

    private static void addImportClass(Set<String> importClasses, String importClass) {
        if (importClass.contains(".") && !importClass.startsWith("java.lang.")) {
            importClasses.add(importClass);
        }
    }

    public boolean isDefaultColumn() {
        if (this.columnConfig == null) {
            return true;
        }
        boolean isLarge = this.columnConfig.getLarge() != null && this.columnConfig.getLarge() != false;
        boolean isLogicDelete = this.columnConfig.getLogicDelete() != null && this.columnConfig.getLogicDelete() != false;
        return !isLarge && !isLogicDelete;
    }

    public String toString() {
        return "Column{name='" + this.name + '\'' + ", className='" + this.propertyType + '\'' + ", remarks='" + this.comment + '\'' + ", isAutoIncrement=" + this.isAutoIncrement + '}';
    }
}

