/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.codegen.generator.impl;

import com.mybatisflex.codegen.config.GlobalConfig;
import com.mybatisflex.codegen.config.PackageConfig;
import com.mybatisflex.codegen.config.ServiceConfig;
import com.mybatisflex.codegen.entity.Table;
import com.mybatisflex.codegen.generator.IGenerator;
import com.mybatisflex.core.util.StringUtil;
import java.io.File;
import java.util.HashMap;

public class ServiceGenerator
implements IGenerator {
    private String templatePath;

    public ServiceGenerator() {
        this("/templates/enjoy/service.tpl");
    }

    public ServiceGenerator(String templatePath) {
        this.templatePath = templatePath;
    }

    @Override
    public void generate(Table table, GlobalConfig globalConfig) {
        String servicePackagePath;
        if (!globalConfig.isServiceGenerateEnable()) {
            return;
        }
        PackageConfig packageConfig = globalConfig.getPackageConfig();
        ServiceConfig serviceConfig = globalConfig.getServiceConfig();
        String sourceDir = StringUtil.isNotBlank((String)serviceConfig.getSourceDir()) ? serviceConfig.getSourceDir() : packageConfig.getSourceDir();
        File serviceJavaFile = new File(sourceDir, (servicePackagePath = packageConfig.getServicePackage().replace(".", "/")) + "/" + table.buildServiceClassName() + ".java");
        if (serviceJavaFile.exists() && !serviceConfig.isOverwriteEnable()) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("table", table);
        params.put("serviceConfig", serviceConfig);
        params.put("packageConfig", packageConfig);
        params.put("javadocConfig", globalConfig.getJavadocConfig());
        params.putAll(globalConfig.getCustomConfig());
        globalConfig.getTemplateConfig().getTemplate().generate(params, this.templatePath, serviceJavaFile);
        System.out.println("Service ---> " + serviceJavaFile);
    }

    @Override
    public String getTemplatePath() {
        return this.templatePath;
    }

    @Override
    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }
}

