/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.codegen.generator;

import com.mybatisflex.codegen.generator.IGenerator;
import com.mybatisflex.codegen.generator.impl.ControllerGenerator;
import com.mybatisflex.codegen.generator.impl.EntityGenerator;
import com.mybatisflex.codegen.generator.impl.MapperGenerator;
import com.mybatisflex.codegen.generator.impl.MapperXmlGenerator;
import com.mybatisflex.codegen.generator.impl.PackageInfoGenerator;
import com.mybatisflex.codegen.generator.impl.ServiceGenerator;
import com.mybatisflex.codegen.generator.impl.ServiceImplGenerator;
import com.mybatisflex.codegen.generator.impl.TableDefGenerator;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class GeneratorFactory {
    private static final Map<String, IGenerator> generators = new LinkedHashMap<String, IGenerator>();

    private GeneratorFactory() {
    }

    public static IGenerator getGenerator(String genType) {
        return generators.get(genType);
    }

    public static Collection<IGenerator> getGenerators() {
        return generators.values();
    }

    public static void registerGenerator(String name, IGenerator generator) {
        generators.put(name, generator);
    }

    static {
        GeneratorFactory.registerGenerator("entity", new EntityGenerator());
        GeneratorFactory.registerGenerator("mapper", new MapperGenerator());
        GeneratorFactory.registerGenerator("service", new ServiceGenerator());
        GeneratorFactory.registerGenerator("serviceImpl", new ServiceImplGenerator());
        GeneratorFactory.registerGenerator("controller", new ControllerGenerator());
        GeneratorFactory.registerGenerator("tableDef", new TableDefGenerator());
        GeneratorFactory.registerGenerator("mapperXml", new MapperXmlGenerator());
        GeneratorFactory.registerGenerator("package-info", new PackageInfoGenerator());
    }
}

