/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core;

import com.mybatisflex.annotation.InsertListener;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.annotation.SetListener;
import com.mybatisflex.annotation.UpdateListener;
import com.mybatisflex.core.dialect.DbType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;

public class FlexGlobalConfig {
    private DbType dbType = DbType.MYSQL;
    private Configuration configuration;
    private SqlSessionFactory sqlSessionFactory;
    private KeyConfig keyConfig;
    private Map<Class<?>, SetListener> entitySetListeners = new ConcurrentHashMap();
    private Map<Class<?>, UpdateListener> entityUpdateListeners = new ConcurrentHashMap();
    private Map<Class<?>, InsertListener> entityInsertListeners = new ConcurrentHashMap();
    private Object normalValueOfLogicDelete = 0;
    private Object deletedValueOfLogicDelete = 1;
    private static ConcurrentHashMap<String, FlexGlobalConfig> globalConfigs = new ConcurrentHashMap();
    private static FlexGlobalConfig defaultConfig = new FlexGlobalConfig();

    public DbType getDbType() {
        return this.dbType;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public void setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
    }

    public KeyConfig getKeyConfig() {
        return this.keyConfig;
    }

    public void setKeyConfig(KeyConfig keyConfig) {
        this.keyConfig = keyConfig;
    }

    public Map<Class<?>, SetListener> getEntitySetListeners() {
        return this.entitySetListeners;
    }

    public void setEntitySetListeners(Map<Class<?>, SetListener> entitySetListeners) {
        this.entitySetListeners = entitySetListeners;
    }

    public Map<Class<?>, UpdateListener> getEntityUpdateListeners() {
        return this.entityUpdateListeners;
    }

    public void setEntityUpdateListeners(Map<Class<?>, UpdateListener> entityUpdateListeners) {
        this.entityUpdateListeners = entityUpdateListeners;
    }

    public Map<Class<?>, InsertListener> getEntityInsertListeners() {
        return this.entityInsertListeners;
    }

    public void setEntityInsertListeners(Map<Class<?>, InsertListener> entityInsertListeners) {
        this.entityInsertListeners = entityInsertListeners;
    }

    public void registerSetListener(SetListener listener, Class<?> ... classes) {
        for (Class<?> aClass : classes) {
            this.entitySetListeners.put(aClass, listener);
        }
    }

    public void registerUpdateListener(UpdateListener listener, Class<?> ... classes) {
        for (Class<?> aClass : classes) {
            this.entityUpdateListeners.put(aClass, listener);
        }
    }

    public void registerInsertListener(InsertListener listener, Class<?> ... classes) {
        for (Class<?> aClass : classes) {
            this.entityInsertListeners.put(aClass, listener);
        }
    }

    public SetListener getSetListener(Class<?> entityClass) {
        return this.entitySetListeners.get(entityClass);
    }

    public UpdateListener getUpdateListener(Class<?> entityClass) {
        return this.entityUpdateListeners.get(entityClass);
    }

    public InsertListener getInsertListener(Class<?> entityClass) {
        return this.entityInsertListeners.get(entityClass);
    }

    public Object getNormalValueOfLogicDelete() {
        return this.normalValueOfLogicDelete;
    }

    public void setNormalValueOfLogicDelete(Object normalValueOfLogicDelete) {
        if (normalValueOfLogicDelete == null) {
            throw new NullPointerException("normalValueOfLogicDelete can not be null.");
        }
        this.normalValueOfLogicDelete = normalValueOfLogicDelete;
    }

    public Object getDeletedValueOfLogicDelete() {
        return this.deletedValueOfLogicDelete;
    }

    public void setDeletedValueOfLogicDelete(Object deletedValueOfLogicDelete) {
        if (deletedValueOfLogicDelete == null) {
            throw new NullPointerException("deletedValueOfLogicDelete can not be null.");
        }
        this.deletedValueOfLogicDelete = deletedValueOfLogicDelete;
    }

    public static ConcurrentHashMap<String, FlexGlobalConfig> getGlobalConfigs() {
        return globalConfigs;
    }

    public static void setGlobalConfigs(ConcurrentHashMap<String, FlexGlobalConfig> globalConfigs) {
        FlexGlobalConfig.globalConfigs = globalConfigs;
    }

    public static FlexGlobalConfig getDefaultConfig() {
        return defaultConfig;
    }

    public static FlexGlobalConfig getConfig(Configuration configuration) {
        return FlexGlobalConfig.getConfig(configuration.getEnvironment().getId());
    }

    public static FlexGlobalConfig getConfig(String environmentId) {
        return globalConfigs.get(environmentId);
    }

    public static synchronized void setConfig(String id, FlexGlobalConfig config) {
        if (globalConfigs.isEmpty()) {
            defaultConfig.setSqlSessionFactory(config.sqlSessionFactory);
            defaultConfig.setDbType(config.dbType);
            defaultConfig.setConfiguration(config.configuration);
            if (defaultConfig.getKeyConfig() == null && config.keyConfig != null) {
                defaultConfig.setKeyConfig(config.keyConfig);
            }
            config = defaultConfig;
        }
        globalConfigs.put(id, config);
    }

    public static class KeyConfig {
        private KeyType keyType;
        private String value;
        private boolean before = true;

        public KeyType getKeyType() {
            return this.keyType;
        }

        public void setKeyType(KeyType keyType) {
            this.keyType = keyType;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isBefore() {
            return this.before;
        }

        public void setBefore(boolean before) {
            this.before = before;
        }
    }
}

