/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core;

import com.mybatisflex.core.datasource.FlexDataSource;
import com.mybatisflex.core.mybatis.FlexConfiguration;
import com.mybatisflex.core.mybatis.FlexSqlSessionFactoryBuilder;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import javax.sql.DataSource;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.util.MapUtil;

public class MybatisFlexBootstrap {
    protected final AtomicBoolean started = new AtomicBoolean(false);
    protected String environmentId = "MyBatis-Flex";
    protected TransactionFactory transactionFactory;
    protected FlexDataSource dataSource;
    protected Configuration configuration;
    protected List<Class<?>> mappers;
    protected SqlSessionFactory sqlSessionFactory;
    protected Class<? extends Log> logImpl;
    private final Map<Class<?>, Object> mapperObjects = new ConcurrentHashMap();
    private static volatile MybatisFlexBootstrap instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MybatisFlexBootstrap getInstance() {
        if (instance != null) return instance;
        Class<MybatisFlexBootstrap> clazz = MybatisFlexBootstrap.class;
        synchronized (MybatisFlexBootstrap.class) {
            if (instance != null) return instance;
            instance = new MybatisFlexBootstrap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public <T> MybatisFlexBootstrap addMapper(Class<T> type) {
        if (this.mappers == null) {
            this.mappers = new ArrayList();
        }
        this.mappers.add(type);
        return this;
    }

    public MybatisFlexBootstrap start() {
        if (this.started.compareAndSet(false, true)) {
            if (this.dataSource == null) {
                throw new IllegalStateException("dataSource can not be null.");
            }
            if (this.configuration == null) {
                if (this.transactionFactory == null) {
                    this.transactionFactory = new JdbcTransactionFactory();
                }
                Environment environment = new Environment(this.environmentId, this.transactionFactory, (DataSource)this.dataSource);
                this.configuration = new FlexConfiguration(environment);
            }
            if (this.logImpl != null) {
                this.configuration.setLogImpl(this.logImpl);
            }
            this.sqlSessionFactory = new FlexSqlSessionFactoryBuilder().build(this.configuration);
            if (this.mappers != null) {
                this.mappers.forEach(arg_0 -> ((Configuration)this.configuration).addMapper(arg_0));
            }
            LogFactory.getLog(MybatisFlexBootstrap.class).debug("Mybatis-Flex has started.");
        }
        return this;
    }

    @Deprecated
    public <R, T> R execute(Class<T> mapperClass, Function<T, R> function) {
        try (SqlSession sqlSession = this.openSession();){
            Object mapper = sqlSession.getMapper(mapperClass);
            R r = function.apply(mapper);
            return r;
        }
    }

    protected SqlSession openSession() {
        return this.sqlSessionFactory.openSession(this.configuration.getDefaultExecutorType(), true);
    }

    public <T> T getMapper(Class<T> mapperClass) {
        Object mapperObject = MapUtil.computeIfAbsent(this.mapperObjects, mapperClass, clazz -> Proxy.newProxyInstance(mapperClass.getClassLoader(), new Class[]{mapperClass}, (proxy, method, args) -> {
            try (SqlSession sqlSession = this.openSession();){
                Object mapper1 = sqlSession.getMapper(mapperClass);
                Object object = method.invoke(mapper1, args);
                return object;
            }
        }));
        return (T)mapperObject;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public MybatisFlexBootstrap setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    public TransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    public MybatisFlexBootstrap setTransactionFactory(TransactionFactory transactionFactory) {
        this.transactionFactory = transactionFactory;
        return this;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public MybatisFlexBootstrap setDataSource(DataSource dataSource) {
        this.dataSource = new FlexDataSource("MyBatis-Flex", dataSource);
        return this;
    }

    public MybatisFlexBootstrap setDataSource(String dataSourceKey, DataSource dataSource) {
        this.dataSource = new FlexDataSource(dataSourceKey, dataSource);
        return this;
    }

    public MybatisFlexBootstrap addDataSource(String dataSourceKey, DataSource dataSource) {
        if (this.dataSource == null) {
            this.dataSource = new FlexDataSource(dataSourceKey, dataSource);
        } else {
            this.dataSource.addDataSource(dataSourceKey, dataSource);
        }
        return this;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public MybatisFlexBootstrap setConfiguration(FlexConfiguration configuration) {
        this.configuration = configuration;
        this.environmentId = configuration.getEnvironment().getId();
        return this;
    }

    public List<Class<?>> getMappers() {
        return this.mappers;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    public MybatisFlexBootstrap setSqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
        return this;
    }

    public Class<? extends Log> getLogImpl() {
        return this.logImpl;
    }

    public MybatisFlexBootstrap setLogImpl(Class<? extends Log> logImpl) {
        this.logImpl = logImpl;
        return this;
    }
}

