/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.audit;

import com.mybatisflex.core.audit.AuditMessage;
import com.mybatisflex.core.audit.MessageCollector;

public class ConsoleMessageCollector
implements MessageCollector {
    private SqlDebugPrinter printer = (sql, takedTimeMillis) -> {
        if (takedTimeMillis != null) {
            System.out.println("Flex exec sql taked " + takedTimeMillis + " ms >>>  " + sql);
        } else {
            System.out.println("Flex exec sql >>>  " + sql);
        }
    };

    public ConsoleMessageCollector() {
    }

    public ConsoleMessageCollector(SqlDebugPrinter printer) {
        this.printer = printer;
    }

    @Override
    public void collect(AuditMessage message) {
        this.printer.print(message.getFullSql(), message.getElapsedTime());
    }

    public static interface SqlDebugPrinter {
        public void print(String var1, Long var2);
    }
}

