/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.keygen;

import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.keygen.CustomKeyGenerator;
import com.mybatisflex.core.keygen.MultiPrimaryKeyGenerator;
import com.mybatisflex.core.table.IdInfo;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.executor.keygen.NoKeyGenerator;
import org.apache.ibatis.executor.keygen.SelectKeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.mapping.StatementType;
import org.apache.ibatis.session.Configuration;

public class MybatisKeyGeneratorUtil {
    public static KeyGenerator createTableKeyGenerator(TableInfo tableInfo, MappedStatement ms) {
        List<IdInfo> primaryKeyList = tableInfo.getPrimaryKeyList();
        if (primaryKeyList == null || primaryKeyList.isEmpty()) {
            return NoKeyGenerator.INSTANCE;
        }
        if (primaryKeyList.size() > 1) {
            return new MultiPrimaryKeyGenerator(ms, tableInfo, primaryKeyList);
        }
        return MybatisKeyGeneratorUtil.createIdKeyGenerator(tableInfo, ms, primaryKeyList.get(0));
    }

    public static KeyGenerator createIdKeyGenerator(TableInfo tableInfo, MappedStatement ms, IdInfo idInfo) {
        FlexGlobalConfig.KeyConfig globalKeyConfig = FlexGlobalConfig.getConfig(ms.getConfiguration()).getKeyConfig();
        KeyType keyType = MybatisKeyGeneratorUtil.getKeyType(idInfo, globalKeyConfig);
        if (keyType == KeyType.None) {
            return NoKeyGenerator.INSTANCE;
        }
        if (keyType == KeyType.Auto) {
            return Jdbc3KeyGenerator.INSTANCE;
        }
        if (keyType == KeyType.Generator) {
            return new CustomKeyGenerator(ms.getConfiguration(), tableInfo, idInfo);
        }
        String sequence = MybatisKeyGeneratorUtil.getKeyValue(idInfo, globalKeyConfig);
        if (StringUtil.isBlank(sequence)) {
            throw FlexExceptions.wrap("please config @Id(value=\"...\") for field: %s in class: %s", idInfo.getProperty(), tableInfo.getEntityClass().getName());
        }
        String selectId = ms.getId() + "!selectKey";
        SqlSource sqlSource = ms.getLang().createSqlSource(ms.getConfiguration(), sequence.trim(), idInfo.getPropertyType());
        MappedStatement.Builder msBuilder = new MappedStatement.Builder(ms.getConfiguration(), selectId, sqlSource, SqlCommandType.SELECT).resource(ms.getResource()).fetchSize(null).timeout(null).statementType(StatementType.PREPARED).keyGenerator((KeyGenerator)NoKeyGenerator.INSTANCE).keyProperty("$$entity." + idInfo.getProperty()).keyColumn(idInfo.getColumn()).databaseId(ms.getDatabaseId()).lang(ms.getLang()).resultOrdered(false).resultSets(null).resultMaps(MybatisKeyGeneratorUtil.createIdResultMaps(ms.getConfiguration(), selectId + "-Inline", idInfo.getPropertyType(), new ArrayList<ResultMapping>())).resultSetType(null).flushCacheRequired(false).useCache(false).cache(ms.getCache());
        MappedStatement keyMappedStatement = msBuilder.build();
        ms.getConfiguration().addMappedStatement(keyMappedStatement);
        return new SelectKeyGenerator(keyMappedStatement, MybatisKeyGeneratorUtil.isKeyBefore(idInfo, globalKeyConfig));
    }

    private static List<ResultMap> createIdResultMaps(Configuration configuration, String statementId, Class<?> resultType, List<ResultMapping> resultMappings) {
        ResultMap resultMap = new ResultMap.Builder(configuration, statementId, resultType, resultMappings, null).build();
        return Arrays.asList(resultMap);
    }

    public static KeyType getKeyType(IdInfo idInfo, FlexGlobalConfig.KeyConfig globalKeyConfig) {
        KeyType keyType = idInfo.getKeyType();
        if (keyType != KeyType.None) {
            return keyType;
        }
        if (globalKeyConfig != null) {
            return globalKeyConfig.getKeyType();
        }
        return keyType;
    }

    public static String getKeyValue(IdInfo idInfo, FlexGlobalConfig.KeyConfig globalKeyConfig) {
        String value = idInfo.getValue();
        if (StringUtil.isBlank(value) && globalKeyConfig != null) {
            value = globalKeyConfig.getValue();
        }
        return value;
    }

    public static boolean isKeyBefore(IdInfo idInfo, FlexGlobalConfig.KeyConfig globalKeyConfig) {
        Boolean before = idInfo.getBefore();
        if (before == null && globalKeyConfig != null) {
            return globalKeyConfig.isBefore();
        }
        return before == null || before != false;
    }
}

