/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.util.StringUtil;
import java.util.List;

public class OperatorSelectCondition
extends QueryCondition {
    private String operator;
    private QueryWrapper queryWrapper;

    public OperatorSelectCondition(String operator, QueryWrapper queryWrapper) {
        this.operator = operator;
        this.queryWrapper = queryWrapper;
    }

    @Override
    public String toSql(List<QueryTable> queryTables, IDialect dialect) {
        String childSql;
        StringBuilder sql = new StringBuilder();
        if (this.checkEffective() && StringUtil.isNotBlank(childSql = dialect.buildSelectSql(this.queryWrapper))) {
            QueryCondition effectiveBefore = this.getEffectiveBefore();
            if (effectiveBefore != null) {
                sql.append((Object)effectiveBefore.connector);
            }
            sql.append(this.operator).append("(").append(childSql).append(")");
        }
        if (this.next != null) {
            return sql + this.next.toSql(queryTables, dialect);
        }
        return sql.toString();
    }

    @Override
    public Object getValue() {
        return this.queryWrapper.getValueArray();
    }
}

