/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.row;

import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.ConvertUtil;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.util.MapUtil;

public class RowUtil {
    private static final Map<Class<?>, Map<String, Method>> classGettersMapping = new ConcurrentHashMap();

    public static <T> T toObject(Row row, Class<T> objectClass) {
        Object instance = ClassUtil.newInstance(objectClass);
        Map<String, Method> setterMethods = RowUtil.getSetterMethods(objectClass);
        row.forEach((column, columnValue) -> {
            Method setter = (Method)setterMethods.get(column.toLowerCase());
            try {
                if (setter != null) {
                    Object value = ConvertUtil.convert(columnValue, setter.getParameterTypes()[0]);
                    setter.invoke(instance, value);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Can not invoke method: " + setter);
            }
        });
        return instance;
    }

    public static <T> List<T> toObjectList(List<Row> rows, Class<T> objectClass) {
        if (rows == null || rows.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> objectList = new ArrayList<T>();
        for (Row row : rows) {
            objectList.add(RowUtil.toObject(row, objectClass));
        }
        return objectList;
    }

    public static <T> T toEntity(Row row, Class<T> entityClass) {
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(entityClass);
        return tableInfo.newInstanceByRow(row);
    }

    public static <T> List<T> toEntityList(List<Row> rows, Class<T> entityClass) {
        if (rows == null || rows.isEmpty()) {
            return Collections.emptyList();
        }
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(entityClass);
        ArrayList entityList = new ArrayList();
        for (Row row : rows) {
            Object entity = tableInfo.newInstanceByRow(row);
            entityList.add(entity);
        }
        return entityList;
    }

    public static void registerMapping(Class<?> clazz, Map<String, Method> columnSetterMapping) {
        classGettersMapping.put(clazz, columnSetterMapping);
    }

    private static Map<String, Method> getSetterMethods(Class<?> aClass) {
        return (Map)MapUtil.computeIfAbsent(classGettersMapping, aClass, aClass1 -> {
            HashMap<String, Method> columnSetterMapping = new HashMap<String, Method>();
            List<Method> setters = ClassUtil.getAllMethods(aClass1, method -> method.getName().startsWith("set") && method.getParameterCount() == 1 && Modifier.isPublic(method.getModifiers()));
            for (Method setter : setters) {
                String column = setter.getName().substring(3);
                columnSetterMapping.put(column.toLowerCase(), setter);
                columnSetterMapping.put(StringUtil.camelToUnderline(column).toLowerCase(), setter);
                columnSetterMapping.put(StringUtil.underlineToCamel(column).toUpperCase(), setter);
            }
            return columnSetterMapping;
        });
    }
}

