/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.table;

import com.mybatisflex.annotation.InsertListener;
import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.annotation.SetListener;
import com.mybatisflex.annotation.UpdateListener;
import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.javassist.ModifyAttrsRecord;
import com.mybatisflex.core.mybatis.TypeHandlerObject;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.UnionWrapper;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.table.BaseReflectorFactory;
import com.mybatisflex.core.table.ColumnInfo;
import com.mybatisflex.core.table.EntityMetaObject;
import com.mybatisflex.core.table.IdInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.tenant.TenantManager;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.ConvertUtil;
import com.mybatisflex.core.util.ObjectUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.Reflector;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandler;

public class TableInfo {
    private String schema;
    private String tableName;
    private Class<?> entityClass;
    private boolean camelToUnderline = true;
    private String dataSource;
    private String logicDeleteColumn;
    private String versionColumn;
    private String tenantIdColumn;
    private Map<String, String> onInsertColumns;
    private Map<String, String> onUpdateColumns;
    private String[] largeColumns = new String[0];
    private String[] columns = new String[0];
    private String[] primaryKeys = new String[0];
    private String[] insertPrimaryKeys;
    private List<ColumnInfo> columnInfoList;
    private List<IdInfo> primaryKeyList;
    private Map<String, ColumnInfo> columnInfoMapping = new HashMap<String, ColumnInfo>();
    private Map<String, String> propertyColumnMapping = new HashMap<String, String>();
    private InsertListener onInsertListener;
    private UpdateListener onUpdateListener;
    private SetListener onSetListener;
    private final ReflectorFactory reflectorFactory = new BaseReflectorFactory(){

        public Reflector findForClass(Class<?> type) {
            return TableInfo.this.getReflector();
        }
    };
    private Reflector reflector;
    private static final String APPEND_CONDITIONS_FLAG = "appendConditions";

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public boolean isCamelToUnderline() {
        return this.camelToUnderline;
    }

    public void setCamelToUnderline(boolean camelToUnderline) {
        this.camelToUnderline = camelToUnderline;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public String getLogicDeleteColumn() {
        return this.logicDeleteColumn;
    }

    public void setLogicDeleteColumn(String logicDeleteColumn) {
        this.logicDeleteColumn = logicDeleteColumn;
    }

    public String getVersionColumn() {
        return this.versionColumn;
    }

    public void setVersionColumn(String versionColumn) {
        this.versionColumn = versionColumn;
    }

    public String getTenantIdColumn() {
        return this.tenantIdColumn;
    }

    public void setTenantIdColumn(String tenantIdColumn) {
        this.tenantIdColumn = tenantIdColumn;
    }

    public Map<String, String> getOnInsertColumns() {
        return this.onInsertColumns;
    }

    public void setOnInsertColumns(Map<String, String> onInsertColumns) {
        this.onInsertColumns = onInsertColumns;
    }

    public Map<String, String> getOnUpdateColumns() {
        return this.onUpdateColumns;
    }

    public void setOnUpdateColumns(Map<String, String> onUpdateColumns) {
        this.onUpdateColumns = onUpdateColumns;
    }

    public String[] getLargeColumns() {
        return this.largeColumns;
    }

    public void setLargeColumns(String[] largeColumns) {
        this.largeColumns = largeColumns;
    }

    public String[] getInsertPrimaryKeys() {
        return this.insertPrimaryKeys;
    }

    public void setInsertPrimaryKeys(String[] insertPrimaryKeys) {
        this.insertPrimaryKeys = insertPrimaryKeys;
    }

    public Reflector getReflector() {
        return this.reflector;
    }

    public ReflectorFactory getReflectorFactory() {
        return this.reflectorFactory;
    }

    public void setReflector(Reflector reflector) {
        this.reflector = reflector;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
    }

    public String[] getPrimaryKeys() {
        return this.primaryKeys;
    }

    public void setPrimaryKeys(String[] primaryKeys) {
        this.primaryKeys = primaryKeys;
    }

    public InsertListener getOnInsertListener() {
        return this.onInsertListener;
    }

    public void setOnInsertListener(InsertListener onInsertListener) {
        this.onInsertListener = onInsertListener;
    }

    public UpdateListener getOnUpdateListener() {
        return this.onUpdateListener;
    }

    public void setOnUpdateListener(UpdateListener onUpdateListener) {
        this.onUpdateListener = onUpdateListener;
    }

    public SetListener getOnSetListener() {
        return this.onSetListener;
    }

    public void setOnSetListener(SetListener onSetListener) {
        this.onSetListener = onSetListener;
    }

    public List<ColumnInfo> getColumnInfoList() {
        return this.columnInfoList;
    }

    void setColumnInfoList(List<ColumnInfo> columnInfoList) {
        this.columnInfoList = columnInfoList;
        this.columns = new String[columnInfoList.size()];
        for (int i = 0; i < columnInfoList.size(); ++i) {
            ColumnInfo columnInfo = columnInfoList.get(i);
            this.columns[i] = columnInfo.getColumn();
            this.columnInfoMapping.put(columnInfo.column, columnInfo);
            this.propertyColumnMapping.put(columnInfo.property, columnInfo.column);
        }
    }

    public List<IdInfo> getPrimaryKeyList() {
        return this.primaryKeyList;
    }

    void setPrimaryKeyList(List<IdInfo> primaryKeyList) {
        this.primaryKeyList = primaryKeyList;
        this.primaryKeys = new String[primaryKeyList.size()];
        ArrayList<String> insertIdFields = new ArrayList<String>();
        for (int i = 0; i < primaryKeyList.size(); ++i) {
            IdInfo idInfo = primaryKeyList.get(i);
            this.primaryKeys[i] = idInfo.getColumn();
            if (idInfo.getKeyType() != KeyType.Auto && idInfo.getBefore() != null && idInfo.getBefore().booleanValue()) {
                insertIdFields.add(idInfo.getColumn());
            }
            this.columnInfoMapping.put(idInfo.column, idInfo);
            this.propertyColumnMapping.put(idInfo.property, idInfo.column);
        }
        this.insertPrimaryKeys = insertIdFields.toArray(new String[0]);
    }

    public String[] obtainInsertColumns() {
        return ArrayUtil.concat(this.insertPrimaryKeys, this.columns);
    }

    public Object[] buildInsertSqlArgs(Object entity) {
        MetaObject metaObject = EntityMetaObject.forObject(entity, this.reflectorFactory);
        String[] insertColumns = this.obtainInsertColumns();
        ArrayList<Object> values = new ArrayList<Object>(insertColumns.length);
        for (String insertColumn : insertColumns) {
            if (this.onInsertColumns != null && this.onInsertColumns.containsKey(insertColumn)) continue;
            Object value = this.buildColumnSqlArg(metaObject, insertColumn);
            values.add(value);
        }
        return values.toArray();
    }

    public Set<String> obtainUpdateColumns(Object entity, boolean ignoreNulls, boolean includePrimary) {
        MetaObject metaObject = EntityMetaObject.forObject(entity, this.reflectorFactory);
        LinkedHashSet<String> columns = new LinkedHashSet<String>();
        if (entity instanceof ModifyAttrsRecord) {
            Set<String> properties = ((ModifyAttrsRecord)entity).obtainModifyAttrs();
            if (properties.isEmpty()) {
                return Collections.emptySet();
            }
            for (String property : properties) {
                String column = this.propertyColumnMapping.get(property);
                if (this.onUpdateColumns != null && this.onUpdateColumns.containsKey(column) || ObjectUtil.equalsAny(column, this.versionColumn, this.tenantIdColumn) || !includePrimary && ArrayUtil.contains(this.primaryKeys, column)) continue;
                columns.add(column);
            }
        } else {
            for (String column : this.columns) {
                if (this.onUpdateColumns != null && this.onUpdateColumns.containsKey(column) || ObjectUtil.equalsAny(column, this.versionColumn, this.tenantIdColumn)) continue;
                Object value = this.buildColumnSqlArg(metaObject, column);
                if (ignoreNulls && value == null) continue;
                columns.add(column);
            }
        }
        return columns;
    }

    public Object[] buildUpdateSqlArgs(Object entity, boolean ignoreNulls, boolean includePrimary) {
        MetaObject metaObject = EntityMetaObject.forObject(entity, this.reflectorFactory);
        ArrayList<Object> values = new ArrayList<Object>();
        if (entity instanceof ModifyAttrsRecord) {
            Set<String> properties = ((ModifyAttrsRecord)entity).obtainModifyAttrs();
            if (properties.isEmpty()) {
                return values.toArray();
            }
            for (String property : properties) {
                String column = this.propertyColumnMapping.get(property);
                if (this.onUpdateColumns != null && this.onUpdateColumns.containsKey(column) || ObjectUtil.equalsAny(column, this.versionColumn, this.tenantIdColumn) || !includePrimary && ArrayUtil.contains(this.primaryKeys, column)) continue;
                Object value = this.getPropertyValue(metaObject, property);
                values.add(value);
            }
        } else {
            for (String column : this.columns) {
                if (this.onUpdateColumns != null && this.onUpdateColumns.containsKey(column) || ObjectUtil.equalsAny(column, this.versionColumn, this.tenantIdColumn)) continue;
                Object value = this.buildColumnSqlArg(metaObject, column);
                if (ignoreNulls && value == null) continue;
                values.add(value);
            }
        }
        return values.toArray();
    }

    public Object[] buildPkSqlArgs(Object entity) {
        MetaObject metaObject = EntityMetaObject.forObject(entity, this.reflectorFactory);
        Object[] values = new Object[this.primaryKeys.length];
        for (int i = 0; i < this.primaryKeys.length; ++i) {
            values[i] = this.buildColumnSqlArg(metaObject, this.primaryKeys[i]);
        }
        return values;
    }

    public Object[] buildTenantIdArgs() {
        if (StringUtil.isBlank(this.tenantIdColumn)) {
            return null;
        }
        return TenantManager.getTenantIds();
    }

    public void appendConditions(Object entity, QueryWrapper queryWrapper) {
        List<UnionWrapper> unions;
        List<QueryWrapper> childSelects;
        Object[] tenantIdArgs;
        Object appendConditions = CPI.getContext(queryWrapper, APPEND_CONDITIONS_FLAG);
        if (Boolean.TRUE.equals(appendConditions)) {
            return;
        }
        CPI.putContext(queryWrapper, APPEND_CONDITIONS_FLAG, Boolean.TRUE);
        if (StringUtil.isNotBlank(this.versionColumn) && entity != null) {
            Object versionValue = this.buildColumnSqlArg(entity, this.versionColumn);
            if (versionValue == null) {
                throw FlexExceptions.wrap("The version value of entity[%s] must not be null.", entity);
            }
            queryWrapper.and(QueryCondition.create(this.tableName, this.versionColumn, "=", versionValue));
        }
        if (StringUtil.isNotBlank(this.logicDeleteColumn)) {
            queryWrapper.and(QueryCondition.create(this.tableName, this.logicDeleteColumn, "=", FlexGlobalConfig.getDefaultConfig().getNormalValueOfLogicDelete()));
        }
        if (ArrayUtil.isNotEmpty(tenantIdArgs = this.buildTenantIdArgs())) {
            if (tenantIdArgs.length == 1) {
                queryWrapper.and(QueryCondition.create(this.tableName, this.tenantIdColumn, "=", tenantIdArgs[0]));
            } else {
                queryWrapper.and(QueryCondition.create(this.tableName, this.tenantIdColumn, "IN", tenantIdArgs));
            }
        }
        if (CollectionUtil.isNotEmpty(childSelects = CPI.getChildSelect(queryWrapper))) {
            for (QueryWrapper childQueryWrapper : childSelects) {
                List<QueryTable> queryTables = CPI.getQueryTables(childQueryWrapper);
                for (QueryTable queryTable : queryTables) {
                    TableInfo tableInfo = TableInfoFactory.ofTableName(queryTable.getName());
                    if (tableInfo == null) continue;
                    tableInfo.appendConditions(entity, childQueryWrapper);
                }
            }
        }
        if (CollectionUtil.isNotEmpty(unions = CPI.getUnions(queryWrapper))) {
            for (UnionWrapper union : unions) {
                QueryWrapper unionQueryWrapper = union.getQueryWrapper();
                List<QueryTable> queryTables = CPI.getQueryTables(unionQueryWrapper);
                for (QueryTable queryTable : queryTables) {
                    TableInfo tableInfo = TableInfoFactory.ofTableName(queryTable.getName());
                    if (tableInfo == null) continue;
                    tableInfo.appendConditions(entity, unionQueryWrapper);
                }
            }
        }
    }

    public String getKeyProperties() {
        StringJoiner joiner = new StringJoiner(",");
        for (IdInfo value : this.primaryKeyList) {
            joiner.add("$$entity." + value.getProperty());
        }
        return joiner.toString();
    }

    public String getKeyColumns() {
        StringJoiner joiner = new StringJoiner(",");
        for (IdInfo value : this.primaryKeyList) {
            joiner.add(value.getColumn());
        }
        return joiner.toString();
    }

    public ResultMap buildResultMap(Configuration configuration) {
        ResultMapping mapping;
        String resultMapId = this.entityClass.getName();
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        for (ColumnInfo columnInfo : this.columnInfoList) {
            mapping = new ResultMapping.Builder(configuration, columnInfo.getProperty(), columnInfo.getColumn(), columnInfo.getPropertyType()).jdbcType(columnInfo.getJdbcType()).typeHandler(columnInfo.buildTypeHandler()).build();
            resultMappings.add(mapping);
        }
        for (IdInfo idInfo : this.primaryKeyList) {
            mapping = new ResultMapping.Builder(configuration, idInfo.getProperty(), idInfo.getColumn(), idInfo.getPropertyType()).flags(CollectionUtil.newArrayList(ResultFlag.ID)).jdbcType(idInfo.getJdbcType()).typeHandler(idInfo.buildTypeHandler()).build();
            resultMappings.add(mapping);
        }
        return new ResultMap.Builder(configuration, resultMapId, this.entityClass, resultMappings).build();
    }

    private Object buildColumnSqlArg(MetaObject metaObject, String column) {
        ColumnInfo columnInfo = this.columnInfoMapping.get(column);
        Object value = this.getPropertyValue(metaObject, columnInfo.property);
        TypeHandler typeHandler = columnInfo.buildTypeHandler();
        if (value != null && typeHandler != null) {
            return new TypeHandlerObject(typeHandler, value, columnInfo.getJdbcType());
        }
        return value;
    }

    public Object buildColumnSqlArg(Object entityObject, String column) {
        MetaObject metaObject = EntityMetaObject.forObject(entityObject, this.reflectorFactory);
        return this.buildColumnSqlArg(metaObject, column);
    }

    private Object getPropertyValue(MetaObject metaObject, String property) {
        if (property != null && metaObject.hasGetter(property)) {
            return metaObject.getValue(property);
        }
        return null;
    }

    public <T> T newInstanceByRow(Row row) {
        Object instance = ClassUtil.newInstance(this.entityClass);
        MetaObject metaObject = EntityMetaObject.forObject(instance, this.reflectorFactory);
        for (String column : row.keySet()) {
            ColumnInfo columnInfo = this.columnInfoMapping.get(column);
            if (columnInfo == null || !metaObject.hasSetter(columnInfo.property)) continue;
            Object value = ConvertUtil.convert(row.get(column), metaObject.getSetterType(columnInfo.property));
            if (this.onSetListener != null) {
                value = this.onSetListener.onSet(instance, columnInfo.property, value);
            }
            metaObject.setValue(columnInfo.property, value);
        }
        return (T)instance;
    }

    public void initVersionValueIfNecessary(Object entityObject) {
        if (StringUtil.isBlank(this.versionColumn)) {
            return;
        }
        MetaObject metaObject = EntityMetaObject.forObject(entityObject, this.reflectorFactory);
        Object columnValue = this.getPropertyValue(metaObject, this.columnInfoMapping.get((Object)this.versionColumn).property);
        if (columnValue == null) {
            String name = this.columnInfoMapping.get((Object)this.versionColumn).property;
            Class clazz = metaObject.getSetterType(name);
            metaObject.setValue(name, ConvertUtil.convert(0L, clazz));
        }
    }

    public void initTenantIdIfNecessary(Object entityObject) {
        if (StringUtil.isBlank(this.tenantIdColumn)) {
            return;
        }
        MetaObject metaObject = EntityMetaObject.forObject(entityObject, this.reflectorFactory);
        Object[] tenantIds = TenantManager.getTenantIds();
        if (tenantIds == null || tenantIds.length == 0) {
            return;
        }
        Object tenantId = tenantIds[0];
        if (tenantId != null) {
            metaObject.setValue(this.columnInfoMapping.get((Object)this.tenantIdColumn).property, tenantId);
        }
    }

    public void initLogicDeleteValueIfNecessary(Object entityObject) {
        if (StringUtil.isBlank(this.logicDeleteColumn)) {
            return;
        }
        MetaObject metaObject = EntityMetaObject.forObject(entityObject, this.reflectorFactory);
        Object columnValue = this.getPropertyValue(metaObject, this.columnInfoMapping.get((Object)this.logicDeleteColumn).property);
        if (columnValue == null) {
            String name = this.columnInfoMapping.get((Object)this.logicDeleteColumn).property;
            Class clazz = metaObject.getSetterType(name);
            if (Number.class.isAssignableFrom(clazz)) {
                metaObject.setValue(name, ConvertUtil.convert(0L, clazz));
            } else if (clazz == Boolean.class) {
                metaObject.setValue(name, (Object)false);
            }
        }
    }

    public void invokeOnInsertListener(Object entity) {
        if (this.onInsertListener != null) {
            this.onInsertListener.onInsert(entity);
            return;
        }
        InsertListener globalInsertListener = FlexGlobalConfig.getDefaultConfig().getInsertListener(this.entityClass);
        if (globalInsertListener != null) {
            globalInsertListener.onInsert(entity);
        }
    }

    public void invokeOnUpdateListener(Object entity) {
        if (this.onUpdateListener != null) {
            this.onUpdateListener.onUpdate(entity);
            return;
        }
        UpdateListener globalUpdateListener = FlexGlobalConfig.getDefaultConfig().getUpdateListener(this.entityClass);
        if (globalUpdateListener != null) {
            globalUpdateListener.onUpdate(entity);
        }
    }

    public Object invokeOnSetListener(Object entity, String property, Object value) {
        if (this.onSetListener != null) {
            return this.onSetListener.onSet(entity, property, value);
        }
        SetListener globalSetListener = FlexGlobalConfig.getDefaultConfig().getSetListener(this.entityClass);
        if (globalSetListener != null) {
            return globalSetListener.onSet(entity, property, value);
        }
        return value;
    }
}

