/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.audit;

import com.mybatisflex.core.mybatis.TypeHandlerObject;
import com.mybatisflex.core.util.DateUtil;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Proxy;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

public class AuditMessage
implements Serializable {
    private String platform;
    private String module;
    private String url;
    private String bizId;
    private String user;
    private String userIp;
    private String hostIp;
    private String query;
    private List<Object> queryParams;
    private int queryCount;
    private long queryTime;
    private long elapsedTime;
    private Map<String, Object> metas;

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getBizId() {
        return this.bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public void setUserIp(String userIp) {
        this.userIp = userIp;
    }

    public String getHostIp() {
        return this.hostIp;
    }

    public void setHostIp(String hostIp) {
        this.hostIp = hostIp;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public List<Object> getQueryParams() {
        return this.queryParams;
    }

    public void setQueryParams(List<Object> queryParams) {
        this.queryParams = queryParams;
    }

    public void addParams(Object ... objects) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<Object>();
        }
        for (Object object : objects) {
            if (object != null && (object.getClass().isArray() || object.getClass() == int[].class || object.getClass() == long[].class || object.getClass() == short[].class || object.getClass() == float[].class || object.getClass() == double[].class)) {
                for (int i = 0; i < Array.getLength(object); ++i) {
                    this.addParams(Array.get(object, i));
                }
                continue;
            }
            if (object instanceof TypeHandlerObject) {
                try {
                    ((TypeHandlerObject)object).setParameter(this.createPreparedStatement(), 0);
                }
                catch (SQLException sQLException) {}
                continue;
            }
            this.queryParams.add(object);
        }
    }

    public String getFullSql() {
        String sql = this.getQuery();
        List<Object> params = this.getQueryParams();
        if (params != null) {
            for (Object value : params) {
                if (value == null) {
                    sql = sql.replaceFirst("\\?", "null");
                    continue;
                }
                if (value instanceof Number || value instanceof Boolean) {
                    sql = sql.replaceFirst("\\?", value.toString());
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                sb.append("'");
                if (value instanceof Date) {
                    sb.append(DateUtil.toDateTimeString((Date)value));
                } else if (value instanceof LocalDateTime) {
                    sb.append(DateUtil.toDateTimeString(DateUtil.toDate((LocalDateTime)value)));
                } else {
                    sb.append(value);
                }
                sb.append("'");
                sql = sql.replaceFirst("\\?", Matcher.quoteReplacement(sb.toString()));
            }
        }
        return sql;
    }

    private PreparedStatement createPreparedStatement() {
        return (PreparedStatement)Proxy.newProxyInstance(AuditMessage.class.getClassLoader(), new Class[]{PreparedStatement.class}, (proxy, method, args) -> {
            if (args != null && args.length == 2) {
                this.addParams(args[1]);
            }
            return null;
        });
    }

    public int getQueryCount() {
        return this.queryCount;
    }

    public void setQueryCount(int queryCount) {
        this.queryCount = queryCount;
    }

    public long getQueryTime() {
        return this.queryTime;
    }

    public void setQueryTime(long queryTime) {
        this.queryTime = queryTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(long elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public Map<String, Object> getMetas() {
        return this.metas;
    }

    public void setMetas(Map<String, Object> metas) {
        this.metas = metas;
    }

    public void addMeta(String key, Object value) {
        if (this.metas == null) {
            this.metas = new HashMap<String, Object>();
        }
        this.metas.put(key, value);
    }

    public String toString() {
        return "AuditMessage{platform='" + this.platform + '\'' + ", module='" + this.module + '\'' + ", url='" + this.url + '\'' + ", bizId='" + this.bizId + '\'' + ", user='" + this.user + '\'' + ", userIp='" + this.userIp + '\'' + ", hostIp='" + this.hostIp + '\'' + ", query='" + this.query + '\'' + ", queryParams=" + this.queryParams + ", queryCount=" + this.queryCount + ", queryTime=" + this.queryTime + ", elapsedTime=" + this.elapsedTime + ", metas=" + this.metas + '}';
    }
}

