/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.dialect;

import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.dialect.KeywordWrap;
import com.mybatisflex.core.dialect.LimitOffsetProcesser;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.Join;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryOrderBy;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.UnionWrapper;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.row.RowCPI;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;

public class CommonsDialectImpl
implements IDialect {
    protected KeywordWrap keywordWrap = KeywordWrap.BACKQUOTE;
    private LimitOffsetProcesser limitOffsetProcesser = LimitOffsetProcesser.MYSQL;

    public CommonsDialectImpl() {
    }

    public CommonsDialectImpl(LimitOffsetProcesser limitOffsetProcesser) {
        this.limitOffsetProcesser = limitOffsetProcesser;
    }

    public CommonsDialectImpl(KeywordWrap keywordWrap, LimitOffsetProcesser limitOffsetProcesser) {
        this.keywordWrap = keywordWrap;
        this.limitOffsetProcesser = limitOffsetProcesser;
    }

    @Override
    public String wrap(String keyword) {
        return this.keywordWrap.wrap(keyword);
    }

    @Override
    public String forInsertRow(String tableName, Row row) {
        StringBuilder fields = new StringBuilder();
        StringBuilder questions = new StringBuilder();
        Set<String> attrs = row.obtainModifyAttrs();
        int index = 0;
        for (String attr : attrs) {
            fields.append(this.wrap(attr));
            questions.append("?");
            if (index != attrs.size() - 1) {
                fields.append(", ");
                questions.append(", ");
            }
            ++index;
        }
        String sql = "INSERT INTO " + this.wrap(tableName) + "(" + fields + ")  VALUES (" + questions + ")";
        return sql;
    }

    @Override
    public String forInsertBatchWithFirstRowColumns(String tableName, List<Row> rows) {
        StringBuilder fields = new StringBuilder();
        StringBuilder questions = new StringBuilder();
        Row firstRow = rows.get(0);
        Set<String> attrs = firstRow.obtainModifyAttrs();
        int index = 0;
        for (String attr : attrs) {
            fields.append(this.wrap(attr));
            if (index != attrs.size() - 1) {
                fields.append(", ");
            }
            ++index;
        }
        for (int i = 0; i < rows.size(); ++i) {
            questions.append(this.buildQuestion(attrs.size(), true));
            if (i == rows.size() - 1) continue;
            questions.append(",");
        }
        String sql = "INSERT INTO " + this.wrap(tableName) + "(" + fields + ")  VALUES " + questions;
        return sql;
    }

    @Override
    public String forDeleteById(String tableName, String[] primaryKeys) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ");
        sql.append(this.wrap(tableName));
        sql.append(" WHERE ");
        for (int i = 0; i < primaryKeys.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(this.wrap(primaryKeys[i])).append(" = ?");
        }
        return sql.toString();
    }

    @Override
    public String forDeleteBatchByIds(String tableName, String[] primaryKeys, Object[] ids) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ");
        sql.append(this.wrap(tableName));
        sql.append(" WHERE ");
        if (primaryKeys.length > 1) {
            for (int i = 0; i < ids.length / primaryKeys.length; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append("(");
                for (int j = 0; j < primaryKeys.length; ++j) {
                    if (j > 0) {
                        sql.append(" AND ");
                    }
                    sql.append(this.wrap(primaryKeys[j])).append(" = ?");
                }
                sql.append(")");
            }
        } else {
            for (int i = 0; i < ids.length; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append(this.wrap(primaryKeys[0])).append(" = ?");
            }
        }
        return sql.toString();
    }

    @Override
    public String forDeleteByQuery(QueryWrapper queryWrapper) {
        return this.buildDeleteSql(queryWrapper);
    }

    @Override
    public String forUpdateById(String tableName, Row row) {
        StringBuilder sql = new StringBuilder();
        Set<String> modifyAttrs = row.obtainModifyAttrs();
        String[] primaryKeys = RowCPI.obtainsPrimaryKeyStrings(row);
        sql.append("UPDATE ").append(this.wrap(tableName)).append(" SET ");
        int index = 0;
        for (Map.Entry e : row.entrySet()) {
            String colName = (String)e.getKey();
            if (!modifyAttrs.contains(colName) || ArrayUtil.contains(primaryKeys, colName)) continue;
            if (index > 0) {
                sql.append(", ");
            }
            sql.append(this.wrap(colName)).append(" = ? ");
            ++index;
        }
        sql.append(" WHERE ");
        for (int i = 0; i < primaryKeys.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(this.wrap(primaryKeys[i])).append(" = ?");
        }
        return sql.toString();
    }

    @Override
    public String forUpdateByQuery(QueryWrapper queryWrapper, Row row) {
        StringBuilder sql = new StringBuilder();
        Set<String> modifyAttrs = row.obtainModifyAttrs();
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        if (queryTables == null || queryTables.size() != 1) {
            throw FlexExceptions.wrap("update sql must need 1 table.", new Object[0]);
        }
        String tableName = queryTables.get(0).getName();
        sql.append("UPDATE ").append(this.wrap(tableName)).append(" SET ");
        int index = 0;
        for (String modifyAttr : modifyAttrs) {
            if (index > 0) {
                sql.append(", ");
            }
            sql.append(this.wrap(modifyAttr)).append(" = ? ");
            ++index;
        }
        String whereConditionSql = this.buildWhereConditionSql(queryWrapper);
        if (StringUtil.isNotBlank(whereConditionSql)) {
            sql.append(" WHERE ").append(whereConditionSql);
        }
        return sql.toString();
    }

    @Override
    public String forUpdateBatchById(String tableName, List<Row> rows) {
        if (rows.size() == 1) {
            return this.forUpdateById(tableName, rows.get(0));
        }
        StringBuilder sql = new StringBuilder();
        for (Row row : rows) {
            sql.append(this.forUpdateById(tableName, row)).append("; ");
        }
        return sql.toString();
    }

    @Override
    public String forSelectOneById(String tableName, String[] primaryKeys, Object[] primaryValues) {
        StringBuilder sql = new StringBuilder("SELECT * FROM ");
        sql.append(this.wrap(tableName)).append(" WHERE ");
        for (int i = 0; i < primaryKeys.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(this.wrap(primaryKeys[i])).append(" = ?");
        }
        return sql.toString();
    }

    @Override
    public String forSelectListByQuery(QueryWrapper queryWrapper) {
        return this.buildSelectSql(queryWrapper);
    }

    @Override
    public String forSelectCountByQuery(QueryWrapper queryWrapper) {
        return this.buildSelectCountSql(queryWrapper);
    }

    @Override
    public String buildSelectSql(QueryWrapper queryWrapper) {
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        List<QueryTable> joinTables = CPI.getJoinTables(queryWrapper);
        List<QueryTable> allTables = CollectionUtil.merge(queryTables, joinTables);
        List<QueryColumn> selectColumns = CPI.getSelectColumns(queryWrapper);
        StringBuilder sqlBuilder = new StringBuilder("SELECT ");
        if (selectColumns == null || selectColumns.isEmpty()) {
            sqlBuilder.append("*");
        } else {
            int index = 0;
            for (QueryColumn selectColumn : selectColumns) {
                String selectColumnSql = CPI.toSelectSql(selectColumn, allTables, this);
                sqlBuilder.append(selectColumnSql);
                if (index != selectColumns.size() - 1) {
                    sqlBuilder.append(", ");
                }
                ++index;
            }
        }
        sqlBuilder.append(" FROM ").append(StringUtil.join(", ", queryTables, queryTable -> queryTable.toSql(this)));
        this.buildJoinSql(sqlBuilder, queryWrapper, allTables);
        this.buildWhereSql(sqlBuilder, queryWrapper, allTables, true);
        this.buildGroupBySql(sqlBuilder, queryWrapper, allTables);
        this.buildHavingSql(sqlBuilder, queryWrapper, allTables);
        this.buildOrderBySql(sqlBuilder, queryWrapper, allTables);
        List<UnionWrapper> unions = CPI.getUnions(queryWrapper);
        if (CollectionUtil.isNotEmpty(unions)) {
            sqlBuilder.insert(0, "(").append(")");
            for (UnionWrapper unionWrapper : unions) {
                unionWrapper.buildSql(sqlBuilder, this);
            }
        }
        Integer limitRows = CPI.getLimitRows(queryWrapper);
        Integer limitOffset = CPI.getLimitOffset(queryWrapper);
        if (limitRows != null || limitOffset != null) {
            sqlBuilder = this.buildLimitOffsetSql(sqlBuilder, queryWrapper, limitRows, limitOffset);
        }
        return sqlBuilder.toString();
    }

    @Override
    public String buildSelectCountSql(QueryWrapper queryWrapper) {
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        List<QueryTable> joinTables = CPI.getJoinTables(queryWrapper);
        List<QueryTable> allTables = CollectionUtil.merge(queryTables, joinTables);
        StringBuilder sqlBuilder = new StringBuilder("SELECT COUNT(*) FROM ");
        sqlBuilder.append(StringUtil.join(", ", queryTables, queryTable -> queryTable.toSql(this)));
        this.buildJoinSql(sqlBuilder, queryWrapper, allTables);
        this.buildWhereSql(sqlBuilder, queryWrapper, allTables, true);
        this.buildGroupBySql(sqlBuilder, queryWrapper, allTables);
        this.buildHavingSql(sqlBuilder, queryWrapper, allTables);
        return sqlBuilder.toString();
    }

    @Override
    public String buildDeleteSql(QueryWrapper queryWrapper) {
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        List<QueryTable> joinTables = CPI.getJoinTables(queryWrapper);
        List<QueryTable> allTables = CollectionUtil.merge(queryTables, joinTables);
        StringBuilder sqlBuilder = new StringBuilder("DELETE FROM ");
        sqlBuilder.append(StringUtil.join(", ", queryTables, queryTable -> queryTable.toSql(this)));
        this.buildJoinSql(sqlBuilder, queryWrapper, allTables);
        this.buildWhereSql(sqlBuilder, queryWrapper, allTables, false);
        this.buildGroupBySql(sqlBuilder, queryWrapper, allTables);
        this.buildHavingSql(sqlBuilder, queryWrapper, allTables);
        return sqlBuilder.toString();
    }

    @Override
    public String buildWhereConditionSql(QueryWrapper queryWrapper) {
        QueryCondition whereQueryCondition = CPI.getWhereQueryCondition(queryWrapper);
        return whereQueryCondition != null ? whereQueryCondition.toSql(CPI.getQueryTables(queryWrapper), this) : "";
    }

    @Override
    public String forInsertEntity(TableInfo tableInfo, Object entity, boolean ignoreNulls) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(this.wrap(tableInfo.getTableName()));
        String[] insertColumns = tableInfo.obtainInsertColumns(entity, ignoreNulls);
        Map<String, String> onInsertColumns = tableInfo.getOnInsertColumns();
        StringJoiner sqlFields = new StringJoiner(", ");
        StringJoiner sqlValues = new StringJoiner(", ");
        for (String insertColumn : insertColumns) {
            sqlFields.add(this.wrap(insertColumn));
            if (onInsertColumns != null && onInsertColumns.containsKey(insertColumn)) {
                sqlValues.add(onInsertColumns.get(insertColumn));
                continue;
            }
            sqlValues.add("?");
        }
        return sql.append("(").append(sqlFields).append(")").append(" VALUES ").append("(").append(sqlValues).append(")").toString();
    }

    @Override
    public String forInsertEntityBatch(TableInfo tableInfo, List<Object> entities) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(this.wrap(tableInfo.getTableName()));
        String[] insertColumns = tableInfo.obtainInsertColumns(null, false);
        CharSequence[] warpedInsertColumns = new String[insertColumns.length];
        for (int i = 0; i < insertColumns.length; ++i) {
            warpedInsertColumns[i] = this.wrap(insertColumns[i]);
        }
        sql.append("(").append(StringUtil.join(", ", warpedInsertColumns)).append(")");
        sql.append(" VALUES ");
        Map<String, String> onInsertColumns = tableInfo.getOnInsertColumns();
        for (int i = 0; i < entities.size(); ++i) {
            StringJoiner stringJoiner = new StringJoiner(", ", "(", ")");
            for (CharSequence insertColumn : warpedInsertColumns) {
                if (onInsertColumns != null && onInsertColumns.containsKey(insertColumn)) {
                    stringJoiner.add(onInsertColumns.get(insertColumn));
                    continue;
                }
                stringJoiner.add("?");
            }
            sql.append(stringJoiner);
            if (i == entities.size() - 1) continue;
            sql.append(", ");
        }
        return sql.toString();
    }

    @Override
    public String forDeleteEntityById(TableInfo tableInfo) {
        String logicDeleteColumn = tableInfo.getLogicDeleteColumn();
        Object[] tenantIdArgs = tableInfo.buildTenantIdArgs();
        if (StringUtil.isBlank(logicDeleteColumn)) {
            String deleteByIdSql = this.forDeleteById(tableInfo.getTableName(), tableInfo.getPrimaryKeys());
            if (ArrayUtil.isNotEmpty(tenantIdArgs)) {
                deleteByIdSql = deleteByIdSql + " AND " + this.wrap(tableInfo.getTenantIdColumn()) + " IN " + this.buildQuestion(tenantIdArgs.length, true);
            }
            return deleteByIdSql;
        }
        StringBuilder sql = new StringBuilder();
        String[] primaryKeys = tableInfo.getPrimaryKeys();
        sql.append("UPDATE ").append(this.wrap(tableInfo.getTableName()));
        sql.append(" SET ").append(this.wrap(logicDeleteColumn)).append(" = ").append(this.getLogicDeletedValue());
        sql.append(" WHERE ");
        for (int i = 0; i < primaryKeys.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(this.wrap(primaryKeys[i])).append(" = ?");
        }
        sql.append(" AND ").append(this.wrap(logicDeleteColumn)).append(" = ").append(this.getLogicNormalValue());
        if (ArrayUtil.isNotEmpty(tenantIdArgs)) {
            sql.append(" AND ").append(this.wrap(tableInfo.getTenantIdColumn())).append(" IN ").append(this.buildQuestion(tenantIdArgs.length, true));
        }
        return sql.toString();
    }

    @Override
    public String forDeleteEntityBatchByIds(TableInfo tableInfo, Object[] primaryValues) {
        String logicDeleteColumn = tableInfo.getLogicDeleteColumn();
        Object[] tenantIdArgs = tableInfo.buildTenantIdArgs();
        if (StringUtil.isBlank(logicDeleteColumn)) {
            String deleteSQL = this.forDeleteBatchByIds(tableInfo.getTableName(), tableInfo.getPrimaryKeys(), primaryValues);
            if (ArrayUtil.isNotEmpty(tenantIdArgs)) {
                deleteSQL = deleteSQL.replace(" WHERE ", " WHERE (") + ")";
                deleteSQL = deleteSQL + " AND " + this.wrap(tableInfo.getTenantIdColumn()) + " IN " + this.buildQuestion(tenantIdArgs.length, true);
            }
            return deleteSQL;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(this.wrap(tableInfo.getTableName()));
        sql.append(" SET ").append(this.wrap(logicDeleteColumn)).append(" = ").append(this.getLogicDeletedValue());
        sql.append(" WHERE ");
        sql.append("(");
        String[] primaryKeys = tableInfo.getPrimaryKeys();
        if (primaryKeys.length > 1) {
            for (int i = 0; i < primaryValues.length / primaryKeys.length; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append("(");
                for (int j = 0; j < primaryKeys.length; ++j) {
                    if (j > 0) {
                        sql.append(" AND ");
                    }
                    sql.append(this.wrap(primaryKeys[j])).append(" = ?");
                }
                sql.append(")");
            }
        } else {
            for (int i = 0; i < primaryValues.length; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append(this.wrap(primaryKeys[0])).append(" = ?");
            }
        }
        sql.append(") AND ").append(this.wrap(logicDeleteColumn)).append(" = ").append(this.getLogicNormalValue());
        if (ArrayUtil.isNotEmpty(tenantIdArgs)) {
            sql.append(" AND ").append(this.wrap(tableInfo.getTenantIdColumn())).append(" IN ").append(this.buildQuestion(tenantIdArgs.length, true));
        }
        return sql.toString();
    }

    @Override
    public String forDeleteEntityBatchByQuery(TableInfo tableInfo, QueryWrapper queryWrapper) {
        String logicDeleteColumn = tableInfo.getLogicDeleteColumn();
        if (StringUtil.isBlank(logicDeleteColumn)) {
            return this.forDeleteByQuery(queryWrapper);
        }
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        List<QueryTable> joinTables = CPI.getJoinTables(queryWrapper);
        List<QueryTable> allTables = CollectionUtil.merge(queryTables, joinTables);
        StringBuilder sqlBuilder = new StringBuilder("UPDATE ");
        sqlBuilder.append(this.wrap(tableInfo.getTableName()));
        sqlBuilder.append(" SET ").append(this.wrap(logicDeleteColumn)).append(" = ").append(this.getLogicDeletedValue());
        this.buildJoinSql(sqlBuilder, queryWrapper, allTables);
        this.buildWhereSql(sqlBuilder, queryWrapper, allTables, false);
        this.buildGroupBySql(sqlBuilder, queryWrapper, allTables);
        this.buildHavingSql(sqlBuilder, queryWrapper, allTables);
        return sqlBuilder.toString();
    }

    @Override
    public String forUpdateEntity(TableInfo tableInfo, Object entity, boolean ignoreNulls) {
        Object[] tenantIdArgs;
        String versionColumn;
        StringBuilder sql = new StringBuilder();
        Set<String> modifyAttrs = tableInfo.obtainUpdateColumns(entity, ignoreNulls, false);
        String[] primaryKeys = tableInfo.getPrimaryKeys();
        sql.append("UPDATE ").append(this.wrap(tableInfo.getTableName())).append(" SET ");
        StringJoiner stringJoiner = new StringJoiner(", ");
        for (String modifyAttr : modifyAttrs) {
            stringJoiner.add(this.wrap(modifyAttr) + " = ?");
        }
        Map<String, String> onUpdateColumns = tableInfo.getOnUpdateColumns();
        if (onUpdateColumns != null && !onUpdateColumns.isEmpty()) {
            onUpdateColumns.forEach((column, value) -> stringJoiner.add(this.wrap((String)column) + " = " + value));
        }
        if (StringUtil.isNotBlank(versionColumn = tableInfo.getVersionColumn())) {
            stringJoiner.add(this.wrap(versionColumn) + " = " + this.wrap(versionColumn) + " + 1 ");
        }
        sql.append(stringJoiner);
        sql.append(" WHERE ");
        for (int i = 0; i < primaryKeys.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(this.wrap(primaryKeys[i])).append(" = ?");
        }
        String logicDeleteColumn = tableInfo.getLogicDeleteColumn();
        if (StringUtil.isNotBlank(logicDeleteColumn)) {
            sql.append(" AND ").append(this.wrap(logicDeleteColumn)).append(" = ").append(this.getLogicNormalValue());
        }
        if (ArrayUtil.isNotEmpty(tenantIdArgs = tableInfo.buildTenantIdArgs())) {
            if (tenantIdArgs.length == 1) {
                sql.append(" AND ").append(this.wrap(tableInfo.getTenantIdColumn())).append(" = ?");
            } else {
                sql.append(" AND ").append(this.wrap(tableInfo.getTenantIdColumn())).append(" IN ").append(this.buildQuestion(tenantIdArgs.length, true));
            }
        }
        if (StringUtil.isNotBlank(versionColumn)) {
            Object versionValue = tableInfo.buildColumnSqlArg(entity, versionColumn);
            if (versionValue == null) {
                throw FlexExceptions.wrap("The version value of entity[%s] must not be null.", entity);
            }
            sql.append(" AND ").append(this.wrap(versionColumn)).append(" = ").append(versionValue);
        }
        return sql.toString();
    }

    @Override
    public String forUpdateEntityByQuery(TableInfo tableInfo, Object entity, boolean ignoreNulls, QueryWrapper queryWrapper) {
        String versionColumn;
        StringBuilder sql = new StringBuilder();
        Set<String> modifyAttrs = tableInfo.obtainUpdateColumns(entity, ignoreNulls, true);
        sql.append("UPDATE ").append(this.wrap(tableInfo.getTableName())).append(" SET ");
        StringJoiner stringJoiner = new StringJoiner(", ");
        for (String modifyAttr : modifyAttrs) {
            stringJoiner.add(this.wrap(modifyAttr) + " = ?");
        }
        Map<String, String> onUpdateColumns = tableInfo.getOnUpdateColumns();
        if (onUpdateColumns != null && !onUpdateColumns.isEmpty()) {
            onUpdateColumns.forEach((column, value) -> stringJoiner.add(this.wrap((String)column) + " = " + value));
        }
        if (StringUtil.isNotBlank(versionColumn = tableInfo.getVersionColumn())) {
            stringJoiner.add(this.wrap(versionColumn) + " = " + this.wrap(versionColumn) + " + 1 ");
        }
        sql.append(stringJoiner);
        String whereConditionSql = this.buildWhereConditionSql(queryWrapper);
        if (StringUtil.isBlank(whereConditionSql)) {
            throw new IllegalArgumentException("Not allowed UPDATE a table without where condition.");
        }
        sql.append(" WHERE ").append(whereConditionSql);
        return sql.toString();
    }

    @Override
    public String forSelectOneEntityById(TableInfo tableInfo) {
        Object[] tenantIdArgs;
        StringBuilder sql = new StringBuilder("SELECT * FROM ");
        sql.append(this.wrap(tableInfo.getTableName()));
        sql.append(" WHERE ");
        String[] pKeys = tableInfo.getPrimaryKeys();
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(this.wrap(pKeys[i])).append(" = ?");
        }
        String logicDeleteColumn = tableInfo.getLogicDeleteColumn();
        if (StringUtil.isNotBlank(logicDeleteColumn)) {
            sql.append(" AND ").append(this.wrap(logicDeleteColumn)).append(" = ").append(this.getLogicNormalValue());
        }
        if (ArrayUtil.isNotEmpty(tenantIdArgs = tableInfo.buildTenantIdArgs())) {
            sql.append(" AND ").append(this.wrap(tableInfo.getTenantIdColumn())).append(" IN ").append(this.buildQuestion(tenantIdArgs.length, true));
        }
        return sql.toString();
    }

    @Override
    public String forSelectEntityListByIds(TableInfo tableInfo, Object[] primaryValues) {
        StringBuilder sql = new StringBuilder("SELECT * FROM ");
        sql.append(this.wrap(tableInfo.getTableName()));
        sql.append(" WHERE ");
        String[] primaryKeys = tableInfo.getPrimaryKeys();
        String logicDeleteColumn = tableInfo.getLogicDeleteColumn();
        Object[] tenantIdArgs = tableInfo.buildTenantIdArgs();
        if (StringUtil.isNotBlank(logicDeleteColumn) || ArrayUtil.isNotEmpty(tenantIdArgs)) {
            sql.append("(");
        }
        if (primaryKeys.length > 1) {
            for (int i = 0; i < primaryValues.length / primaryKeys.length; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append("(");
                for (int j = 0; j < primaryKeys.length; ++j) {
                    if (j > 0) {
                        sql.append(" AND ");
                    }
                    sql.append(this.wrap(primaryKeys[j])).append(" = ?");
                }
                sql.append(")");
            }
        } else {
            for (int i = 0; i < primaryValues.length; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append(this.wrap(primaryKeys[0])).append(" = ?");
            }
        }
        if (StringUtil.isNotBlank(logicDeleteColumn) || ArrayUtil.isNotEmpty(tenantIdArgs)) {
            sql.append(")");
        }
        if (StringUtil.isNotBlank(logicDeleteColumn)) {
            sql.append(" AND ").append(this.wrap(logicDeleteColumn)).append(" = ").append(this.getLogicNormalValue());
        }
        if (ArrayUtil.isNotEmpty(tenantIdArgs)) {
            sql.append(" AND ").append(this.wrap(tableInfo.getTenantIdColumn())).append(" IN").append(this.buildQuestion(tenantIdArgs.length, true));
        }
        return sql.toString();
    }

    protected void buildJoinSql(StringBuilder sqlBuilder, QueryWrapper queryWrapper, List<QueryTable> queryTables) {
        List<Join> joins = CPI.getJoins(queryWrapper);
        if (joins != null && !joins.isEmpty()) {
            for (Join join : joins) {
                if (!join.checkEffective()) continue;
                sqlBuilder.append(join.toSql(queryTables, this));
            }
        }
    }

    protected void buildWhereSql(StringBuilder sqlBuilder, QueryWrapper queryWrapper, List<QueryTable> queryTables, boolean allowNoCondition) {
        QueryCondition whereQueryCondition = CPI.getWhereQueryCondition(queryWrapper);
        if (whereQueryCondition != null) {
            String whereSql = whereQueryCondition.toSql(queryTables, this);
            if (StringUtil.isNotBlank(whereSql)) {
                sqlBuilder.append(" WHERE ").append(whereSql);
            } else if (!allowNoCondition) {
                throw new IllegalArgumentException("Not allowed DELETE a table without where condition.");
            }
        }
    }

    protected void buildGroupBySql(StringBuilder sqlBuilder, QueryWrapper queryWrapper, List<QueryTable> queryTables) {
        List<QueryColumn> groupByColumns = CPI.getGroupByColumns(queryWrapper);
        if (groupByColumns != null && !groupByColumns.isEmpty()) {
            sqlBuilder.append(" GROUP BY ");
            int index = 0;
            for (QueryColumn groupByColumn : groupByColumns) {
                String groupBy = CPI.toConditionSql(groupByColumn, queryTables, this);
                sqlBuilder.append(groupBy);
                if (index != groupByColumns.size() - 1) {
                    sqlBuilder.append(", ");
                }
                ++index;
            }
        }
    }

    protected void buildHavingSql(StringBuilder sqlBuilder, QueryWrapper queryWrapper, List<QueryTable> queryTables) {
        String havingSql;
        QueryCondition havingQueryCondition = CPI.getHavingQueryCondition(queryWrapper);
        if (havingQueryCondition != null && StringUtil.isNotBlank(havingSql = havingQueryCondition.toSql(queryTables, this))) {
            sqlBuilder.append(" HAVING ").append(havingSql);
        }
    }

    protected void buildOrderBySql(StringBuilder sqlBuilder, QueryWrapper queryWrapper, List<QueryTable> queryTables) {
        List<QueryOrderBy> orderBys = CPI.getOrderBys(queryWrapper);
        if (orderBys != null && !orderBys.isEmpty()) {
            sqlBuilder.append(" ORDER BY ");
            int index = 0;
            for (QueryOrderBy orderBy : orderBys) {
                sqlBuilder.append(orderBy.toSql(queryTables, this));
                if (index != orderBys.size() - 1) {
                    sqlBuilder.append(", ");
                }
                ++index;
            }
        }
    }

    protected StringBuilder buildLimitOffsetSql(StringBuilder sqlBuilder, QueryWrapper queryWrapper, Integer limitRows, Integer limitOffset) {
        return this.limitOffsetProcesser.process(sqlBuilder, queryWrapper, limitRows, limitOffset);
    }

    protected String buildQuestion(int count, boolean withBrackets) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append("?");
            if (i == count - 1) continue;
            sb.append(", ");
        }
        return withBrackets ? "(" + sb + ")" : sb.toString();
    }

    protected Object getLogicNormalValue() {
        Object normalValueOfLogicDelete = FlexGlobalConfig.getDefaultConfig().getNormalValueOfLogicDelete();
        if (normalValueOfLogicDelete instanceof Number) {
            return normalValueOfLogicDelete;
        }
        return "\"" + normalValueOfLogicDelete.toString() + "\"";
    }

    protected Object getLogicDeletedValue() {
        Object deletedValueOfLogicDelete = FlexGlobalConfig.getDefaultConfig().getDeletedValueOfLogicDelete();
        if (deletedValueOfLogicDelete instanceof Number) {
            return deletedValueOfLogicDelete;
        }
        return "\"" + deletedValueOfLogicDelete.toString() + "\"";
    }
}

