/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.keygen;

import com.mybatisflex.core.keygen.IMultiKeyGenerator;
import com.mybatisflex.core.keygen.MybatisKeyGeneratorUtil;
import com.mybatisflex.core.table.IdInfo;
import com.mybatisflex.core.table.TableInfo;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.keygen.Jdbc3KeyGenerator;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;

public class MultiPrimaryKeyGenerator
implements KeyGenerator,
IMultiKeyGenerator {
    private List<KeyGenerator> keyGenerators = new ArrayList<KeyGenerator>();
    private String[] autoGenKeyColumnNames;

    public MultiPrimaryKeyGenerator(MappedStatement mappedStatement, TableInfo tableInfo, List<IdInfo> primaryKeyList) {
        ArrayList<String> autoGenKeyColumnNameList = new ArrayList<String>();
        for (IdInfo idInfo : primaryKeyList) {
            KeyGenerator idKeyGenerator = MybatisKeyGeneratorUtil.createIdKeyGenerator(tableInfo, mappedStatement, idInfo);
            this.keyGenerators.add(idKeyGenerator);
            if (idKeyGenerator != Jdbc3KeyGenerator.INSTANCE) continue;
            autoGenKeyColumnNameList.add(idInfo.getColumn());
        }
        this.autoGenKeyColumnNames = autoGenKeyColumnNameList.toArray(new String[0]);
    }

    public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        for (KeyGenerator keyGenerator : this.keyGenerators) {
            keyGenerator.processBefore(executor, ms, stmt, parameter);
        }
    }

    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        for (KeyGenerator keyGenerator : this.keyGenerators) {
            keyGenerator.processAfter(executor, ms, stmt, parameter);
        }
    }

    @Override
    public boolean isNeedGeneratedKeys() {
        for (KeyGenerator keyGenerator : this.keyGenerators) {
            if (keyGenerator != Jdbc3KeyGenerator.INSTANCE) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getKeyColumnNames() {
        return this.autoGenKeyColumnNames;
    }
}

