/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.mybatis;

import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.dialect.DbType;
import com.mybatisflex.core.dialect.DbTypeUtil;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.mybatis.FlexConfiguration;
import com.mybatisflex.core.mybatis.FlexXMLConfigBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.ibatis.exceptions.ExceptionFactory;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;

public class FlexSqlSessionFactoryBuilder
extends SqlSessionFactoryBuilder {
    public SqlSessionFactory build(InputStream inputStream, String environment, Properties properties) {
        try {
            FlexXMLConfigBuilder parser = new FlexXMLConfigBuilder(inputStream, environment, properties);
            SqlSessionFactory sqlSessionFactory = this.build(parser.parse());
            return sqlSessionFactory;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException((String)"Error building SqlSession.", (Exception)e);
        }
        finally {
            ErrorContext.instance().reset();
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public SqlSessionFactory build(Configuration configuration) {
        if (!FlexConfiguration.class.isAssignableFrom(configuration.getClass())) {
            throw FlexExceptions.wrap("only support FlexMybatisConfiguration.", new Object[0]);
        }
        SqlSessionFactory sessionFactory = super.build(configuration);
        DbType dbType = DbTypeUtil.getDbType(configuration.getEnvironment().getDataSource());
        this.initGlobalConfig(configuration, sessionFactory, dbType);
        this.printBanner();
        return sessionFactory;
    }

    private void printBanner() {
        if (!FlexGlobalConfig.getDefaultConfig().isPrintBanner()) {
            return;
        }
        String banner = "  __  __       _           _   _       _____ _           \n |  \\/  |_   _| |__   __ _| |_(_)___  |  ___| | _____  __\n | |\\/| | | | | '_ \\ / _` | __| / __| | |_  | |/ _ \\ \\/ /\n | |  | | |_| | |_) | (_| | |_| \\__ \\ |  _| | |  __/>  < \n |_|  |_|\\__, |_.__/ \\__,_|\\__|_|___/ |_|   |_|\\___/_/\\_\\\n         |___/ v1.1.8 https://mybatis-flex.com";
        System.out.println(banner);
    }

    private void initGlobalConfig(Configuration config, SqlSessionFactory sessionFactory, DbType dbType) {
        FlexGlobalConfig flexGlobalConfig = new FlexGlobalConfig();
        flexGlobalConfig.setSqlSessionFactory(sessionFactory);
        flexGlobalConfig.setDbType(dbType);
        flexGlobalConfig.setConfiguration(config);
        String environmentId = config.getEnvironment().getId();
        FlexGlobalConfig.setConfig(environmentId, flexGlobalConfig);
    }
}

