/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.provider;

import com.mybatisflex.core.dialect.DialectFactory;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.provider.ProviderUtil;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.CollectionUtil;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.builder.annotation.ProviderContext;

public class EntitySqlProvider {
    private EntitySqlProvider() {
    }

    public static String insert(Map params, ProviderContext context) {
        Object entity = ProviderUtil.getEntity(params);
        if (entity == null) {
            throw FlexExceptions.wrap("entity can not be null.", new Object[0]);
        }
        boolean ignoreNulls = ProviderUtil.isIgnoreNulls(params);
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        tableInfo.initVersionValueIfNecessary(entity);
        tableInfo.initTenantIdIfNecessary(entity);
        tableInfo.initLogicDeleteValueIfNecessary(entity);
        tableInfo.invokeOnInsertListener(entity);
        Object[] values = tableInfo.buildInsertSqlArgs(entity, ignoreNulls);
        ProviderUtil.setSqlArgs(params, values);
        return DialectFactory.getDialect().forInsertEntity(tableInfo, entity, ignoreNulls);
    }

    public static String insertBatch(Map params, ProviderContext context) {
        List<Object> entities = ProviderUtil.getEntities(params);
        if (CollectionUtil.isEmpty(entities)) {
            throw FlexExceptions.wrap("entities can not be null or empty.", new Object[0]);
        }
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        for (Object entity : entities) {
            tableInfo.initVersionValueIfNecessary(entity);
            tableInfo.initTenantIdIfNecessary(entity);
            tableInfo.initLogicDeleteValueIfNecessary(entity);
            tableInfo.invokeOnInsertListener(entity);
        }
        Object[] allValues = new Object[]{};
        for (Object entity : entities) {
            allValues = ArrayUtil.concat(allValues, tableInfo.buildInsertSqlArgs(entity, false));
        }
        ProviderUtil.setSqlArgs(params, allValues);
        return DialectFactory.getDialect().forInsertEntityBatch(tableInfo, entities);
    }

    public static String deleteById(Map params, ProviderContext context) {
        Object[] primaryValues = ProviderUtil.getPrimaryValues(params);
        if (ArrayUtil.isEmpty(primaryValues)) {
            throw FlexExceptions.wrap("primaryValues can not be null or empty.", new Object[0]);
        }
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        Object[] allValues = ArrayUtil.concat(primaryValues, tableInfo.buildTenantIdArgs());
        ProviderUtil.setSqlArgs(params, allValues);
        return DialectFactory.getDialect().forDeleteEntityById(tableInfo);
    }

    public static String deleteBatchByIds(Map params, ProviderContext context) {
        Object[] primaryValues = ProviderUtil.getPrimaryValues(params);
        if (ArrayUtil.isEmpty(primaryValues)) {
            throw FlexExceptions.wrap("primaryValues can not be null or empty.", new Object[0]);
        }
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        Object[] tenantIdArgs = tableInfo.buildTenantIdArgs();
        ProviderUtil.setSqlArgs(params, ArrayUtil.concat(primaryValues, tenantIdArgs));
        return DialectFactory.getDialect().forDeleteEntityBatchByIds(tableInfo, primaryValues);
    }

    public static String deleteByQuery(Map params, ProviderContext context) {
        QueryWrapper queryWrapper = ProviderUtil.getQueryWrapper(params);
        if (queryWrapper == null) {
            throw FlexExceptions.wrap("queryWrapper can not be null or empty.", new Object[0]);
        }
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        CPI.setFromIfNecessary(queryWrapper, tableInfo.getTableName());
        tableInfo.appendConditions(null, queryWrapper);
        ProviderUtil.setSqlArgs(params, CPI.getValueArray(queryWrapper));
        return DialectFactory.getDialect().forDeleteEntityBatchByQuery(tableInfo, queryWrapper);
    }

    public static String update(Map params, ProviderContext context) {
        Object entity = ProviderUtil.getEntity(params);
        if (entity == null) {
            throw FlexExceptions.wrap("entity can not be null", new Object[0]);
        }
        boolean ignoreNulls = ProviderUtil.isIgnoreNulls(params);
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        tableInfo.invokeOnUpdateListener(entity);
        Object[] updateValues = tableInfo.buildUpdateSqlArgs(entity, ignoreNulls, false);
        Object[] primaryValues = tableInfo.buildPkSqlArgs(entity);
        Object[] tenantIdArgs = tableInfo.buildTenantIdArgs();
        FlexExceptions.assertAreNotNull(primaryValues, "The value of primary key must not be null, entity[%s]", entity);
        ProviderUtil.setSqlArgs(params, ArrayUtil.concat(updateValues, primaryValues, tenantIdArgs, new Object[0][]));
        return DialectFactory.getDialect().forUpdateEntity(tableInfo, entity, ignoreNulls);
    }

    public static String updateByQuery(Map params, ProviderContext context) {
        Object entity = ProviderUtil.getEntity(params);
        if (entity == null) {
            throw FlexExceptions.wrap("entity can not be null", new Object[0]);
        }
        boolean ignoreNulls = ProviderUtil.isIgnoreNulls(params);
        QueryWrapper queryWrapper = ProviderUtil.getQueryWrapper(params);
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        tableInfo.appendConditions(entity, queryWrapper);
        Object[] values = tableInfo.buildUpdateSqlArgs(entity, ignoreNulls, true);
        Object[] queryParams = CPI.getValueArray(queryWrapper);
        ProviderUtil.setSqlArgs(params, ArrayUtil.concat(values, queryParams));
        return DialectFactory.getDialect().forUpdateEntityByQuery(tableInfo, entity, ignoreNulls, queryWrapper);
    }

    public static String selectOneById(Map params, ProviderContext context) {
        Object[] primaryValues = ProviderUtil.getPrimaryValues(params);
        if (ArrayUtil.isEmpty(primaryValues)) {
            throw FlexExceptions.wrap("primaryValues can not be null or empty.", new Object[0]);
        }
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        Object[] allValues = ArrayUtil.concat(primaryValues, tableInfo.buildTenantIdArgs());
        ProviderUtil.setSqlArgs(params, allValues);
        return DialectFactory.getDialect().forSelectOneEntityById(tableInfo);
    }

    public static String selectListByIds(Map params, ProviderContext context) {
        Object[] primaryValues = ProviderUtil.getPrimaryValues(params);
        if (ArrayUtil.isEmpty(primaryValues)) {
            throw FlexExceptions.wrap("primaryValues can not be null or empty.", new Object[0]);
        }
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        Object[] allValues = ArrayUtil.concat(primaryValues, tableInfo.buildTenantIdArgs());
        ProviderUtil.setSqlArgs(params, allValues);
        return DialectFactory.getDialect().forSelectEntityListByIds(tableInfo, primaryValues);
    }

    public static String selectListByQuery(Map params, ProviderContext context) {
        QueryWrapper queryWrapper = ProviderUtil.getQueryWrapper(params);
        if (queryWrapper == null) {
            throw FlexExceptions.wrap("queryWrapper can not be null.", new Object[0]);
        }
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        tableInfo.appendConditions(null, queryWrapper);
        Object[] values = CPI.getValueArray(queryWrapper);
        ProviderUtil.setSqlArgs(params, values);
        CPI.setFromIfNecessary(queryWrapper, tableInfo.getTableName());
        return DialectFactory.getDialect().forSelectListByQuery(queryWrapper);
    }

    public static String selectCountByQuery(Map params, ProviderContext context) {
        QueryWrapper queryWrapper = ProviderUtil.getQueryWrapper(params);
        if (queryWrapper == null) {
            throw FlexExceptions.wrap("queryWrapper can not be null.", new Object[0]);
        }
        TableInfo tableInfo = ProviderUtil.getTableInfo(context);
        tableInfo.appendConditions(null, queryWrapper);
        Object[] values = CPI.getValueArray(queryWrapper);
        ProviderUtil.setSqlArgs(params, values);
        CPI.setFromIfNecessary(queryWrapper, tableInfo.getTableName());
        return DialectFactory.getDialect().forSelectCountByQuery(queryWrapper);
    }
}

