/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.row;

import com.mybatisflex.annotation.KeyType;
import com.mybatisflex.core.util.SqlUtil;

public class RowKey {
    public static final RowKey ID_AUTO = RowKey.of("id", KeyType.Auto, null, false);
    public static final RowKey ID_UUID = RowKey.of("id", KeyType.Generator, "uuid", true);
    protected String keyColumn;
    protected KeyType keyType = KeyType.Auto;
    protected String value;
    protected boolean before = true;

    public static RowKey of(String keyColumn) {
        SqlUtil.keepColumnSafely(keyColumn);
        RowKey rowKey = new RowKey();
        rowKey.keyColumn = keyColumn;
        return rowKey;
    }

    public static RowKey of(String keyColumn, KeyType keyType) {
        SqlUtil.keepColumnSafely(keyColumn);
        RowKey rowKey = new RowKey();
        rowKey.keyColumn = keyColumn;
        rowKey.keyType = keyType;
        return rowKey;
    }

    public static RowKey of(String keyColumn, KeyType keyType, String keyTypeValue) {
        SqlUtil.keepColumnSafely(keyColumn);
        RowKey rowKey = new RowKey();
        rowKey.keyColumn = keyColumn;
        rowKey.keyType = keyType;
        rowKey.value = keyTypeValue;
        return rowKey;
    }

    public static RowKey of(String keyColumn, KeyType keyType, String keyTypeValue, boolean before) {
        SqlUtil.keepColumnSafely(keyColumn);
        RowKey rowKey = new RowKey();
        rowKey.keyColumn = keyColumn;
        rowKey.keyType = keyType;
        rowKey.value = keyTypeValue;
        rowKey.before = before;
        return rowKey;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isBefore() {
        return this.before;
    }
}

