/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.table;

import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import java.util.Collection;
import java.util.Map;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.property.PropertyTokenizer;
import org.apache.ibatis.reflection.wrapper.BeanWrapper;
import org.apache.ibatis.reflection.wrapper.ObjectWrapper;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;

public class EntityWrapperFactory
implements ObjectWrapperFactory {
    public boolean hasWrapperFor(Object object) {
        Class<?> objectClass = object.getClass();
        if (Map.class.isAssignableFrom(objectClass) || Collection.class.isAssignableFrom(objectClass)) {
            return false;
        }
        return TableInfoFactory.ofEntityClass(objectClass) != null;
    }

    public ObjectWrapper getWrapperFor(MetaObject metaObject, Object object) {
        return new FlexBeanWrapper(metaObject, object);
    }

    static class FlexBeanWrapper
    extends BeanWrapper {
        private Object entity;
        private TableInfo tableInfo;

        public FlexBeanWrapper(MetaObject metaObject, Object object) {
            super(metaObject, object);
            this.entity = object;
            this.tableInfo = TableInfoFactory.ofEntityClass(object.getClass());
        }

        public void set(PropertyTokenizer prop, Object value) {
            Object v = this.tableInfo.invokeOnSetListener(this.entity, prop.getName(), value);
            super.set(prop, v);
        }
    }
}

