/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.table;

import com.mybatisflex.annotation.Column;
import com.mybatisflex.annotation.ColumnMask;
import com.mybatisflex.annotation.Id;
import com.mybatisflex.annotation.InsertListener;
import com.mybatisflex.annotation.NoneListener;
import com.mybatisflex.annotation.SetListener;
import com.mybatisflex.annotation.Table;
import com.mybatisflex.annotation.UpdateListener;
import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.table.ColumnInfo;
import com.mybatisflex.core.table.IdInfo;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.JapaneseDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.reflection.Reflector;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.apache.ibatis.type.UnknownTypeHandler;
import org.apache.ibatis.util.MapUtil;

public class TableInfoFactory {
    private static final Set<Class<?>> defaultSupportColumnTypes = CollectionUtil.newHashSet(Integer.TYPE, Integer.class, Short.TYPE, Short.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Boolean.TYPE, Boolean.class, java.util.Date.class, Date.class, Time.class, Timestamp.class, Instant.class, LocalDate.class, LocalDateTime.class, LocalTime.class, OffsetDateTime.class, OffsetTime.class, ZonedDateTime.class, Year.class, Month.class, YearMonth.class, JapaneseDate.class, byte[].class, Byte[].class, BigInteger.class, BigDecimal.class, Character.TYPE, String.class, Character.class);
    private static final Map<Class<?>, TableInfo> mapperTableInfoMap = new ConcurrentHashMap();
    private static final Map<Class<?>, TableInfo> entityTableMap = new ConcurrentHashMap();
    private static final Map<String, TableInfo> tableInfoMap = new ConcurrentHashMap<String, TableInfo>();

    public static TableInfo ofMapperClass(Class<?> mapperClass) {
        return (TableInfo)MapUtil.computeIfAbsent(mapperTableInfoMap, mapperClass, key -> {
            Class<?> entityClass = TableInfoFactory.getEntityClass(mapperClass);
            if (entityClass == null) {
                return null;
            }
            return TableInfoFactory.ofEntityClass(entityClass);
        });
    }

    public static TableInfo ofEntityClass(Class<?> entityClass) {
        return (TableInfo)MapUtil.computeIfAbsent(entityTableMap, entityClass, aClass -> {
            TableInfo tableInfo = TableInfoFactory.createTableInfo(entityClass);
            tableInfoMap.put(tableInfo.getTableName(), tableInfo);
            return tableInfo;
        });
    }

    public static TableInfo ofTableName(String tableName) {
        return tableInfoMap.get(tableName);
    }

    private static Class<?> getEntityClass(Class<?> mapperClass) {
        Type[] genericInterfaces = mapperClass.getGenericInterfaces();
        if (genericInterfaces.length == 1) {
            Type type = genericInterfaces[0];
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
            }
            return TableInfoFactory.getEntityClass((Class)type);
        }
        return null;
    }

    private static TableInfo createTableInfo(Class<?> entityClass) {
        TableInfo tableInfo = new TableInfo();
        tableInfo.setEntityClass(entityClass);
        tableInfo.setReflector(new Reflector(entityClass));
        Table table = entityClass.getAnnotation(Table.class);
        if (table != null) {
            tableInfo.setTableName(table.value());
            tableInfo.setSchema(table.schema());
            tableInfo.setCamelToUnderline(table.camelToUnderline());
            if (table.onInsert() != NoneListener.class) {
                tableInfo.setOnInsertListener((InsertListener)ClassUtil.newInstance(table.onInsert()));
            }
            if (table.onUpdate() != NoneListener.class) {
                tableInfo.setOnUpdateListener((UpdateListener)ClassUtil.newInstance(table.onUpdate()));
            }
            if (table.onSet() != NoneListener.class) {
                tableInfo.setOnSetListener((SetListener)ClassUtil.newInstance(table.onSet()));
            }
            if (StringUtil.isNotBlank(table.dataSource())) {
                tableInfo.setDataSource(table.dataSource());
            }
        } else {
            String tableName = StringUtil.camelToUnderline(entityClass.getSimpleName());
            tableInfo.setTableName(tableName);
        }
        ArrayList<ColumnInfo> columnInfoList = new ArrayList<ColumnInfo>();
        ArrayList<IdInfo> idInfos = new ArrayList<IdInfo>();
        Field idField = null;
        String logicDeleteColumn = null;
        String versionColumn = null;
        String tenantIdColumn = null;
        HashMap<String, String> onInsertColumns = new HashMap<String, String>();
        HashMap<String, String> onUpdateColumns = new HashMap<String, String>();
        LinkedHashSet<String> largeColumns = new LinkedHashSet<String>();
        List<Field> entityFields = ClassUtil.getAllFields(entityClass);
        for (Field field : entityFields) {
            ColumnMask columnMask;
            ColumnInfo columnInfo;
            Id id;
            String columnName;
            Column column = field.getAnnotation(Column.class);
            if (column != null && column.ignore() || Modifier.isStatic(field.getModifiers()) || (column == null || column.typeHandler() == UnknownTypeHandler.class) && !field.getType().isEnum() && !defaultSupportColumnTypes.contains(field.getType())) continue;
            String string = column != null && StringUtil.isNotBlank(column.value()) ? column.value() : (columnName = tableInfo.isCamelToUnderline() ? StringUtil.camelToUnderline(field.getName()) : field.getName());
            if (column != null && column.isLogicDelete()) {
                if (logicDeleteColumn == null) {
                    logicDeleteColumn = columnName;
                } else {
                    throw FlexExceptions.wrap("The logic delete column of entity[%s] must be less then 2.", entityClass.getName());
                }
            }
            if (column != null && column.version()) {
                if (versionColumn == null) {
                    versionColumn = columnName;
                } else {
                    throw FlexExceptions.wrap("The version column of entity[%s] must be less then 2.", entityClass.getName());
                }
            }
            if (column != null && column.tenantId()) {
                if (tenantIdColumn == null) {
                    tenantIdColumn = columnName;
                } else {
                    throw FlexExceptions.wrap("The tenantId column of entity[%s] must be less then 2.", entityClass.getName());
                }
            }
            if (column != null && StringUtil.isNotBlank(column.onInsertValue())) {
                onInsertColumns.put(columnName, column.onInsertValue().trim());
            }
            if (column != null && StringUtil.isNotBlank(column.onUpdateValue())) {
                onUpdateColumns.put(columnName, column.onUpdateValue().trim());
            }
            if (column != null && column.isLarge()) {
                largeColumns.add(columnName);
            }
            if ((id = field.getAnnotation(Id.class)) != null) {
                columnInfo = new IdInfo(columnName, field.getName(), field.getType(), id);
                idInfos.add((IdInfo)columnInfo);
            } else {
                columnInfo = new ColumnInfo();
                columnInfoList.add(columnInfo);
            }
            columnInfo.setColumn(columnName);
            columnInfo.setProperty(field.getName());
            columnInfo.setPropertyType(field.getType());
            if (column != null && column.typeHandler() != UnknownTypeHandler.class) {
                Class typeHandlerClass = column.typeHandler();
                Configuration configuration = FlexGlobalConfig.getDefaultConfig().getConfiguration();
                TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
                TypeHandler typeHandler = typeHandlerRegistry.getInstance(columnInfo.getPropertyType(), typeHandlerClass);
                columnInfo.setTypeHandler(typeHandler);
            }
            if ((columnMask = field.getAnnotation(ColumnMask.class)) != null && StringUtil.isNotBlank(columnMask.value())) {
                if (String.class != field.getType()) {
                    throw new IllegalStateException("@ColumnMask() only support for string type field. error: " + entityClass.getName() + "." + field.getName());
                }
                columnInfo.setMaskType(columnMask.value().trim());
            }
            if (column != null && column.jdbcType() != JdbcType.UNDEFINED) {
                columnInfo.setJdbcType(column.jdbcType());
            }
            if (!"id".equals(field.getName())) continue;
            idField = field;
        }
        if (idInfos.isEmpty() && idField != null) {
            int index = -1;
            for (int i = 0; i < columnInfoList.size(); ++i) {
                ColumnInfo columnInfo = (ColumnInfo)columnInfoList.get(i);
                if (!"id".equals(columnInfo.getProperty())) continue;
                index = i;
                break;
            }
            if (index >= 0) {
                ColumnInfo removedColumnInfo = (ColumnInfo)columnInfoList.remove(index);
                idInfos.add(new IdInfo(removedColumnInfo));
            }
        }
        tableInfo.setLogicDeleteColumn(logicDeleteColumn);
        tableInfo.setVersionColumn(versionColumn);
        tableInfo.setTenantIdColumn(tenantIdColumn);
        if (!onInsertColumns.isEmpty()) {
            tableInfo.setOnInsertColumns(onInsertColumns);
        }
        if (!onUpdateColumns.isEmpty()) {
            tableInfo.setOnUpdateColumns(onUpdateColumns);
        }
        if (!largeColumns.isEmpty()) {
            tableInfo.setLargeColumns(largeColumns.toArray(new String[0]));
        }
        tableInfo.setColumnInfoList(columnInfoList);
        tableInfo.setPrimaryKeyList(idInfos);
        return tableInfo;
    }
}

