/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.Brackets;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.RawValue;
import com.mybatisflex.core.query.SqlConnector;
import com.mybatisflex.core.query.StringQueryCondition;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class QueryCondition
implements Serializable {
    public static final String LOGIC_LIKE = "LIKE";
    public static final String LOGIC_GT = ">";
    public static final String LOGIC_GE = ">=";
    public static final String LOGIC_LT = "<";
    public static final String LOGIC_LE = "<=";
    public static final String LOGIC_EQUALS = "=";
    public static final String LOGIC_NOT_EQUALS = "!=";
    public static final String LOGIC_IS_NULL = "IS NULL";
    public static final String LOGIC_IS_NOT_NULL = "IS NOT NULL";
    public static final String LOGIC_IN = "IN";
    public static final String LOGIC_NOT_IN = "NOT IN";
    public static final String LOGIC_BETWEEN = "BETWEEN";
    public static final String LOGIC_NOT_BETWEEN = "NOT BETWEEN";
    protected QueryColumn column;
    protected String logic;
    protected Object value;
    protected boolean effective = true;
    protected QueryCondition before;
    protected QueryCondition next;
    protected SqlConnector connector;

    public static QueryCondition createEmpty() {
        return new QueryCondition().when(false);
    }

    public static QueryCondition create(String table, String column, String logic, Object value) {
        QueryCondition condition = new QueryCondition();
        condition.setColumn(new QueryColumn(table, column));
        condition.setLogic(logic);
        condition.setValue(value);
        return condition;
    }

    public static QueryCondition create(QueryColumn queryColumn, Object value) {
        return QueryCondition.create(queryColumn, LOGIC_EQUALS, value);
    }

    public static QueryCondition create(QueryColumn queryColumn, String logic, Object value) {
        QueryCondition condition = new QueryCondition();
        condition.setColumn(queryColumn);
        condition.setLogic(logic);
        condition.setValue(value);
        return condition;
    }

    public QueryColumn getColumn() {
        return this.column;
    }

    public void setColumn(QueryColumn column) {
        this.column = column;
    }

    public Object getValue() {
        return this.checkEffective() ? this.value : null;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getLogic() {
        return this.logic;
    }

    public void setLogic(String logic) {
        this.logic = logic;
    }

    public QueryCondition when(boolean effective) {
        this.effective = effective;
        return this;
    }

    public void when(Supplier<Boolean> fn) {
        Boolean effective = fn.get();
        this.effective = effective != null && effective != false;
    }

    public <T> QueryCondition when(Predicate<T> fn) {
        Object val = this.value;
        if (LOGIC_LIKE.equals(this.logic) && val instanceof String) {
            String valStr = (String)val;
            if (valStr.startsWith("%")) {
                valStr = valStr.substring(1);
            }
            if (valStr.endsWith("%")) {
                valStr = valStr.substring(0, valStr.length() - 1);
            }
            val = valStr;
        }
        this.effective = fn.test(val);
        return this;
    }

    public boolean checkEffective() {
        return this.effective;
    }

    public QueryCondition and(String sql) {
        return this.and(new StringQueryCondition(sql));
    }

    public QueryCondition and(String sql, Object ... params) {
        return this.and(new StringQueryCondition(sql, params));
    }

    public QueryCondition and(QueryCondition nextCondition) {
        return new Brackets(this).and(nextCondition);
    }

    public QueryCondition or(String sql) {
        return this.or(new StringQueryCondition(sql));
    }

    public QueryCondition or(String sql, Object ... params) {
        return this.or(new StringQueryCondition(sql, params));
    }

    public QueryCondition or(QueryCondition nextCondition) {
        return new Brackets(this).or(nextCondition);
    }

    protected void connect(QueryCondition nextCondition, SqlConnector connector) {
        if (this.next != null) {
            this.next.connect(nextCondition, connector);
        } else {
            this.next = nextCondition;
            this.connector = connector;
            nextCondition.before = this;
        }
    }

    public String toSql(List<QueryTable> queryTables, IDialect dialect) {
        StringBuilder sql = new StringBuilder();
        if (this.checkEffective()) {
            QueryCondition effectiveBefore = this.getEffectiveBefore();
            if (effectiveBefore != null) {
                sql.append((Object)effectiveBefore.connector);
            }
            sql.append(this.getColumn().toConditionSql(queryTables, dialect));
            sql.append(" ").append(this.logic).append(" ");
            if (this.value instanceof QueryColumn) {
                sql.append(((QueryColumn)this.value).toConditionSql(queryTables, dialect));
            } else if (this.value instanceof QueryWrapper) {
                sql.append("(").append(dialect.buildSelectSql((QueryWrapper)this.value)).append(")");
            } else if (this.value instanceof RawValue) {
                sql.append(((RawValue)this.value).getContent());
            } else {
                this.appendQuestionMark(sql);
            }
        }
        if (this.next != null) {
            return sql + this.next.toSql(queryTables, dialect);
        }
        return sql.toString();
    }

    protected QueryCondition getEffectiveBefore() {
        if (this.before != null && this.before.checkEffective()) {
            return this.before;
        }
        if (this.before != null) {
            return this.before.getEffectiveBefore();
        }
        return null;
    }

    protected void appendQuestionMark(StringBuilder sqlBuilder) {
        if (!(LOGIC_IS_NULL.equals(this.logic) || LOGIC_IS_NOT_NULL.equals(this.logic) || this.value instanceof QueryColumn || this.value instanceof QueryWrapper || this.value instanceof RawValue)) {
            if (LOGIC_BETWEEN.equals(this.logic) || LOGIC_NOT_BETWEEN.equals(this.logic)) {
                sqlBuilder.append(" ? AND ? ");
            } else if (LOGIC_IN.equals(this.logic) || LOGIC_NOT_IN.equals(this.logic)) {
                int paramsCount = this.calculateValueArrayCount();
                sqlBuilder.append('(');
                for (int i = 0; i < paramsCount; ++i) {
                    sqlBuilder.append('?');
                    if (i == paramsCount - 1) continue;
                    sqlBuilder.append(',');
                }
                sqlBuilder.append(')');
            } else {
                sqlBuilder.append(" ? ");
            }
        }
    }

    private int calculateValueArrayCount() {
        Object[] values = (Object[])this.value;
        int paramsCount = 0;
        for (Object object : values) {
            if (object != null && (object.getClass().isArray() || object.getClass() == int[].class || object.getClass() == long[].class || object.getClass() == short[].class || object.getClass() == float[].class || object.getClass() == double[].class)) {
                paramsCount += Array.getLength(object);
                continue;
            }
            ++paramsCount;
        }
        return paramsCount;
    }

    public String toString() {
        return "QueryCondition{column=" + this.column + ", logic='" + this.logic + '\'' + ", value=" + this.value + ", effective=" + this.effective + '}';
    }
}

