/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.row;

import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.provider.RowSqlProvider;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.util.StringUtil;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.UpdateProvider;
import org.apache.ibatis.exceptions.TooManyResultsException;

public interface RowMapper {
    @InsertProvider(value=RowSqlProvider.class, method="insert")
    public int insert(@Param(value="$$tableName") String var1, @Param(value="$$row") Row var2);

    @InsertProvider(value=RowSqlProvider.class, method="providerRawSql")
    public int insertBySql(@Param(value="$$sql") String var1, Object ... var2);

    @InsertProvider(value=RowSqlProvider.class, method="insertBatchWithFirstRowColumns")
    public int insertBatchWithFirstRowColumns(@Param(value="$$tableName") String var1, @Param(value="$$rows") List<Row> var2);

    @DeleteProvider(value=RowSqlProvider.class, method="providerRawSql")
    public int deleteBySql(@Param(value="$$sql") String var1, Object ... var2);

    default public int deleteById(@Param(value="$$tableName") String tableName, @Param(value="$$row") Row row) {
        return this.deleteById(tableName, StringUtil.join(",", row.obtainsPrimaryKeyStrings()), row.obtainsPrimaryValues());
    }

    @DeleteProvider(value=RowSqlProvider.class, method="deleteById")
    public int deleteById(@Param(value="$$tableName") String var1, @Param(value="$$primaryKey") String var2, @Param(value="$$primaryValue") Object var3);

    @DeleteProvider(value=RowSqlProvider.class, method="deleteBatchByIds")
    public int deleteBatchByIds(@Param(value="$$tableName") String var1, @Param(value="$$primaryKey") String var2, @Param(value="$$primaryValue") Collection<?> var3);

    @DeleteProvider(value=RowSqlProvider.class, method="deleteByQuery")
    public int deleteByQuery(@Param(value="$$tableName") String var1, @Param(value="$$query") QueryWrapper var2);

    @UpdateProvider(value=RowSqlProvider.class, method="providerRawSql")
    public int updateBySql(@Param(value="$$sql") String var1, Object ... var2);

    @UpdateProvider(value=RowSqlProvider.class, method="updateById")
    public int updateById(@Param(value="$$tableName") String var1, @Param(value="$$row") Row var2);

    @UpdateProvider(value=RowSqlProvider.class, method="updateByQuery")
    public int updateByQuery(@Param(value="$$tableName") String var1, @Param(value="$$row") Row var2, @Param(value="$$query") QueryWrapper var3);

    @UpdateProvider(value=RowSqlProvider.class, method="updateBatchById")
    public int updateBatchById(@Param(value="$$tableName") String var1, @Param(value="$$rows") List<Row> var2);

    default public Row selectOneBySql(String sql, Object ... args) {
        List<Row> rows = this.selectListBySql(sql, args);
        if (rows == null || rows.isEmpty()) {
            return null;
        }
        if (rows.size() == 1) {
            return rows.get(0);
        }
        throw new TooManyResultsException("Expected one result (or null) to be returned by selectOneBySql(), but found: " + rows.size());
    }

    default public Row selectOneById(String tableName, Row row) {
        return this.selectOneById(tableName, StringUtil.join(",", row.obtainsPrimaryKeyStrings()), row.obtainsPrimaryValues());
    }

    @SelectProvider(value=RowSqlProvider.class, method="selectOneById")
    public Row selectOneById(@Param(value="$$tableName") String var1, @Param(value="$$primaryKey") String var2, @Param(value="$$primaryValue") Object var3);

    default public Row selectOneByQuery(String tableName, QueryWrapper queryWrapper) {
        List<Row> rows = this.selectListByQuery(tableName, queryWrapper.limit(1));
        if (rows == null || rows.isEmpty()) {
            return null;
        }
        return rows.get(0);
    }

    @SelectProvider(value=RowSqlProvider.class, method="providerRawSql")
    public List<Row> selectListBySql(@Param(value="$$sql") String var1, Object ... var2);

    @SelectProvider(value=RowSqlProvider.class, method="selectListByQuery")
    public List<Row> selectListByQuery(@Param(value="$$tableName") String var1, @Param(value="$$query") QueryWrapper var2);

    default public List<Row> selectAll(@Param(value="$$tableName") String tableName) {
        return this.selectListByQuery(tableName, QueryWrapper.create());
    }

    @SelectProvider(value=RowSqlProvider.class, method="providerRawSql")
    public Object selectObject(@Param(value="$$sql") String var1, Object ... var2);

    @SelectProvider(value=RowSqlProvider.class, method="providerRawSql")
    public List<Object> selectObjectList(@Param(value="$$sql") String var1, Object ... var2);

    default public long selectCount(String sql, Object ... args) {
        Object object = this.selectObject(sql, args);
        if (object == null) {
            return 0L;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        throw FlexExceptions.wrap("selectCount error, Can not get number value for sql: %s", sql);
    }

    @SelectProvider(value=RowSqlProvider.class, method="selectCountByQuery")
    public long selectCountByQuery(@Param(value="$$tableName") String var1, @Param(value="$$query") QueryWrapper var2);

    default public Page<Row> paginate(String tableName, Page<Row> page, QueryWrapper queryWrapper) {
        List<QueryColumn> groupByColumns = CPI.getGroupByColumns(queryWrapper);
        if (page.getTotalRow() < 0L) {
            CPI.setGroupByColumns(queryWrapper, null);
            long count = this.selectCountByQuery(tableName, queryWrapper);
            page.setTotalRow(count);
        }
        if (page.getTotalRow() == 0L || (long)page.getPageNumber() > page.getTotalPage()) {
            return page;
        }
        CPI.setGroupByColumns(queryWrapper, groupByColumns);
        int offset = page.getPageSize() * (page.getPageNumber() - 1);
        queryWrapper.limit(offset, page.getPageSize());
        List<Row> records = this.selectListByQuery(tableName, queryWrapper);
        page.setRecords(records);
        return page;
    }
}

