/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.datasource;

import com.mybatisflex.core.datasource.DataSourceManager;
import com.mybatisflex.core.exception.FlexAssert;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Supplier;

public class DataSourceKey {
    private static ThreadLocal<Deque<String>> lookup = ThreadLocal.withInitial(ArrayDeque::new);

    private DataSourceKey() {
    }

    public static void use(String dataSourceKey) {
        lookup.get().push(dataSourceKey);
    }

    public static String get() {
        return lookup.get().peek();
    }

    public static void clear() {
        Deque<String> deque = lookup.get();
        deque.pop();
        if (deque.isEmpty()) {
            lookup.remove();
        }
    }

    public static void forceClear() {
        lookup.remove();
    }

    public static void use(String dataSourceKey, Runnable runnable) {
        try {
            DataSourceKey.use(dataSourceKey);
            runnable.run();
        }
        finally {
            DataSourceKey.clear();
        }
    }

    public static <T> T use(String dataSourceKey, Supplier<T> supplier) {
        try {
            DataSourceKey.use(dataSourceKey);
            T t = supplier.get();
            return t;
        }
        finally {
            DataSourceKey.clear();
        }
    }

    public static void setThreadLocal(ThreadLocal<Deque<String>> threadLocal) {
        FlexAssert.notNull(threadLocal, "threadLocal");
        if (threadLocal.get() == null) {
            threadLocal.set(lookup.get());
        }
        lookup = threadLocal;
    }

    public static String getShardingDsKey(String dataSource, Object mapper, Method method, Object[] args) {
        String shardingDsKey = DataSourceManager.getShardingDsKey(dataSource, mapper, method, args);
        return shardingDsKey != null ? shardingDsKey : dataSource;
    }

    @Deprecated
    public static String getByManual() {
        throw new UnsupportedOperationException("\u4f7f\u7528 DataSource.get() \u4ee3\u66ff\u3002");
    }

    @Deprecated
    public static String getByAnnotation() {
        throw new UnsupportedOperationException("\u4f7f\u7528 DataSource.get() \u4ee3\u66ff\u3002");
    }

    @Deprecated
    public static void useWithAnnotation(String dataSourceKey) {
        throw new UnsupportedOperationException("\u4f7f\u7528 DataSource.use(String) \u4ee3\u66ff\u3002");
    }

    @Deprecated
    public static void setAnnotationKeyThreadLocal(ThreadLocal<String> annotationKeyThreadLocal) {
        throw new UnsupportedOperationException("\u4f7f\u7528 DataSource.setThreadLocal(ThreadLocal<Deque<String>>) \u4ee3\u66ff\u3002");
    }

    @Deprecated
    public static void setManualKeyThreadLocal(ThreadLocal<String> manualKeyThreadLocal) {
        throw new UnsupportedOperationException("\u4f7f\u7528 DataSource.setThreadLocal(ThreadLocal<Deque<String>>) \u4ee3\u66ff\u3002");
    }
}

