/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.mybatis;

import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.mybatis.FlexConfiguration;
import com.mybatisflex.core.row.RowMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Properties;
import org.apache.ibatis.builder.xml.XMLConfigBuilder;
import org.apache.ibatis.exceptions.ExceptionFactory;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;

public class FlexSqlSessionFactoryBuilder
extends SqlSessionFactoryBuilder {
    public SqlSessionFactory build(Reader reader, String environment, Properties properties) {
        try {
            XMLConfigBuilder parser = new XMLConfigBuilder(FlexConfiguration.class, reader, environment, properties);
            SqlSessionFactory sqlSessionFactory = this.build(parser.parse());
            return sqlSessionFactory;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException((String)"Error building SqlSession.", (Exception)e);
        }
        finally {
            ErrorContext.instance().reset();
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public SqlSessionFactory build(InputStream inputStream, String environment, Properties properties) {
        try {
            XMLConfigBuilder parser = new XMLConfigBuilder(FlexConfiguration.class, inputStream, environment, properties);
            SqlSessionFactory sqlSessionFactory = this.build(parser.parse());
            return sqlSessionFactory;
        }
        catch (Exception e) {
            throw ExceptionFactory.wrapException((String)"Error building SqlSession.", (Exception)e);
        }
        finally {
            ErrorContext.instance().reset();
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public SqlSessionFactory build(Configuration configuration) {
        if (!FlexConfiguration.class.isAssignableFrom(configuration.getClass())) {
            throw FlexExceptions.wrap("only support FlexMybatisConfiguration.", new Object[0]);
        }
        SqlSessionFactory sessionFactory = super.build(configuration);
        this.initDefaultMappers(configuration);
        this.initGlobalConfig(configuration, sessionFactory);
        this.printBanner();
        return sessionFactory;
    }

    private void initDefaultMappers(Configuration configuration) {
        configuration.addMapper(RowMapper.class);
    }

    private void printBanner() {
        if (!FlexGlobalConfig.getDefaultConfig().isPrintBanner()) {
            return;
        }
        String banner = "  __  __       _           _   _       _____ _           \n |  \\/  |_   _| |__   __ _| |_(_)___  |  ___| | _____  __\n | |\\/| | | | | '_ \\ / _` | __| / __| | |_  | |/ _ \\ \\/ /\n | |  | | |_| | |_) | (_| | |_| \\__ \\ |  _| | |  __/>  < \n |_|  |_|\\__, |_.__/ \\__,_|\\__|_|___/ |_|   |_|\\___/_/\\_\\\n         |___/ v1.10.9 https://mybatis-flex.com";
        System.out.println(banner);
    }

    private void initGlobalConfig(Configuration configuration, SqlSessionFactory sessionFactory) {
        boolean configUnInitialize;
        String environmentId = configuration.getEnvironment().getId();
        FlexGlobalConfig globalConfig = FlexGlobalConfig.getConfig(environmentId);
        boolean bl = configUnInitialize = globalConfig == null;
        if (configUnInitialize) {
            globalConfig = new FlexGlobalConfig();
        }
        globalConfig.setSqlSessionFactory(sessionFactory);
        globalConfig.setConfiguration(configuration);
        boolean isDefault = FlexGlobalConfig.getDefaultConfig() == globalConfig;
        FlexGlobalConfig.setConfig(environmentId, globalConfig, configUnInitialize || isDefault);
    }
}

