/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.HasParamsColumn;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.util.ArrayUtil;
import java.util.List;

public class IfFunctionQueryColumn
extends QueryColumn
implements HasParamsColumn {
    private QueryCondition condition;
    private QueryColumn trueValue;
    private QueryColumn falseValue;

    public IfFunctionQueryColumn(QueryCondition condition, QueryColumn trueValue, QueryColumn falseValue) {
        this.condition = condition;
        this.trueValue = trueValue;
        this.falseValue = falseValue;
    }

    @Override
    protected String toConditionSql(List<QueryTable> queryTables, IDialect dialect) {
        return "IF(" + this.condition.toSql(queryTables, dialect) + ", " + this.trueValue.toConditionSql(queryTables, dialect) + ", " + this.falseValue.toConditionSql(queryTables, dialect) + ")";
    }

    @Override
    public Object[] getParamValues() {
        Object[] paramValues;
        Object[] params = WrapperUtil.getValues(this.condition);
        if (this.trueValue instanceof HasParamsColumn) {
            paramValues = ((HasParamsColumn)((Object)this.trueValue)).getParamValues();
            params = ArrayUtil.concat(params, paramValues);
        }
        if (this.falseValue instanceof HasParamsColumn) {
            paramValues = ((HasParamsColumn)((Object)this.falseValue)).getParamValues();
            params = ArrayUtil.concat(params, paramValues);
        }
        return params;
    }

    @Override
    public IfFunctionQueryColumn clone() {
        IfFunctionQueryColumn clone = (IfFunctionQueryColumn)super.clone();
        clone.condition = this.condition.clone();
        clone.trueValue = this.trueValue.clone();
        clone.falseValue = this.falseValue.clone();
        return clone;
    }
}

