/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.util;

import com.mybatisflex.core.util.StringUtil;
import java.util.AbstractMap;
import java.util.Map;
import java.util.function.Function;

public class MapUtil {
    private static final boolean IS_JDK8 = 8 == MapUtil.getJvmVersion0();

    private MapUtil() {
    }

    private static int getJvmVersion0() {
        int jvmVersion = -1;
        try {
            String javaSpecVer = StringUtil.tryTrim(System.getProperty("java.specification.version"));
            if (StringUtil.hasText(javaSpecVer)) {
                if (javaSpecVer.startsWith("1.")) {
                    javaSpecVer = javaSpecVer.substring(2);
                }
                if (javaSpecVer.indexOf(46) == -1) {
                    jvmVersion = Integer.parseInt(javaSpecVer);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (jvmVersion == -1) {
            jvmVersion = 8;
        }
        return jvmVersion;
    }

    public static <K, V> V computeIfAbsent(Map<K, V> map, K key, Function<K, V> mappingFunction) {
        V value;
        if (IS_JDK8 && (value = map.get(key)) != null) {
            return value;
        }
        return map.computeIfAbsent(key, mappingFunction);
    }

    public static <K, V> Map.Entry<K, V> entry(K key, V value) {
        return new AbstractMap.SimpleImmutableEntry<K, V>(key, value);
    }
}

