/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.datasource.processor;

import com.mybatisflex.core.datasource.processor.DataSourceProcessor;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Method;

public class ParamIndexDataSourceProcessor
implements DataSourceProcessor {
    private static final String NULL_STR = "null";
    private static final String DYNAMIC_PREFIX = "#";
    private static final String INDEX_FIRST = "#first";
    private static final String INDEX_LAST = "#last";
    private static final String PARAM_INDEX = "#index";

    @Override
    public String process(String dataSourceKey, Object mapper, Method method, Object[] arguments) {
        if (StringUtil.noText(dataSourceKey)) {
            return null;
        }
        if (!dataSourceKey.startsWith(DYNAMIC_PREFIX)) {
            return null;
        }
        if (arguments.length == 0) {
            return null;
        }
        Integer index = null;
        if (INDEX_FIRST.equals(dataSourceKey)) {
            index = 0;
        } else if (INDEX_LAST.equals(dataSourceKey)) {
            index = arguments.length - 1;
        } else if (dataSourceKey.startsWith(PARAM_INDEX)) {
            index = ParamIndexDataSourceProcessor.parseIndex(dataSourceKey);
        }
        if (null == index) {
            return null;
        }
        if (index >= arguments.length) {
            return null;
        }
        String value = String.valueOf(arguments[index]);
        if (StringUtil.noText(value) || NULL_STR.equals(value)) {
            return null;
        }
        return value;
    }

    private static Integer parseIndex(String dsKey) {
        String indexStr = dsKey.substring(PARAM_INDEX.length());
        if (indexStr.isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(indexStr);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

