/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.util.StringUtil;

public class Assert {
    private Assert() {
    }

    public static <T> T that(T value, boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException("Assertion failed");
        }
        return value;
    }

    public static <T> T that(T value, boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message != null ? message : "Assertion failed");
        }
        return value;
    }

    public static String hasText(String text, String message) {
        if (StringUtil.noText(text)) {
            throw new IllegalArgumentException(StringUtil.hasText(message) ? message : "value must have text");
        }
        return text;
    }

    public static boolean hasText(String text) {
        if (StringUtil.noText(text)) {
            throw new IllegalArgumentException("value must have text");
        }
        return true;
    }

    public static boolean notNull(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        return true;
    }

    public static boolean notNull(Object obj, String message) {
        if (obj == null) {
            throw new IllegalArgumentException(StringUtil.hasText(message) ? message : "value must not be null");
        }
        return true;
    }
}

