/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.relation;

import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.relation.AbstractRelation;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.ConvertUtil;
import com.mybatisflex.core.util.FieldWrapper;
import com.mybatisflex.core.util.MapperUtil;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ToManyRelation<SelfEntity>
extends AbstractRelation<SelfEntity> {
    protected String mapKeyField;
    protected FieldWrapper mapKeyFieldWrapper;
    protected String orderBy;
    protected long limit = 0L;
    protected String selfValueSplitBy;

    public ToManyRelation(String selfField, String targetSchema, String targetTable, String targetField, String valueField, String joinTable, String joinSelfColumn, String joinTargetColumn, String dataSource, Class<SelfEntity> selfEntityClass, Field relationField, String extraCondition, String[] selectColumns) {
        super(selfField, targetSchema, targetTable, targetField, valueField, joinTable, joinSelfColumn, joinTargetColumn, dataSource, selfEntityClass, relationField, extraCondition, selectColumns);
    }

    public static Class<? extends Map> getMapWrapType(Class<?> type) {
        if (ClassUtil.canInstance(type.getModifiers())) {
            return type;
        }
        return HashMap.class;
    }

    @Override
    public QueryWrapper buildQueryWrapper(Set<Object> targetValues) {
        if (StringUtil.hasText(this.selfValueSplitBy) && CollectionUtil.isNotEmpty(targetValues)) {
            HashSet<Object> newTargetValues = new HashSet<Object>();
            for (Object targetValue : targetValues) {
                String[] splitValues;
                if (targetValue == null) continue;
                if (!(targetValue instanceof String)) {
                    throw FlexExceptions.wrap("split field only support String type, but current type is: \"" + targetValue.getClass().getName() + "\"", new Object[0]);
                }
                for (String splitValue : splitValues = ((String)targetValue).split(this.selfValueSplitBy)) {
                    if (splitValue == null || splitValue.isEmpty()) continue;
                    newTargetValues.add(ConvertUtil.convert(splitValue, this.targetFieldWrapper.getFieldType()));
                }
            }
            targetValues = newTargetValues;
        }
        return super.buildQueryWrapper(targetValues);
    }

    @Override
    public void customizeQueryWrapper(QueryWrapper queryWrapper) {
        if (StringUtil.hasText(this.orderBy)) {
            queryWrapper.orderBy(this.orderBy);
        }
        if (this.limit > 0L) {
            queryWrapper.limit(this.limit);
        }
    }

    @Override
    public void join(List<SelfEntity> selfEntities, List<?> targetObjectList, List<Row> mappingRows) {
        Class<?> fieldType;
        boolean isMapType;
        HashMap<String, List> leftFieldToRightTableMap = new HashMap<String, List>(targetObjectList.size());
        for (Object targetObject : targetObjectList) {
            Object targetJoinFieldValue = this.targetFieldWrapper.get(targetObject);
            if (targetJoinFieldValue == null) continue;
            leftFieldToRightTableMap.computeIfAbsent(targetJoinFieldValue.toString(), k -> new ArrayList(1)).add(targetObject);
        }
        if (mappingRows != null) {
            HashMap<String, List> temp = new HashMap<String, List>(selfEntities.size());
            for (Row mappingRow : mappingRows) {
                List targetObjects;
                Object midTableJoinTargetValue;
                Object midTableJoinSelfValue = mappingRow.getIgnoreCase(this.joinSelfColumn);
                if (midTableJoinSelfValue == null || (midTableJoinTargetValue = mappingRow.getIgnoreCase(this.joinTargetColumn)) == null || (targetObjects = (List)leftFieldToRightTableMap.get(midTableJoinTargetValue.toString())) == null) continue;
                temp.computeIfAbsent(midTableJoinSelfValue.toString(), k -> new ArrayList(targetObjects.size())).addAll(targetObjects);
            }
            leftFieldToRightTableMap = temp;
        }
        Class<Object> wrapType = (isMapType = Map.class.isAssignableFrom(fieldType = this.relationFieldWrapper.getFieldType())) ? ToManyRelation.getMapWrapType(fieldType) : MapperUtil.getCollectionWrapType(fieldType);
        boolean splitMode = StringUtil.hasText(this.selfValueSplitBy);
        for (SelfEntity selfEntity : selfEntities) {
            HashSet<String> targetMappingValues;
            Object selfValue;
            if (selfEntity == null || (selfValue = this.selfFieldWrapper.get(selfEntity)) == null) continue;
            selfValue = selfValue.toString();
            if (splitMode) {
                String[] splitValues = ((String)selfValue).split(this.selfValueSplitBy);
                targetMappingValues = new LinkedHashSet<String>(Arrays.asList(splitValues));
            } else {
                targetMappingValues = new HashSet<String>(1);
                targetMappingValues.add((String)selfValue);
            }
            if (targetMappingValues.isEmpty()) {
                return;
            }
            if (isMapType) {
                Map map = ClassUtil.newInstance(wrapType);
                HashSet<Object> validateCountSet = new HashSet<Object>(targetMappingValues.size());
                for (String string : targetMappingValues) {
                    List targetObjects = (List)leftFieldToRightTableMap.get(string);
                    if (targetObjects == null) continue;
                    for (Object targetObject : targetObjects) {
                        Object keyValue = this.mapKeyFieldWrapper.get(targetObject);
                        Object needKeyValue = ConvertUtil.convert(keyValue, this.relationFieldWrapper.getKeyType());
                        if (validateCountSet.contains(needKeyValue)) {
                            throw FlexExceptions.wrap("When fieldType is Map, the target entity can only be one,\n current entity type is : " + selfEntity + "\n relation field name is : " + this.relationField.getName() + "\n target entity is : " + targetObjects, new Object[0]);
                        }
                        validateCountSet.add(needKeyValue);
                        map.put(needKeyValue, targetObject);
                    }
                }
                if (map.isEmpty()) continue;
                this.relationFieldWrapper.set(map, selfEntity);
                continue;
            }
            Collection collection = (Collection)((Object)ClassUtil.newInstance(wrapType));
            if (this.onlyQueryValueField) {
                Object first = targetObjectList.iterator().next();
                FieldWrapper fieldValueFieldWrapper = FieldWrapper.of(first.getClass(), this.valueField);
                for (String targetMappingValue2 : targetMappingValues) {
                    List targetObjects = (List)leftFieldToRightTableMap.get(targetMappingValue2);
                    if (targetObjects == null) continue;
                    for (Object targetObject : targetObjects) {
                        collection.add(fieldValueFieldWrapper.get(targetObject));
                    }
                }
            } else {
                for (String targetMappingValue : targetMappingValues) {
                    List list = (List)leftFieldToRightTableMap.get(targetMappingValue);
                    if (list == null) continue;
                    collection.addAll(list);
                }
            }
            this.relationFieldWrapper.set(collection, selfEntity);
        }
    }

    public void setMapKeyField(String mapKeyField) {
        this.mapKeyField = mapKeyField;
        if (StringUtil.hasText(mapKeyField)) {
            this.mapKeyFieldWrapper = FieldWrapper.of(this.targetEntityClass, mapKeyField);
        } else if (Map.class.isAssignableFrom(this.relationFieldWrapper.getFieldType())) {
            throw FlexExceptions.wrap("Please config mapKeyField for map field: " + this.relationFieldWrapper.getField(), new Object[0]);
        }
    }
}

