/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core;

import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.provider.EntitySqlProvider;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.ObjectUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.DeleteProvider;
import org.apache.ibatis.annotations.InsertProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.UpdateProvider;

public interface BaseMapper<T> {
    default public int insert(T entity) {
        return this.insert(entity, false);
    }

    default public int insertSelective(T entity) {
        return this.insert(entity, true);
    }

    @InsertProvider(type=EntitySqlProvider.class, method="insert")
    public int insert(@Param(value="$$entity") T var1, @Param(value="$$ignoreNulls") boolean var2);

    @InsertProvider(type=EntitySqlProvider.class, method="insertBatch")
    public int insertBatch(@Param(value="$$entities") List<T> var1);

    default public int insertBatch(List<T> entities, int size) {
        if (size <= 0) {
            size = 1000;
        }
        int sum = 0;
        int entitiesSize = entities.size();
        int maxIndex = entitiesSize / size + (entitiesSize % size == 0 ? 0 : 1);
        for (int i = 0; i < maxIndex; ++i) {
            List<T> list = entities.subList(i * size, Math.min(i * size + size, entitiesSize));
            sum += this.insertBatch(list);
        }
        return sum;
    }

    default public int insertOrUpdate(T entity) {
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(entity.getClass());
        Object[] pkArgs = tableInfo.buildPkSqlArgs(entity);
        if (pkArgs.length == 0 || pkArgs[0] == null) {
            return this.insert(entity);
        }
        return this.update(entity);
    }

    @DeleteProvider(type=EntitySqlProvider.class, method="deleteById")
    public int deleteById(@Param(value="$$primaryValue") Serializable var1);

    @DeleteProvider(type=EntitySqlProvider.class, method="deleteBatchByIds")
    public int deleteBatchByIds(@Param(value="$$primaryValue") Collection<? extends Serializable> var1);

    default public int deleteBatchByIds(@Param(value="$$primaryValue") List<? extends Serializable> ids, int size) {
        if (size <= 0) {
            size = 1000;
        }
        int sum = 0;
        int entitiesSize = ids.size();
        int maxIndex = entitiesSize / size + (entitiesSize % size == 0 ? 0 : 1);
        for (int i = 0; i < maxIndex; ++i) {
            List<? extends Serializable> list = ids.subList(i * size, Math.min(i * size + size, entitiesSize));
            sum += this.deleteBatchByIds(list);
        }
        return sum;
    }

    default public int deleteByMap(Map<String, Object> whereConditions) {
        if (ObjectUtil.areNull(whereConditions) || whereConditions.isEmpty()) {
            throw FlexExceptions.wrap("deleteByMap is not allow empty map.", new Object[0]);
        }
        return this.deleteByQuery(QueryWrapper.create().where(whereConditions));
    }

    default public int deleteByCondition(QueryCondition condition) {
        return this.deleteByQuery(QueryWrapper.create().where(condition));
    }

    @DeleteProvider(type=EntitySqlProvider.class, method="deleteByQuery")
    public int deleteByQuery(@Param(value="$$query") QueryWrapper var1);

    default public int update(T entity) {
        return this.update(entity, true);
    }

    @UpdateProvider(type=EntitySqlProvider.class, method="update")
    public int update(@Param(value="$$entity") T var1, @Param(value="$$ignoreNulls") boolean var2);

    default public int updateByMap(T entity, Map<String, Object> map) {
        return this.updateByQuery(entity, QueryWrapper.create().where(map));
    }

    default public int updateByCondition(T entity, QueryCondition condition) {
        return this.updateByQuery(entity, QueryWrapper.create().where(condition));
    }

    default public int updateByCondition(T entity, boolean ignoreNulls, QueryCondition condition) {
        return this.updateByQuery(entity, ignoreNulls, QueryWrapper.create().where(condition));
    }

    default public int updateByQuery(@Param(value="$$entity") T entity, @Param(value="$$query") QueryWrapper queryWrapper) {
        return this.updateByQuery(entity, true, queryWrapper);
    }

    @UpdateProvider(type=EntitySqlProvider.class, method="updateByQuery")
    public int updateByQuery(@Param(value="$$entity") T var1, @Param(value="$$ignoreNulls") boolean var2, @Param(value="$$query") QueryWrapper var3);

    @SelectProvider(type=EntitySqlProvider.class, method="selectOneById")
    public T selectOneById(@Param(value="$$primaryValue") Serializable var1);

    default public T selectOneByMap(Map<String, Object> whereConditions) {
        return this.selectOneByQuery(QueryWrapper.create().where(whereConditions));
    }

    default public T selectOneByCondition(QueryCondition condition) {
        return this.selectOneByQuery(QueryWrapper.create().where(condition));
    }

    default public T selectOneByQuery(@Param(value="$$query") QueryWrapper queryWrapper) {
        List<T> entities = this.selectListByQuery(queryWrapper.limit(1));
        return entities == null || entities.isEmpty() ? null : (T)entities.get(0);
    }

    @SelectProvider(type=EntitySqlProvider.class, method="selectListByIds")
    public List<T> selectListByIds(@Param(value="$$primaryValue") Collection<? extends Serializable> var1);

    default public List<T> selectListByMap(Map<String, Object> whereConditions) {
        return this.selectListByQuery(QueryWrapper.create().where(whereConditions));
    }

    default public List<T> selectListByMap(Map<String, Object> whereConditions, int count) {
        return this.selectListByQuery(QueryWrapper.create().where(whereConditions).limit(count));
    }

    default public List<T> selectListByCondition(QueryCondition condition) {
        return this.selectListByQuery(QueryWrapper.create().where(condition));
    }

    default public List<T> selectListByCondition(QueryCondition condition, int count) {
        return this.selectListByQuery(QueryWrapper.create().where(condition).limit(count));
    }

    @SelectProvider(type=EntitySqlProvider.class, method="selectListByQuery")
    public List<T> selectListByQuery(@Param(value="$$query") QueryWrapper var1);

    default public List<T> selectAll() {
        return this.selectListByQuery(new QueryWrapper());
    }

    default public long selectCountByCondition(QueryCondition condition) {
        return this.selectCountByQuery(QueryWrapper.create().where(condition));
    }

    @SelectProvider(type=EntitySqlProvider.class, method="selectCountByQuery")
    public long selectCountByQuery(@Param(value="$$query") QueryWrapper var1);

    default public Page<T> paginate(int pageNumber, int pageSize, QueryWrapper queryWrapper) {
        Page page = new Page(pageNumber, pageSize);
        return this.paginate(page, queryWrapper);
    }

    default public Page<T> paginate(int pageNumber, int pageSize, QueryCondition condition) {
        Page page = new Page(pageNumber, pageSize);
        return this.paginate(page, new QueryWrapper().where(condition));
    }

    default public Page<T> paginate(int pageNumber, int pageSize, int totalRow, QueryWrapper queryWrapper) {
        Page page = new Page(pageNumber, pageSize, totalRow);
        return this.paginate(page, queryWrapper);
    }

    default public Page<T> paginate(int pageNumber, int pageSize, int totalRow, QueryCondition condition) {
        Page page = new Page(pageNumber, pageSize, totalRow);
        return this.paginate(page, new QueryWrapper().where(condition));
    }

    default public Page<T> paginate(@Param(value="page") Page<T> page, @Param(value="query") QueryWrapper queryWrapper) {
        List<QueryColumn> groupByColumns = null;
        if (page.getTotalRow() < 0L) {
            groupByColumns = CPI.getGroupByColumns(queryWrapper);
            CPI.setGroupByColumns(queryWrapper, null);
            long count = this.selectCountByQuery(queryWrapper);
            page.setTotalRow(count);
        }
        if (page.getTotalRow() == 0L || (long)page.getPageNumber() > page.getTotalPage()) {
            return page;
        }
        if (groupByColumns != null) {
            CPI.setGroupByColumns(queryWrapper, groupByColumns);
        }
        int offset = page.getPageSize() * (page.getPageNumber() - 1);
        queryWrapper.limit(offset, page.getPageSize());
        List<T> rows = this.selectListByQuery(queryWrapper);
        page.setRecords(rows);
        return page;
    }
}

