/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.dialect;

import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.dialect.DbType;
import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.dialect.KeywordWrap;
import com.mybatisflex.core.dialect.LimitOffsetProcesser;
import com.mybatisflex.core.dialect.impl.CommonsDialectImpl;
import com.mybatisflex.core.dialect.impl.OracleDialect;
import com.mybatisflex.core.util.ObjectUtil;
import java.util.EnumMap;
import java.util.Map;
import org.apache.ibatis.util.MapUtil;

public class DialectFactory {
    private static Map<DbType, IDialect> dialectMap = new EnumMap<DbType, IDialect>(DbType.class);
    private static ThreadLocal<DbType> dbTypeThreadLocal = new ThreadLocal();

    public static IDialect getDialect() {
        DbType dbType = ObjectUtil.requireNonNullElse(dbTypeThreadLocal.get(), FlexGlobalConfig.getDefaultConfig().getDbType());
        return (IDialect)MapUtil.computeIfAbsent(dialectMap, (Object)((Object)dbType), DialectFactory::createDialect);
    }

    public static void setHintDbType(DbType dbType) {
        dbTypeThreadLocal.set(dbType);
    }

    public static DbType getHintDbType() {
        return dbTypeThreadLocal.get();
    }

    public static void clearHintDbType() {
        dbTypeThreadLocal.remove();
    }

    public static void registerDialect(DbType dbType, IDialect dialect) {
        dialectMap.put(dbType, dialect);
    }

    private static IDialect createDialect(DbType dbType) {
        switch (dbType) {
            case MYSQL: 
            case H2: 
            case MARIADB: 
            case GBASE: 
            case OSCAR: 
            case XUGU: 
            case CLICK_HOUSE: 
            case OCEAN_BASE: 
            case CUBRID: 
            case GOLDILOCKS: 
            case CSIIDB: {
                return new CommonsDialectImpl(KeywordWrap.BACKQUOTE, LimitOffsetProcesser.MYSQL);
            }
            case ORACLE: {
                return new OracleDialect(LimitOffsetProcesser.ORACLE);
            }
            case DM: 
            case GAUSS: {
                return new CommonsDialectImpl(KeywordWrap.DOUBLE_QUOTATION, LimitOffsetProcesser.ORACLE);
            }
            case POSTGRE_SQL: 
            case SQLITE: 
            case HSQL: 
            case KINGBASE_ES: 
            case PHOENIX: 
            case SAP_HANA: 
            case IMPALA: 
            case HIGH_GO: 
            case VERTICA: 
            case REDSHIFT: 
            case OPENGAUSS: 
            case TDENGINE: 
            case UXDB: {
                return new CommonsDialectImpl(KeywordWrap.DOUBLE_QUOTATION, LimitOffsetProcesser.POSTGRESQL);
            }
            case ORACLE_12C: {
                return new OracleDialect(LimitOffsetProcesser.DERBY);
            }
            case FIREBIRD: {
                return new CommonsDialectImpl(KeywordWrap.DOUBLE_QUOTATION, LimitOffsetProcesser.DERBY);
            }
            case SQLSERVER: {
                return new CommonsDialectImpl(KeywordWrap.SQUARE_BRACKETS, LimitOffsetProcesser.DERBY);
            }
            case SQLSERVER_2005: {
                return new CommonsDialectImpl(KeywordWrap.SQUARE_BRACKETS, LimitOffsetProcesser.DB2);
            }
            case INFORMIX: {
                return new CommonsDialectImpl(KeywordWrap.DOUBLE_QUOTATION, LimitOffsetProcesser.INFORMIX);
            }
            case DB2: {
                return new CommonsDialectImpl(KeywordWrap.DOUBLE_QUOTATION, LimitOffsetProcesser.DB2);
            }
            case SYBASE: {
                return new CommonsDialectImpl(KeywordWrap.DOUBLE_QUOTATION, LimitOffsetProcesser.SYBASE);
            }
        }
        return new CommonsDialectImpl();
    }
}

