/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.keygen;

import com.mybatisflex.core.keygen.IKeyGenerator;
import com.mybatisflex.core.keygen.impl.FlexIDKeyGenerator;
import com.mybatisflex.core.keygen.impl.UUIDKeyGenerator;
import java.util.HashMap;
import java.util.Map;

public class KeyGeneratorFactory {
    private static final Map<String, IKeyGenerator> KEY_GENERATOR_MAP = new HashMap<String, IKeyGenerator>();

    public static IKeyGenerator getKeyGenerator(String name) {
        return KEY_GENERATOR_MAP.get(name.trim());
    }

    public static void register(String key, IKeyGenerator keyGenerator) {
        KEY_GENERATOR_MAP.put(key.trim(), keyGenerator);
    }

    static {
        KeyGeneratorFactory.register("uuid", new UUIDKeyGenerator());
        KeyGeneratorFactory.register("flexId", new FlexIDKeyGenerator());
    }
}

