/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.handler;

import com.mybatisflex.annotation.EnumValue;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class FlexEnumTypeHandler<E extends Enum<E>>
extends BaseTypeHandler<E> {
    private Class<?> enumPropertyType;
    private E[] enums;
    private Field property;
    private Method getter;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FlexEnumTypeHandler(Class<E> enumClass) {
        List<Field> allFields = ClassUtil.getAllFields(enumClass, field -> field.getAnnotation(EnumValue.class) != null);
        Field field2 = allFields.get(0);
        String fieldGetterName = "get" + StringUtil.firstCharToUpperCase(field2.getName());
        List<Method> allMethods = ClassUtil.getAllMethods(enumClass, method -> {
            String methodName = method.getName();
            return methodName.equals(fieldGetterName);
        });
        this.enumPropertyType = ClassUtil.wrap(field2.getType());
        this.enums = (Enum[])enumClass.getEnumConstants();
        if (allMethods.isEmpty()) {
            if (!Modifier.isPublic(field2.getModifiers())) throw new IllegalStateException("Can not find \"" + fieldGetterName + "()\" method in enum: " + enumClass.getName());
            this.property = field2;
            return;
        } else {
            this.getter = allMethods.get(0);
        }
    }

    public void setNonNullParameter(PreparedStatement ps, int i, E parameter, JdbcType jdbcType) throws SQLException {
        Object value = this.getValue(parameter);
        if (jdbcType == null) {
            ps.setObject(i, value);
        } else {
            ps.setObject(i, value, jdbcType.TYPE_CODE);
        }
    }

    private Object getValue(E object) {
        try {
            return this.getter != null ? this.getter.invoke(object, new Object[0]) : this.property.get(object);
        }
        catch (Exception e) {
            throw FlexExceptions.wrap(e);
        }
    }

    public E getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Object value = rs.getObject(columnName, this.enumPropertyType);
        if (null == value && rs.wasNull()) {
            return null;
        }
        return this.convertToEnum(value);
    }

    public E getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Object value = rs.getObject(columnIndex, this.enumPropertyType);
        if (null == value && rs.wasNull()) {
            return null;
        }
        return this.convertToEnum(value);
    }

    public E getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Object value = cs.getObject(columnIndex, this.enumPropertyType);
        if (null == value && cs.wasNull()) {
            return null;
        }
        return this.convertToEnum(value);
    }

    private E convertToEnum(Object value) {
        for (E e : this.enums) {
            if (!value.equals(this.getValue(e))) continue;
            return e;
        }
        return null;
    }
}

