/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.provider;

import com.mybatisflex.core.dialect.DialectFactory;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.provider.ProviderUtil;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.row.RowCPI;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.CollectionUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class RowSqlProvider {
    public static final String METHOD_RAW_SQL = "providerRawSql";

    private RowSqlProvider() {
    }

    public static String providerRawSql(Map params) {
        return ProviderUtil.getSqlString(params);
    }

    public static String insert(Map params) {
        String tableName = ProviderUtil.getTableName(params);
        Row row = ProviderUtil.getRow(params);
        ProviderUtil.setSqlArgs(params, RowCPI.obtainModifyValues(row));
        return DialectFactory.getDialect().forInsertRow(tableName, row);
    }

    public static String insertBatchWithFirstRowColumns(Map params) {
        String tableName = ProviderUtil.getTableName(params);
        List<Row> rows = ProviderUtil.getRows(params);
        if (rows == null || rows.isEmpty()) {
            throw FlexExceptions.wrap("rows can not be null or empty.", new Object[0]);
        }
        LinkedHashSet<String> modifyAttrs = new LinkedHashSet<String>(rows.get(0).obtainModifyAttrs());
        rows.forEach(row -> RowCPI.keepModifyAttrs(row, modifyAttrs));
        Object[] values = new Object[]{};
        for (Row row2 : rows) {
            values = ArrayUtil.concat(values, RowCPI.obtainModifyValues(row2));
        }
        ProviderUtil.setSqlArgs(params, values);
        return DialectFactory.getDialect().forInsertBatchWithFirstRowColumns(tableName, rows);
    }

    public static String deleteById(Map params) {
        String tableName = ProviderUtil.getTableName(params);
        String[] primaryKeys = ProviderUtil.getPrimaryKeys(params);
        Object[] primaryValues = ProviderUtil.getPrimaryValues(params);
        if (primaryValues.length == 0) {
            throw FlexExceptions.wrap("primaryValue can not be null", new Object[0]);
        }
        ProviderUtil.setSqlArgs(params, primaryValues);
        return DialectFactory.getDialect().forDeleteById(tableName, primaryKeys);
    }

    public static String deleteBatchByIds(Map params) {
        String tableName = ProviderUtil.getTableName(params);
        String[] primaryKeys = ProviderUtil.getPrimaryKeys(params);
        Object[] primaryValues = ProviderUtil.getPrimaryValues(params);
        ProviderUtil.setSqlArgs(params, primaryValues);
        return DialectFactory.getDialect().forDeleteBatchByIds(tableName, primaryKeys, primaryValues);
    }

    public static String deleteByQuery(Map params) {
        String tableName = ProviderUtil.getTableName(params);
        QueryWrapper queryWrapper = ProviderUtil.getQueryWrapper(params);
        CPI.setFromIfNecessary(queryWrapper, tableName);
        Object[] valueArray = CPI.getValueArray(queryWrapper);
        ProviderUtil.setSqlArgs(params, valueArray);
        return DialectFactory.getDialect().forDeleteByQuery(queryWrapper);
    }

    public static String updateById(Map params) {
        String tableName = ProviderUtil.getTableName(params);
        Row row = ProviderUtil.getRow(params);
        ProviderUtil.setSqlArgs(params, RowCPI.obtainAllModifyValues(row));
        return DialectFactory.getDialect().forUpdateById(tableName, row);
    }

    public static String updateByQuery(Map params) {
        String tableName = ProviderUtil.getTableName(params);
        Row data = ProviderUtil.getRow(params);
        QueryWrapper queryWrapper = ProviderUtil.getQueryWrapper(params);
        CPI.setFromIfNecessary(queryWrapper, tableName);
        Object[] modifyValues = RowCPI.obtainModifyValues(data);
        Object[] valueArray = CPI.getValueArray(queryWrapper);
        ProviderUtil.setSqlArgs(params, ArrayUtil.concat(modifyValues, valueArray));
        return DialectFactory.getDialect().forUpdateByQuery(queryWrapper, data);
    }

    public static String updateBatchById(Map params) {
        String tableName = ProviderUtil.getTableName(params);
        List<Row> rows = ProviderUtil.getRows(params);
        if (CollectionUtil.isEmpty(rows)) {
            throw FlexExceptions.wrap("rows can not be null or empty.", new Object[0]);
        }
        Object[] values = new Object[]{};
        for (Row row : rows) {
            values = ArrayUtil.concat(values, RowCPI.obtainAllModifyValues(row));
        }
        ProviderUtil.setSqlArgs(params, values);
        return DialectFactory.getDialect().forUpdateBatchById(tableName, rows);
    }

    public static String selectOneById(Map params) {
        String tableName = ProviderUtil.getTableName(params);
        String[] primaryKeys = ProviderUtil.getPrimaryKeys(params);
        Object[] primaryValues = ProviderUtil.getPrimaryValues(params);
        ProviderUtil.setSqlArgs(params, primaryValues);
        return DialectFactory.getDialect().forSelectOneById(tableName, primaryKeys, primaryValues);
    }

    public static String selectListByQuery(Map params) {
        String tableName = ProviderUtil.getTableName(params);
        QueryWrapper queryWrapper = ProviderUtil.getQueryWrapper(params);
        CPI.setFromIfNecessary(queryWrapper, tableName);
        Object[] valueArray = CPI.getValueArray(queryWrapper);
        ProviderUtil.setSqlArgs(params, valueArray);
        return DialectFactory.getDialect().forSelectListByQuery(queryWrapper);
    }

    public static String selectCountByQuery(Map params) {
        String tableName = ProviderUtil.getTableName(params);
        QueryWrapper queryWrapper = ProviderUtil.getQueryWrapper(params);
        CPI.setFromIfNecessary(queryWrapper, tableName);
        Object[] valueArray = CPI.getValueArray(queryWrapper);
        ProviderUtil.setSqlArgs(params, valueArray);
        return DialectFactory.getDialect().forSelectCountByQuery(queryWrapper);
    }
}

