/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.BaseQueryWrapper;
import com.mybatisflex.core.query.Join;
import com.mybatisflex.core.query.Joiner;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryOrderBy;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.SelectQueryTable;
import com.mybatisflex.core.query.SqlConnector;
import com.mybatisflex.core.query.StringQueryCondition;
import com.mybatisflex.core.query.StringQueryOrderBy;
import com.mybatisflex.core.query.UnionWrapper;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.table.TableDef;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class QueryWrapper
extends BaseQueryWrapper<QueryWrapper> {
    public static QueryWrapper create() {
        return new QueryWrapper();
    }

    public QueryWrapper select(QueryColumn ... queryColumns) {
        for (QueryColumn column : queryColumns) {
            if (column == null) continue;
            this.addSelectColumn(column);
        }
        return this;
    }

    public QueryWrapper from(TableDef ... tableDefs) {
        for (TableDef tableDef : tableDefs) {
            this.from(new QueryTable(tableDef.getTableName()));
        }
        return this;
    }

    public QueryWrapper from(String ... tables) {
        for (String table : tables) {
            if (StringUtil.isBlank(table)) {
                throw new IllegalArgumentException("table must not be null or blank.");
            }
            this.from(new QueryTable(table));
        }
        return this;
    }

    public QueryWrapper from(QueryTable ... tables) {
        if (CollectionUtil.isEmpty(this.queryTables)) {
            this.queryTables = new ArrayList();
            this.queryTables.addAll(Arrays.asList(tables));
        } else {
            for (QueryTable table : tables) {
                boolean contains = false;
                for (QueryTable queryTable : this.queryTables) {
                    if (!queryTable.isSameTable(table)) continue;
                    contains = true;
                }
                if (contains) continue;
                this.queryTables.add(table);
            }
        }
        return this;
    }

    public QueryWrapper from(QueryWrapper queryWrapper) {
        return this.from(new SelectQueryTable(queryWrapper));
    }

    public QueryWrapper as(String alias) {
        if (CollectionUtil.isEmpty(this.queryTables)) {
            throw new IllegalArgumentException("query table must not be empty.");
        }
        if (this.queryTables.size() > 1) {
            throw FlexExceptions.wrap("QueryWrapper.as(...) only support 1 table", new Object[0]);
        }
        ((QueryTable)this.queryTables.get((int)0)).alias = alias;
        return this;
    }

    public QueryWrapper where(QueryCondition queryCondition) {
        this.setWhereQueryCondition(queryCondition);
        return this;
    }

    public QueryWrapper where(String sql) {
        this.setWhereQueryCondition(new StringQueryCondition(sql));
        return this;
    }

    public QueryWrapper where(String sql, Object ... params) {
        this.setWhereQueryCondition(new StringQueryCondition(sql, params));
        return this;
    }

    public QueryWrapper where(Map<String, Object> whereConditions) {
        if (whereConditions != null) {
            whereConditions.forEach((s, o) -> this.and(QueryCondition.create(new QueryColumn((String)s), o)));
        }
        return this;
    }

    public QueryWrapper and(QueryCondition queryCondition) {
        return (QueryWrapper)this.addWhereQueryCondition(queryCondition, SqlConnector.AND);
    }

    public QueryWrapper and(String sql) {
        this.addWhereQueryCondition(new StringQueryCondition(sql), SqlConnector.AND);
        return this;
    }

    public QueryWrapper and(String sql, Object ... params) {
        this.addWhereQueryCondition(new StringQueryCondition(sql, params), SqlConnector.AND);
        return this;
    }

    public QueryWrapper or(QueryCondition queryCondition) {
        return (QueryWrapper)this.addWhereQueryCondition(queryCondition, SqlConnector.OR);
    }

    public QueryWrapper or(String sql) {
        this.addWhereQueryCondition(new StringQueryCondition(sql), SqlConnector.OR);
        return this;
    }

    public QueryWrapper or(String sql, Object ... params) {
        this.addWhereQueryCondition(new StringQueryCondition(sql, params), SqlConnector.OR);
        return this;
    }

    public Joiner<QueryWrapper> leftJoin(String table) {
        return this.joining(" LEFT JOIN ", table, true);
    }

    public Joiner<QueryWrapper> leftJoinIf(String table, boolean condition) {
        return this.joining(" LEFT JOIN ", table, condition);
    }

    public Joiner<QueryWrapper> leftJoin(TableDef table) {
        return this.joining(" LEFT JOIN ", table.getTableName(), true);
    }

    public Joiner<QueryWrapper> leftJoinIf(TableDef table, boolean condition) {
        return this.joining(" LEFT JOIN ", table.getTableName(), condition);
    }

    public Joiner<QueryWrapper> leftJoin(QueryWrapper table) {
        return this.joining(" LEFT JOIN ", table, true);
    }

    public Joiner<QueryWrapper> leftJoinIf(QueryWrapper table, boolean condition) {
        return this.joining(" LEFT JOIN ", table, condition);
    }

    public Joiner<QueryWrapper> rightJoin(String table) {
        return this.joining(" RIGHT JOIN ", table, true);
    }

    public Joiner<QueryWrapper> rightJoinIf(String table, boolean condition) {
        return this.joining(" RIGHT JOIN ", table, condition);
    }

    public Joiner<QueryWrapper> rightJoin(QueryWrapper table) {
        return this.joining(" RIGHT JOIN ", table, true);
    }

    public Joiner<QueryWrapper> rightJoinIf(QueryWrapper table, boolean condition) {
        return this.joining(" RIGHT JOIN ", table, condition);
    }

    public Joiner<QueryWrapper> innerJoin(String table) {
        return this.joining(" INNER JOIN ", table, true);
    }

    public Joiner<QueryWrapper> innerJoinIf(String table, boolean condition) {
        return this.joining(" INNER JOIN ", table, condition);
    }

    public Joiner<QueryWrapper> innerJoin(TableDef table) {
        return this.innerJoinIf(table, true);
    }

    public Joiner<QueryWrapper> innerJoinIf(TableDef table, boolean condition) {
        return this.joining(" INNER JOIN ", table.getTableName(), condition);
    }

    public Joiner<QueryWrapper> innerJoin(QueryWrapper table) {
        return this.joining(" INNER JOIN ", table, true);
    }

    public Joiner<QueryWrapper> innerJoinIf(QueryWrapper table, boolean condition) {
        return this.joining(" INNER JOIN ", table, condition);
    }

    public Joiner<QueryWrapper> fullJoin(String table) {
        return this.joining(" FULL JOIN ", table, true);
    }

    public Joiner<QueryWrapper> fullJoinIf(String table, boolean condition) {
        return this.joining(" FULL JOIN ", table, condition);
    }

    public Joiner<QueryWrapper> fullJoin(QueryWrapper table) {
        return this.joining(" FULL JOIN ", table, true);
    }

    public Joiner<QueryWrapper> fullJoinIf(QueryWrapper table, boolean condition) {
        return this.joining(" FULL JOIN ", table, condition);
    }

    public Joiner<QueryWrapper> crossJoin(String table) {
        return this.joining(" CROSS JOIN ", table, true);
    }

    public Joiner<QueryWrapper> crossJoinIf(String table, boolean condition) {
        return this.joining(" CROSS JOIN ", table, condition);
    }

    public Joiner<QueryWrapper> crossJoin(QueryWrapper table) {
        return this.joining(" CROSS JOIN ", table, true);
    }

    public Joiner<QueryWrapper> crossJoinIf(QueryWrapper table, boolean condition) {
        return this.joining(" CROSS JOIN ", table, condition);
    }

    public QueryWrapper union(QueryWrapper unionQuery) {
        if (this.unions == null) {
            this.unions = new ArrayList();
        }
        this.unions.add(UnionWrapper.union(unionQuery));
        return this;
    }

    public QueryWrapper unionAll(QueryWrapper unionQuery) {
        if (this.unions == null) {
            this.unions = new ArrayList();
        }
        this.unions.add(UnionWrapper.unionAll(unionQuery));
        return this;
    }

    protected Joiner<QueryWrapper> joining(String type, String table, boolean condition) {
        Join join = new Join(type, table, condition);
        this.addJoinTable(join.getQueryTable());
        return new Joiner<QueryWrapper>((QueryWrapper)this.AddJoin(join), join);
    }

    protected Joiner<QueryWrapper> joining(String type, QueryWrapper queryWrapper, boolean condition) {
        Join join = new Join(type, queryWrapper, condition);
        this.addJoinTable(join.getQueryTable());
        return new Joiner<QueryWrapper>((QueryWrapper)this.AddJoin(join), join);
    }

    public QueryWrapper groupBy(String name) {
        this.addGroupByColumns(new QueryColumn(name));
        return this;
    }

    public QueryWrapper groupBy(String ... names) {
        for (String name : names) {
            this.groupBy(name);
        }
        return this;
    }

    public QueryWrapper groupBy(QueryColumn column) {
        this.addGroupByColumns(column);
        return this;
    }

    public QueryWrapper groupBy(QueryColumn ... columns) {
        for (QueryColumn column : columns) {
            this.groupBy(column);
        }
        return this;
    }

    public QueryWrapper having(QueryCondition queryCondition) {
        this.addHavingQueryCondition(queryCondition, SqlConnector.AND);
        return this;
    }

    public QueryWrapper orderBy(QueryOrderBy ... orderBys) {
        for (QueryOrderBy queryOrderBy : orderBys) {
            this.addOrderBy(queryOrderBy);
        }
        return this;
    }

    public QueryWrapper orderBy(String ... orderBys) {
        for (String queryOrderBy : orderBys) {
            this.addOrderBy(new StringQueryOrderBy(queryOrderBy));
        }
        return this;
    }

    public QueryWrapper limit(Integer rows) {
        this.setLimitRows(rows);
        return this;
    }

    public QueryWrapper offset(Integer offset) {
        this.setLimitOffset(offset);
        return this;
    }

    public QueryWrapper limit(Integer offset, Integer rows) {
        this.setLimitOffset(offset);
        this.setLimitRows(rows);
        return this;
    }

    public QueryWrapper datasource(String datasource) {
        this.setDataSource(datasource);
        return this;
    }

    Object[] getValueArray() {
        ArrayList<Object> tableValues = null;
        List<QueryTable> queryTables = this.getQueryTables();
        if (CollectionUtil.isNotEmpty(queryTables)) {
            for (QueryTable queryTable : queryTables) {
                Object[] tableValueArray = queryTable.getValueArray();
                if (tableValueArray.length <= 0) continue;
                if (tableValues == null) {
                    tableValues = new ArrayList<Object>();
                }
                tableValues.addAll(Arrays.asList(tableValueArray));
            }
        }
        ArrayList joinValues = null;
        List<Join> joins = this.getJoins();
        if (CollectionUtil.isNotEmpty(joins)) {
            for (Join join : joins) {
                QueryCondition onCondition;
                Object[] values;
                QueryTable joinTable = join.getQueryTable();
                Object[] valueArray = joinTable.getValueArray();
                if (valueArray.length > 0) {
                    if (joinValues == null) {
                        joinValues = new ArrayList();
                    }
                    joinValues.addAll(Arrays.asList(valueArray));
                }
                if ((values = WrapperUtil.getValues(onCondition = join.getOnCondition())).length <= 0) continue;
                if (joinValues == null) {
                    joinValues = new ArrayList();
                }
                joinValues.addAll(Arrays.asList(values));
            }
        }
        Object[] whereValues = WrapperUtil.getValues(this.whereQueryCondition);
        Object[] havingValues = WrapperUtil.getValues(this.havingQueryCondition);
        Object[] paramValues = ArrayUtil.concat(whereValues, havingValues);
        if (CollectionUtil.isNotEmpty(this.unions)) {
            for (UnionWrapper union : this.unions) {
                QueryWrapper queryWrapper = union.getQueryWrapper();
                paramValues = ArrayUtil.concat(paramValues, queryWrapper.getValueArray());
            }
        }
        Object[] returnValues = tableValues == null ? WrapperUtil.NULL_PARA_ARRAY : tableValues.toArray();
        returnValues = joinValues != null ? ArrayUtil.concat(returnValues, joinValues.toArray()) : returnValues;
        returnValues = ArrayUtil.concat(returnValues, paramValues);
        return returnValues;
    }

    List<QueryWrapper> getChildSelect() {
        List<QueryWrapper> whereChildQuery = WrapperUtil.getChildSelect(this.whereQueryCondition);
        List<QueryWrapper> havingChildQuery = WrapperUtil.getChildSelect(this.havingQueryCondition);
        if (whereChildQuery.isEmpty() && havingChildQuery.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<QueryWrapper> childQueryWrappers = new ArrayList<QueryWrapper>(whereChildQuery);
        childQueryWrappers.addAll(havingChildQuery);
        return childQueryWrappers;
    }
}

