/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.audit.http;

import com.mybatisflex.core.audit.AuditMessage;
import com.mybatisflex.core.audit.MessageReporter;
import com.mybatisflex.core.audit.http.HashUtil;
import com.mybatisflex.core.audit.http.HttpUtil;
import java.util.List;

public class HttpMessageReporter
implements MessageReporter {
    private String endpoint;
    private String secretKey;
    private JSONFormatter jsonFormatter;

    public HttpMessageReporter(String endpoint, String secretKey, JSONFormatter jsonFormatter) {
        this.endpoint = endpoint;
        this.secretKey = secretKey;
        this.jsonFormatter = jsonFormatter;
    }

    @Override
    public void sendMessages(List<AuditMessage> messages) {
        long timeMillis = System.currentTimeMillis();
        String sign = HashUtil.md5(this.secretKey + timeMillis);
        String url = this.endpoint + "?time=" + timeMillis + "&sign=" + sign;
        HttpUtil.post(url, this.jsonFormatter.toJSONString(messages));
    }

    public static interface JSONFormatter {
        public String toJSONString(Object var1);
    }
}

