/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.handler.BaseJsonTypeHandler;
import java.io.IOException;

public class JacksonTypeHandler
extends BaseJsonTypeHandler<Object> {
    private static ObjectMapper objectMapper;
    private final Class<?> propertyType;

    public JacksonTypeHandler(Class<?> propertyType) {
        this.propertyType = propertyType;
    }

    @Override
    protected Object parseJson(String json) {
        try {
            return JacksonTypeHandler.getObjectMapper().readValue(json, this.propertyType);
        }
        catch (IOException e) {
            throw FlexExceptions.wrap(e, "Can not parseJson by JacksonTypeHandler: " + json, new Object[0]);
        }
    }

    @Override
    protected String toJson(Object object) {
        try {
            return JacksonTypeHandler.getObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw FlexExceptions.wrap(e, "Can not convert object to Json by JacksonTypeHandler: " + object, new Object[0]);
        }
    }

    public static ObjectMapper getObjectMapper() {
        if (null == objectMapper) {
            objectMapper = new ObjectMapper();
        }
        return objectMapper;
    }

    public static void setObjectMapper(ObjectMapper objectMapper) {
        JacksonTypeHandler.objectMapper = objectMapper;
    }
}

