/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.mask;

import com.mybatisflex.core.mask.MaskProcesser;
import com.mybatisflex.core.mask.Masks;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class MaskManager {
    private static Map<String, MaskProcesser> processerMap = new HashMap<String, MaskProcesser>();
    private static ThreadLocal<Boolean> skipFlags;

    public static void registerMaskProcesser(String type, MaskProcesser processer) {
        processerMap.put(type, processer);
    }

    public static <T> T withoutMask(Supplier<T> supplier) {
        try {
            MaskManager.skipMask();
            T t = supplier.get();
            return t;
        }
        finally {
            MaskManager.restoreMask();
        }
    }

    public static void skipMask() {
        skipFlags.set(Boolean.TRUE);
    }

    public static void restoreMask() {
        skipFlags.remove();
    }

    public static Object mask(String type, Object data) {
        Boolean skipMask = skipFlags.get();
        if (skipMask != null && skipMask.booleanValue()) {
            return data;
        }
        MaskProcesser maskProcesser = processerMap.get(type);
        if (maskProcesser == null) {
            throw new IllegalStateException("Can not get mask processer for by type: " + type);
        }
        return maskProcesser.mask(data);
    }

    static {
        MaskManager.registerMaskProcesser("mobile", Masks.MOBILE_PROCESSER);
        MaskManager.registerMaskProcesser("fixed_phone", Masks.FIXED_PHONE_PROCESSER);
        MaskManager.registerMaskProcesser("id_card_number", Masks.ID_CARD_NUMBER_PROCESSER);
        MaskManager.registerMaskProcesser("chinese_name", Masks.CHINESE_NAME_PROCESSER);
        MaskManager.registerMaskProcesser("address", Masks.ADDRESS_PROCESSER);
        MaskManager.registerMaskProcesser("email", Masks.EMAIL_PROCESSER);
        MaskManager.registerMaskProcesser("password", Masks.PASSWORD_PROCESSER);
        MaskManager.registerMaskProcesser("car_license", Masks.CAR_LICENSE_PROCESSER);
        MaskManager.registerMaskProcesser("bank_card_number", Masks.BANK_CARD_PROCESSER);
        skipFlags = new ThreadLocal();
    }
}

