/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.SqlConnector;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.List;

public class Brackets
extends QueryCondition {
    private QueryCondition childCondition;

    public Brackets(QueryCondition childCondition) {
        this.childCondition = childCondition;
    }

    @Override
    public QueryCondition and(QueryCondition nextCondition) {
        this.connectToChild(nextCondition, SqlConnector.AND);
        return this;
    }

    @Override
    public QueryCondition or(QueryCondition nextCondition) {
        this.connectToChild(nextCondition, SqlConnector.OR);
        return this;
    }

    protected void connectToChild(QueryCondition nextCondition, SqlConnector connector) {
        this.childCondition.connect(nextCondition, connector);
    }

    @Override
    public Object getValue() {
        return this.checkEffective() ? WrapperUtil.getValues(this.childCondition) : null;
    }

    public QueryCondition getChildCondition() {
        return this.childCondition;
    }

    @Override
    public boolean checkEffective() {
        boolean effective = super.checkEffective();
        if (!effective) {
            return false;
        }
        QueryCondition condition = this.childCondition;
        while (condition != null) {
            if (condition.checkEffective()) {
                return true;
            }
            condition = condition.next;
        }
        return false;
    }

    @Override
    public String toSql(List<QueryTable> queryTables, IDialect dialect) {
        String sqlNext = this.next == null ? null : this.next.toSql(queryTables, dialect);
        StringBuilder sql = new StringBuilder();
        if (this.checkEffective()) {
            String childSql = this.childCondition.toSql(queryTables, dialect);
            if (StringUtil.isNotBlank(childSql)) {
                QueryCondition effectiveBefore = this.getEffectiveBefore();
                if (effectiveBefore != null) {
                    childSql = (Object)((Object)effectiveBefore.connector) + "(" + childSql + ")";
                } else if (StringUtil.isNotBlank(sqlNext)) {
                    childSql = "(" + childSql + ")";
                }
                sql.append(childSql);
            } else {
                this.effective = false;
            }
        }
        return sqlNext != null ? sql + sqlNext : sql.toString();
    }

    @Override
    public String toString() {
        return "Brackets{childCondition=" + this.childCondition + '}';
    }
}

