/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.audit;

import com.mybatisflex.core.audit.AuditMessage;
import com.mybatisflex.core.audit.MessageFactory;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class DefaultMessageFactory
implements MessageFactory {
    private final String platform = "mybatis-flex";
    private final String hostIp = DefaultMessageFactory.getHostIp();

    @Override
    public AuditMessage create() {
        AuditMessage message = new AuditMessage();
        message.setPlatform("mybatis-flex");
        message.setHostIp(this.hostIp);
        return message;
    }

    private static String getHostIp() {
        try {
            Enumeration<NetworkInterface> net = NetworkInterface.getNetworkInterfaces();
            while (net.hasMoreElements()) {
                NetworkInterface networkInterface = net.nextElement();
                if (networkInterface.isLoopback() || networkInterface.isVirtual() || !networkInterface.isUp()) continue;
                Enumeration<InetAddress> addrs = networkInterface.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (!(addr instanceof Inet4Address)) continue;
                    return addr.getHostAddress();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "127.0.0.1";
    }
}

