/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.keygen.impl;

import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.keygen.IKeyGenerator;
import com.mybatisflex.core.util.StringUtil;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;

public class SnowFlakeIDKeyGenerator
implements IKeyGenerator {
    private static final long WORKER_ID_BITS = 5L;
    private static final long DATA_CENTER_ID_BITS = 5L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long MAX_WORKER_ID = 31L;
    private static final long MAX_DATA_CENTER_ID = 31L;
    private static final long SEQUENCE_MASK = 4095L;
    private static final long WORK_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_SHIFT = 22L;
    protected static long twepoch = 1680411660000L;
    protected static long offsetPeriod = 5L;
    private final long workerId;
    private final long dataCenterId;
    protected InetAddress address;
    private long sequence;
    private long lastTimeMillis = -1L;

    public SnowFlakeIDKeyGenerator() {
        this(null);
    }

    public SnowFlakeIDKeyGenerator(InetAddress address) {
        this.address = address;
        this.dataCenterId = this.getDataCenterId(31L);
        this.workerId = this.getWorkerId(this.dataCenterId, 31L);
    }

    public SnowFlakeIDKeyGenerator(long workerId, long dataCenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("workerId must be greater than 0 and less than %d.", 31L));
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("dataCenterId must be greater than 0 and less than %d.", 31L));
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
    }

    protected long getWorkerId(long dataCenterId, long maxWorkerId) {
        StringBuilder mpId = new StringBuilder();
        mpId.append(dataCenterId);
        String name = ManagementFactory.getRuntimeMXBean().getName();
        if (StringUtil.isNotBlank(name)) {
            mpId.append(name.split("@")[0]);
        }
        return (long)(mpId.toString().hashCode() & 0xFFFF) % (maxWorkerId + 1L);
    }

    protected long getDataCenterId(long maxDataCenterId) {
        long id = 0L;
        try {
            NetworkInterface network;
            if (this.address == null) {
                this.address = InetAddress.getLocalHost();
            }
            if (null == (network = NetworkInterface.getByInetAddress(this.address))) {
                id = 1L;
            } else {
                byte[] mac = network.getHardwareAddress();
                if (null != mac) {
                    id = (0xFFL & (long)mac[mac.length - 2] | 0xFF00L & (long)mac[mac.length - 1] << 8) >> 6;
                    id %= maxDataCenterId + 1L;
                }
            }
        }
        catch (Exception e) {
            throw FlexExceptions.wrap(e, "dataCenterId: %s", e.getMessage());
        }
        return id;
    }

    @Override
    public Object generate(Object entity, String keyColumn) {
        return this.nextId();
    }

    public synchronized long nextId() {
        long currentTimeMillis;
        block8: {
            currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis < this.lastTimeMillis) {
                long offset = this.lastTimeMillis - currentTimeMillis;
                if (offset <= offsetPeriod) {
                    try {
                        this.wait(offset << 1);
                        currentTimeMillis = System.currentTimeMillis();
                        if (currentTimeMillis < this.lastTimeMillis) {
                            throw FlexExceptions.wrap("Clock moved backwards, please check the time. Current timestamp: %d, last used timestamp: %d", currentTimeMillis, this.lastTimeMillis);
                        }
                        break block8;
                    }
                    catch (InterruptedException e) {
                        throw FlexExceptions.wrap(e);
                    }
                }
                throw FlexExceptions.wrap("Clock moved backwards, please check the time. Current timestamp: %d, last used timestamp: %d", currentTimeMillis, this.lastTimeMillis);
            }
        }
        if (currentTimeMillis == this.lastTimeMillis) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currentTimeMillis = this.tilNextMillis(this.lastTimeMillis);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimeMillis = currentTimeMillis;
        return currentTimeMillis - twepoch << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long currentTimeMillis = System.currentTimeMillis();
        while (currentTimeMillis <= lastTimestamp) {
            currentTimeMillis = System.currentTimeMillis();
        }
        return currentTimeMillis;
    }
}

